/*
 * Decompiled with CFR 0.152.
 */
package de.viaboxx.nlstools.tasks;

import de.viaboxx.nlstools.formats.MBPersistencer;
import de.viaboxx.nlstools.model.MBBundle;
import de.viaboxx.nlstools.model.MBBundles;
import de.viaboxx.nlstools.model.MBEntry;
import de.viaboxx.nlstools.model.MBText;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.StringTokenizer;
import org.apache.commons.lang3.StringUtils;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MergeLocaleTask
extends Task {
    private File from;
    private File with;
    private File to;
    private String locales;
    private String bundleNames;
    private Set<String> namesFilter;
    protected MBBundles loadedBundles;
    protected MBBundles translatedBundles;

    public File getFrom() {
        return this.from;
    }

    public void setFrom(File from) {
        this.from = from;
    }

    public File getTo() {
        return this.to;
    }

    public void setTo(File to) {
        this.to = to;
    }

    public File getWith() {
        return this.with;
    }

    public void setWith(File xmlWithNewLocale) {
        this.with = xmlWithNewLocale;
    }

    public String getBundleNames() {
        return this.bundleNames;
    }

    public void setBundleNames(String bundleNames) {
        this.bundleNames = bundleNames;
    }

    public String getLocales() {
        return this.locales;
    }

    public void setLocales(String locales) {
        this.locales = locales;
    }

    public void execute() {
        try {
            this.loadExecute();
            this.processExecute();
            this.outputExecute();
        }
        catch (Exception e) {
            throw new BuildException((Throwable)e);
        }
    }

    public static StringTokenizer tokenize(String input) {
        return new StringTokenizer(input, ",;");
    }

    public static String localesString(Set<String> locales) {
        ArrayList<String> list = new ArrayList<String>(locales);
        Collections.sort(list);
        StringBuilder buf = new StringBuilder();
        for (String each : list) {
            buf.append(each);
            buf.append(",");
        }
        return buf.toString();
    }

    public static String localesString(MBBundles bundles, String locales) {
        if (locales == null || locales.length() == 0) {
            return MergeLocaleTask.localesString(bundles.locales());
        }
        return locales;
    }

    protected boolean isBundleToProcess(MBBundle bundle) {
        if (this.namesFilter == null) {
            this.namesFilter = new HashSet<String>();
            if (!StringUtils.isEmpty((CharSequence)this.bundleNames)) {
                StringTokenizer tokens = MergeLocaleTask.tokenize(this.bundleNames);
                while (tokens.hasMoreTokens()) {
                    this.namesFilter.add(tokens.nextToken());
                }
            } else {
                this.namesFilter = Collections.emptySet();
            }
        }
        return this.namesFilter.isEmpty() || this.namesFilter.contains(bundle.getBaseName());
    }

    protected void processExecute() {
        if (this.loadedBundles != null) {
            this.setLocales(MergeLocaleTask.localesString(this.loadedBundles, this.getLocales()));
            for (MBBundle bundle : this.loadedBundles.getBundles()) {
                if (!this.isBundleToProcess(bundle)) {
                    this.getProject().log("Skipped " + bundle.getBaseName());
                    continue;
                }
                this.getProject().log("Merging " + bundle.getBaseName());
                for (MBEntry entry : bundle.getEntries()) {
                    StringTokenizer tokens = MergeLocaleTask.tokenize(this.locales);
                    while (tokens.hasMoreTokens()) {
                        MBText translatedText;
                        String locale = tokens.nextToken();
                        MBText tmpText = null;
                        for (MBText text : entry.getTexts()) {
                            if (!text.getLocale().equals(locale)) continue;
                            tmpText = text;
                        }
                        if (tmpText == null) {
                            tmpText = new MBText();
                            tmpText.setLocale(locale);
                            tmpText.setValue("");
                            entry.getTexts().add(tmpText);
                        }
                        if ((translatedText = this.findMBTextForLocale(entry.getKey(), locale, this.translatedBundles)) == null) continue;
                        tmpText.setValue(translatedText.getValue());
                    }
                }
            }
        }
    }

    protected void outputExecute() throws Exception {
        MBPersistencer.saveFile(this.loadedBundles, this.to);
        this.log("Writing to bundles to file " + this.to, 2);
    }

    protected void loadExecute() throws Exception {
        this.log("Reading Bundles from " + this.from, 2);
        this.loadedBundles = MBPersistencer.loadFile(this.from);
        this.log("Reading Bundles from " + this.with, 2);
        this.translatedBundles = MBPersistencer.loadFile(this.with);
    }

    protected MBText findMBTextForLocale(String key, String locale, MBBundles bundles) {
        if (bundles != null) {
            for (MBBundle bundle : bundles.getBundles()) {
                for (MBEntry entry : bundle.getEntries()) {
                    if (!entry.getKey().equals(key)) continue;
                    for (MBText text : entry.getTexts()) {
                        if (!text.getLocale().equals(locale)) continue;
                        return text;
                    }
                }
            }
        }
        return null;
    }
}

