/*
 * Decompiled with CFR 0.152.
 */
package de.viaboxx.nlstools.tasks;

import de.viaboxx.nlstools.formats.BundleWriter;
import de.viaboxx.nlstools.formats.BundleWriterFlexClass;
import de.viaboxx.nlstools.formats.BundleWriterGroovyEnum;
import de.viaboxx.nlstools.formats.BundleWriterJavaInterface;
import de.viaboxx.nlstools.formats.BundleWriterJson;
import de.viaboxx.nlstools.formats.BundleWriterProperties;
import de.viaboxx.nlstools.formats.MBPersistencer;
import de.viaboxx.nlstools.model.MBBundle;
import de.viaboxx.nlstools.model.MBBundles;
import de.viaboxx.nlstools.model.MBEntry;
import de.viaboxx.nlstools.model.MBText;
import de.viaboxx.nlstools.tasks.MergeLocaleTask;
import java.io.File;
import java.lang.reflect.Constructor;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.StringTokenizer;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;

public class MessageBundleTask
extends Task {
    protected String bundles;
    protected String sourcePath = ".";
    protected String propertyPath = ".";
    protected String jsonPath = ".";
    protected String jsonFile = null;
    private String sqlScriptDir = null;
    private boolean overwrite = false;
    private boolean deleteOldFiles = true;
    private String writeProperties = "false";
    private String writeJson = "false";
    private String writeInterface = "false";
    private String writeGroovyEnum = "false";
    private boolean writeSql = true;
    private String sqlDialect = "Oracle";
    private boolean debugMode = false;
    private Boolean flexLayout;
    private boolean preserveNewlines = false;
    private boolean merged = true;
    private String toCharset = null;
    private MBBundles parsedBundles;
    private String xmlConfigBundle;
    private Set<String> allowedLocales;
    private String exampleLocale;

    public String getToCharset() {
        return this.toCharset;
    }

    public void setToCharset(String toCharset) {
        this.toCharset = toCharset;
    }

    public String getJsonPath() {
        return this.jsonPath;
    }

    public void setJsonPath(String jsonPath) {
        this.jsonPath = this.getProject().resolveFile(jsonPath).getPath();
    }

    public boolean isFlexLayout() {
        return this.flexLayout != null && this.flexLayout != false;
    }

    public void setFlexLayout(boolean flexLayout) {
        this.flexLayout = flexLayout;
    }

    public boolean isMerged() {
        return this.merged;
    }

    public void setMerged(boolean merged) {
        this.merged = merged;
    }

    public void setDeleteOldFiles(boolean aDeleteOldFiles) {
        this.deleteOldFiles = aDeleteOldFiles;
    }

    public String getWriteProperties() {
        return this.writeProperties;
    }

    public void setWriteProperties(String aWriteProperties) {
        this.writeProperties = aWriteProperties;
    }

    public String getWriteJson() {
        return this.writeJson;
    }

    public boolean isWriteSql() {
        return this.writeSql;
    }

    public void setWriteSql(boolean writeSql) {
        this.writeSql = writeSql;
    }

    public String getSqlDialect() {
        return this.sqlDialect;
    }

    public void setSqlDialect(String sqlDialect) {
        this.sqlDialect = sqlDialect;
    }

    public String getWriteGroovyEnum() {
        return this.writeGroovyEnum;
    }

    public void setWriteGroovyEnum(String writeGroovyEnum) {
        this.writeGroovyEnum = writeGroovyEnum;
    }

    public void setWriteJson(String writeJson) {
        this.writeJson = writeJson;
    }

    public String getWriteInterface() {
        return this.writeInterface;
    }

    public void setWriteInterface(String aWriteInterface) {
        this.writeInterface = aWriteInterface;
    }

    public boolean isOverwrite() {
        return this.overwrite;
    }

    public void setOverwrite(boolean aOverwrite) {
        this.overwrite = aOverwrite;
    }

    public boolean isDebugMode() {
        return this.debugMode;
    }

    public void setDebugMode(boolean debugMode) {
        this.debugMode = debugMode;
    }

    public String getBundles() {
        return this.bundles;
    }

    public void setBundles(String aConfigFile) {
        this.bundles = aConfigFile;
    }

    public void setSourcePath(String aSourcePath) {
        this.sourcePath = this.getProject().resolveFile(aSourcePath).getPath();
    }

    public String getPropertyPath() {
        return this.propertyPath;
    }

    public void setPropertyPath(String aPropertyPath) {
        this.propertyPath = this.getProject().resolveFile(aPropertyPath).getPath();
    }

    public void execute() throws BuildException {
        try {
            for (MBBundle o : this.loadBundles().getBundles()) {
                this.handleInterface(o);
                this.handleProperties(o);
                this.handleJson(o);
                this.handleSql(o);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BuildException((Throwable)e);
        }
    }

    private void handleSql(MBBundle o) throws Exception {
        BundleWriter.FileType fileType = BundleWriter.FileType.NO;
        if (o.getSqldomain() != null && this.writeSql) {
            fileType = BundleWriter.FileType.SQL;
        }
        String clsName = "de.viaboxx.nlstools.formats.BundleWriterSql" + this.sqlDialect;
        this.log("writing SQL with " + clsName);
        Class<?> cls = Class.forName(clsName);
        Constructor<?> cons = cls.getConstructor(Task.class, String.class, MBBundle.class, String.class, BundleWriter.FileType.class, Set.class);
        BundleWriter writer = (BundleWriter)cons.newInstance(new Object[]{this, this.getXMLConfigBundle(), o, this.getSqlScriptDir(), fileType, this.allowedLocales});
        this.executeBundleWriter(writer);
    }

    private void handleInterface(MBBundle o) throws Exception {
        BundleWriter.FileType fileType;
        if (this.getWriteInterface().equalsIgnoreCase("small")) {
            fileType = BundleWriter.FileType.JAVA_SMALL;
        } else if (this.getWriteInterface().equalsIgnoreCase("false")) {
            fileType = BundleWriter.FileType.NO;
        } else if (this.getWriteInterface().equalsIgnoreCase("small_enum")) {
            fileType = BundleWriter.FileType.JAVA_ENUM_KEYS;
        } else if (this.getWriteInterface().equalsIgnoreCase("enum")) {
            fileType = BundleWriter.FileType.JAVA_FULL_ENUM_KEYS;
        } else if (this.getWriteInterface().equalsIgnoreCase("groovy-enum")) {
            fileType = BundleWriter.FileType.GROOVY_ENUM;
        } else {
            if (this.getWriteInterface().equalsIgnoreCase("Flex")) {
                BundleWriterFlexClass writer = new BundleWriterFlexClass(this, this.getXMLConfigBundle(), o, this.sourcePath, BundleWriter.FileType.FLEX_FULL, this.allowedLocales);
                writer.setExampleLocale(this.getExampleLocale());
                this.executeBundleWriter(writer);
                return;
            }
            if (this.getWriteInterface().equalsIgnoreCase("smallFlex")) {
                BundleWriterFlexClass writer = new BundleWriterFlexClass(this, this.getXMLConfigBundle(), o, this.sourcePath, BundleWriter.FileType.FLEX_SMALL, this.allowedLocales);
                writer.setExampleLocale(this.getExampleLocale());
                this.executeBundleWriter(writer);
                return;
            }
            fileType = BundleWriter.FileType.JAVA_FULL;
        }
        BundleWriterJavaInterface writer = fileType == BundleWriter.FileType.GROOVY_ENUM ? new BundleWriterGroovyEnum(this, this.getXMLConfigBundle(), o, this.sourcePath, fileType, this.allowedLocales) : new BundleWriterJavaInterface(this, this.getXMLConfigBundle(), o, this.sourcePath, fileType, this.allowedLocales);
        writer.setExampleLocale(this.getExampleLocale());
        this.executeBundleWriter(writer);
    }

    private void handleProperties(MBBundle o) throws Exception {
        BundleWriter.FileType fileType = this.getWriteProperties().equalsIgnoreCase("false") ? BundleWriter.FileType.NO : (this.getWriteProperties().equalsIgnoreCase("xml") ? BundleWriter.FileType.XML : BundleWriter.FileType.PROPERTIES);
        BundleWriterProperties writer = new BundleWriterProperties(this, this.getXMLConfigBundle(), o, this.getPropertyPath(), fileType, this.allowedLocales);
        writer.setMerged(this.isMerged());
        if (this.getToCharset() != null) {
            writer.setCharset(this.getToCharset());
        }
        this.executeBundleWriter(writer);
    }

    private void handleJson(MBBundle o) throws Exception {
        BundleWriter.FileType fileType = this.getWriteJson().equalsIgnoreCase("false") ? BundleWriter.FileType.NO : (this.getWriteJson().equalsIgnoreCase("pretty") ? BundleWriter.FileType.JS_PRETTY : (this.getWriteJson().equalsIgnoreCase("angular") ? BundleWriter.FileType.JS_ANGULAR : (this.getWriteJson().equalsIgnoreCase("angular_pretty") ? BundleWriter.FileType.JS_ANGULAR_PRETTY : BundleWriter.FileType.JS)));
        BundleWriterJson writer = BundleWriterJson.build(this, this.getXMLConfigBundle(), o, this.getJsonPath(), this.getJsonFile(), fileType, this.allowedLocales);
        writer.setMerged(this.isMerged());
        this.executeBundleWriter(writer);
    }

    public String getJsonFile() {
        return this.jsonFile;
    }

    public void setJsonFile(String jsonFile) {
        this.jsonFile = jsonFile;
    }

    private void executeBundleWriter(BundleWriter writer) throws Exception {
        if (this.flexLayout != null) {
            writer.setFlexLayout(this.isFlexLayout());
        }
        writer.setOverwrite(this.overwrite);
        writer.setDeleteOldFiles(this.deleteOldFiles);
        writer.setDebugMode(this.debugMode);
        writer.execute();
    }

    protected MBBundles loadBundles() throws Exception {
        if (this.parsedBundles == null) {
            StringTokenizer tokens = MergeLocaleTask.tokenize(this.getBundles());
            while (tokens.hasMoreTokens()) {
                String bundlesFileName = this.getProject().resolveFile(tokens.nextToken()).getPath();
                this.log("Reading bundles from " + bundlesFileName, 2);
                MBBundles loadedBundles = MBPersistencer.loadFile(new File(bundlesFileName));
                if (this.parsedBundles == null) {
                    this.parsedBundles = loadedBundles;
                    this.xmlConfigBundle = bundlesFileName;
                } else {
                    this.mergeBundles(loadedBundles);
                }
                if (!this.preserveNewlines) continue;
                for (MBBundle bundle : this.parsedBundles.getBundles()) {
                    for (MBEntry mbEntry : bundle.getEntries()) {
                        for (MBText mbText : mbEntry.getTexts()) {
                            mbText.setValue(mbText.getValue().replace("\\n", "\n"));
                        }
                    }
                }
            }
        }
        return this.parsedBundles;
    }

    private String getXMLConfigBundle() {
        return this.xmlConfigBundle;
    }

    private void mergeBundles(MBBundles loadedBundles) {
        this.log("Merge bundles ...", 3);
        for (MBBundle bundle : loadedBundles.getBundles()) {
            for (MBBundle parsedBundle : this.parsedBundles.getBundles()) {
                parsedBundle.getEntries().addAll(bundle.getEntries());
            }
        }
    }

    public String getSqlScriptDir() {
        return this.sqlScriptDir;
    }

    public void setSqlScriptDir(String aSqlScriptDir) {
        this.sqlScriptDir = this.getProject().resolveFile(aSqlScriptDir).getPath();
    }

    public boolean isPreserveNewlines() {
        return this.preserveNewlines;
    }

    public void setPreserveNewlines(boolean preserveNewlines) {
        this.preserveNewlines = preserveNewlines;
    }

    public void setAllowedLocales(String allowedLocales) {
        this.allowedLocales = new HashSet<String>(Arrays.asList(allowedLocales.split(";")));
    }

    public String getExampleLocale() {
        return this.exampleLocale;
    }

    public void setExampleLocale(String exampleLocale) {
        this.exampleLocale = exampleLocale;
    }
}

