/*
 * Decompiled with CFR 0.152.
 */
package de.viaboxx.nlstools.tasks;

import de.viaboxx.nlstools.formats.MBPersistencer;
import de.viaboxx.nlstools.model.MBBundle;
import de.viaboxx.nlstools.model.MBBundles;
import de.viaboxx.nlstools.model.MBEntry;
import de.viaboxx.nlstools.model.MBText;
import de.viaboxx.nlstools.tasks.CopyBundlesTask;
import java.io.File;
import java.util.Iterator;
import java.util.Map;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OptimizeBundlesTask
extends Task {
    private static final String DEFAULT_COMMON_BUNDLE_FILE = "Common.xml";
    private static final String DEFAULT_COMMON_BASE_NAME = "/Common";
    private File masterFile;
    private boolean deleteEmptyEntries = false;
    private String commonBundleFile = "Common.xml";
    private String commonBundleBaseName = "/Common";
    private String commonEntryKeyPrefix = null;

    public boolean isDeleteEmptyEntries() {
        return this.deleteEmptyEntries;
    }

    public void setDeleteEmptyEntries(boolean deleteEmptyEntries) {
        this.deleteEmptyEntries = deleteEmptyEntries;
    }

    public File getMasterFile() {
        return this.masterFile;
    }

    public void setMasterFile(File masterFile) {
        this.masterFile = masterFile;
    }

    public String getCommonBundleFile() {
        return this.commonBundleFile;
    }

    public void setCommonBundleFile(String commonBundleFile) {
        this.commonBundleFile = commonBundleFile;
    }

    public String getCommonBundleBaseName() {
        return this.commonBundleBaseName;
    }

    public void setCommonBundleBaseName(String commonBundleBaseName) {
        this.commonBundleBaseName = commonBundleBaseName;
    }

    public String getCommonEntryKeyPrefix() {
        return this.commonEntryKeyPrefix;
    }

    public void setCommonEntryKeyPrefix(String commonEntryKeyPrefix) {
        this.commonEntryKeyPrefix = commonEntryKeyPrefix;
    }

    public void execute() {
        if (this.masterFile == null) {
            throw new BuildException("masterFile required");
        }
        try {
            Map<String, File> mappings = CopyBundlesTask.readControlFileMapping(this.masterFile);
            MBBundle commonBundle = this.loadCommonBundle(mappings);
            for (Map.Entry<String, File> fileentry : mappings.entrySet()) {
                File source = fileentry.getValue();
                MBPersistencer persistencer = MBPersistencer.forFile(source);
                MBBundles bundles = persistencer.load(source);
                boolean modified = false;
                for (MBBundle bundle : bundles.getBundles()) {
                    if (fileentry.getKey().equals(this.getCommonBundleFile()) && bundle.getBaseName().equals(this.getCommonBundleBaseName())) continue;
                    for (MBEntry entry : bundle.getEntries()) {
                        MBEntry commonEntry = this.findDefaultEntry(entry, commonBundle);
                        if (commonEntry == null) continue;
                        Iterator<MBText> iterator = entry.getTexts().iterator();
                        while (iterator.hasNext()) {
                            MBText mbText;
                            MBText text = mbText = iterator.next();
                            MBText commonText = commonEntry.getText(text.getLocale());
                            if (text.getValue() == null || text.getValue().length() <= 0 || commonText == null || commonText.getValue() == null || !commonText.getValue().equals(text.getValue())) continue;
                            this.log("Using default at " + source + ": " + entry.getKey() + "[" + text.getLocale() + "]");
                            modified = true;
                            text.setValue(null);
                            text.setUseDefault(true);
                        }
                    }
                }
                if (!modified) continue;
                if (this.isDeleteEmptyEntries()) {
                    this.truncateBundles(bundles);
                }
                this.log("SAVING modified file: " + source);
                bundles.sort();
                persistencer.save(bundles, source);
            }
        }
        catch (Exception ex) {
            throw new BuildException((Throwable)ex);
        }
    }

    private void truncateBundles(MBBundles bundles) {
        for (MBBundle bundle : bundles.getBundles()) {
            Iterator<MBEntry> iterator1 = bundle.getEntries().iterator();
            while (iterator1.hasNext()) {
                MBEntry entry = iterator1.next();
                boolean isEntryEmpty = true;
                Iterator<MBText> iterator = entry.getTexts().iterator();
                while (iterator.hasNext()) {
                    MBText text = iterator.next();
                    if (text.getValue() != null && text.getValue().length() != 0) continue;
                    iterator.remove();
                    this.log("Removed empty text " + entry.getKey() + ", locale: " + text.getLocale());
                }
                if (!entry.getTexts().isEmpty()) continue;
                iterator1.remove();
                this.log("Removed empty entry " + entry.getKey());
            }
        }
    }

    private MBEntry findDefaultEntry(MBEntry nlsEntry, MBBundle commonBundle) {
        MBEntry commonEntry = null;
        if (nlsEntry.getKey() == null) {
            return null;
        }
        String nlsKey = nlsEntry.getKey();
        if (this.commonEntryKeyPrefix == null) {
            commonEntry = commonBundle.getEntry(nlsKey);
        } else {
            int idx = nlsKey.lastIndexOf(46);
            if (idx >= 0) {
                String commonKey = this.getCommonEntryKeyPrefix() + nlsKey.substring(idx);
                commonEntry = commonBundle.getEntry(commonKey);
            }
        }
        return commonEntry;
    }

    private MBBundle loadCommonBundle(Map<String, File> mappings) throws Exception {
        File commonFile = mappings.get(this.getCommonBundleFile());
        if (commonFile == null) {
            throw new BuildException(this.getCommonBundleFile() + " not found in " + mappings);
        }
        MBBundles commonBundles = MBPersistencer.loadFile(commonFile);
        MBBundle commonBundle = commonBundles.getBundle(this.getCommonBundleBaseName());
        if (commonBundle == null) {
            throw new BuildException(this.getCommonBundleBaseName() + " not found in " + commonFile);
        }
        return commonBundle;
    }
}

