/*
 * Decompiled with CFR 0.152.
 */
package de.viaboxx.nlstools.formats;

import de.viaboxx.nlstools.formats.BundleWriter;
import de.viaboxx.nlstools.formats.BundleWriterAngularJS;
import de.viaboxx.nlstools.formats.BundleWriterNg2Translate;
import de.viaboxx.nlstools.formats.MBJSONPersistencer;
import de.viaboxx.nlstools.model.MBBundle;
import de.viaboxx.nlstools.tasks.MessageBundleTask;
import java.io.File;
import java.util.Properties;
import java.util.Set;
import org.apache.tools.ant.Task;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BundleWriterJson
extends BundleWriter {
    private final String outputFile;
    private boolean merged = true;

    public void setMerged(boolean merged) {
        this.merged = merged;
    }

    public String getOutputFile() {
        return this.outputFile;
    }

    public boolean isMerged() {
        return this.merged;
    }

    public BundleWriterJson(Task task, String configFile, MBBundle currentBundle, String outputPath, String outputFile, BundleWriter.FileType fileType, Set<String> allowedLocales) {
        super(task, configFile, currentBundle, outputPath, fileType, allowedLocales);
        this.outputFile = outputFile;
    }

    @Override
    protected void writeOutputFilePerLocale(String locale) throws Exception {
        String jsfile = this.getFileName(locale);
        this.mkdirs(jsfile);
        this.task.log("writing json file " + jsfile, 2);
        Properties mergedProperties = this.createProperties(locale, this.merged);
        MBJSONPersistencer writer = new MBJSONPersistencer(this.fileType == BundleWriter.FileType.JS_PRETTY);
        writer.saveObject(mergedProperties, new File(jsfile));
    }

    @Override
    protected StringBuilder buildOutputFileNameBase() {
        StringBuilder fileName = new StringBuilder();
        fileName.append(this.getOutputPath());
        fileName.append("/");
        if (this.outputFile == null) {
            fileName.append(this.getCurrentBundle().getBaseName());
        } else {
            fileName.append(this.outputFile);
        }
        return fileName;
    }

    @Override
    protected String suffix() {
        return ".js";
    }

    public static BundleWriterJson build(MessageBundleTask task, String configFile, MBBundle currentBundle, String outputPath, String outputFile, BundleWriter.FileType fileType, Set<String> allowedLocales) {
        switch (fileType) {
            case NG2_TRANSLATE: {
                return new BundleWriterNg2Translate((Task)task, configFile, outputPath, outputFile, fileType, allowedLocales);
            }
            case JS_ANGULAR: 
            case JS_ANGULAR_PRETTY: {
                return new BundleWriterAngularJS(task, configFile, currentBundle, outputPath, outputFile, fileType, allowedLocales);
            }
        }
        return new BundleWriterJson(task, configFile, currentBundle, outputPath, outputFile, fileType, allowedLocales);
    }
}

