/*
 * Decompiled with CFR 0.152.
 */
package de.viaboxx.nlstools.formats;

import de.viaboxx.nlstools.formats.BundleWriter;
import de.viaboxx.nlstools.formats.BundleWriterJson;
import de.viaboxx.nlstools.formats.MBJSONPersistencer;
import de.viaboxx.nlstools.model.MBBundle;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import org.apache.tools.ant.Task;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BundleWriterNg2Translate
extends BundleWriterJson {
    private boolean bundlesGenerated = false;

    public BundleWriterNg2Translate(Task task, String configFile, String outputPath, String outputFile, BundleWriter.FileType fileType, Set<String> allowedLocales) {
        super(task, configFile, null, outputPath, outputFile, fileType, allowedLocales);
    }

    @Override
    protected boolean needsNewFiles() throws FileNotFoundException {
        return !this.bundlesGenerated;
    }

    @Override
    protected void writeOutputFiles() throws Exception {
        this.deleteFiles();
        for (String locale : this.getLocalesUsed()) {
            if (!this.allowedLocales.isEmpty() && !this.allowedLocales.contains(locale)) continue;
            this.writeOutputFilePerLocale(locale);
        }
        this.bundlesGenerated = true;
    }

    @Override
    protected List<String> getLocalesUsed() {
        if (this.myUsedLocales == null) {
            HashSet<String> locales = new HashSet<String>();
            for (MBBundle bundle : this.bundles.getBundles()) {
                locales.addAll(this.getLocalesUsed(bundle));
            }
            ArrayList result = new ArrayList(locales);
            Collections.sort(result);
            this.myUsedLocales = result;
        }
        return this.myUsedLocales;
    }

    @Override
    protected String suffix() {
        return ".json";
    }

    @Override
    protected void deleteFiles() {
        if (this.deleteOldFiles) {
            File dir = new File(this.getOutputPath());
            if (this.fileType != BundleWriter.FileType.NO && dir.exists()) {
                this.deleteFiles(dir.getPath() + "/*");
            }
        }
    }

    @Override
    protected void writeOutputFilePerLocale(String locale) throws Exception {
        String jsfile = this.getFileName(locale);
        File outFile = new File(this.getOutputPath(), jsfile);
        this.mkdirs(outFile.getPath());
        this.task.log("writing ng2translate json file " + jsfile, 2);
        JSONObject map = new JSONObject((Map)new Properties());
        map.setEscapeForwardSlashAlways(false);
        for (MBBundle bundle : this.bundles.getBundles()) {
            List<String> path = BundleWriterNg2Translate.split(bundle.getBaseName());
            JSONObject slot = BundleWriterNg2Translate.prepareSlot(map, path);
            BundleWriterNg2Translate.addGroupedEntries(locale, slot, bundle, this.isMerged(), this.debugMode, this.task);
        }
        MBJSONPersistencer writer = new MBJSONPersistencer(true);
        writer.saveString(map.toString(2), outFile);
    }

    public static void addGroupedEntries(String locale, JSONObject slot, MBBundle bundle, boolean merged, boolean debugMode, Task task) throws JSONException {
        Properties bundleProperties = BundleWriterNg2Translate.createProperties(locale, bundle, merged, debugMode, task);
        for (Map.Entry<Object, Object> entry : bundleProperties.entrySet()) {
            List<String> keys = BundleWriterNg2Translate.split((String)entry.getKey());
            JSONObject targetSlot = slot;
            if (keys.size() > 1) {
                targetSlot = BundleWriterNg2Translate.prepareSlot(slot, keys.subList(0, keys.size() - 1));
            }
            String key = keys.get(keys.size() - 1);
            String value = (String)entry.getValue();
            targetSlot.put(key, (Object)value);
        }
    }

    private static JSONObject prepareSlot(JSONObject properties, List<String> path) throws JSONException {
        JSONObject slot = properties;
        for (String each : path) {
            JSONObject slot2;
            if (!slot.has(each)) {
                slot2 = new JSONObject((Map)new Properties());
                slot2.setEscapeForwardSlashAlways(false);
                slot.put(each, (Object)slot2);
            } else {
                slot2 = (JSONObject)slot.get(each);
            }
            slot = slot2;
        }
        return slot;
    }

    public static List<String> split(String baseOrKey) {
        StringTokenizer tokens = new StringTokenizer(baseOrKey, "/.");
        ArrayList<String> result = new ArrayList<String>(tokens.countTokens() - 1);
        String prevToken = null;
        while (tokens.hasMoreTokens()) {
            String token = tokens.nextToken();
            if (prevToken != null) {
                result.add(prevToken);
            }
            prevToken = token;
        }
        if (prevToken != null) {
            result.add(prevToken);
        }
        return result;
    }

    @Override
    protected String getFileName(String locale) {
        return locale + this.suffix();
    }
}

