/*
 * Decompiled with CFR 0.152.
 */
package de.viaboxx.nlstools.formats;

import de.viaboxx.nlstools.formats.BundleWriter;
import de.viaboxx.nlstools.formats.BundleWriterJavaInterface;
import de.viaboxx.nlstools.formats.BundleWriterNg2Translate;
import de.viaboxx.nlstools.model.MBBundle;
import de.viaboxx.nlstools.model.MBEntry;
import de.viaboxx.nlstools.model.MBText;
import java.io.PrintWriter;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.tools.ant.Task;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BundleWriterTypeScript
extends BundleWriterJavaInterface {
    public BundleWriterTypeScript(Task task, String configFile, MBBundle currentBundle, String outputPath, BundleWriter.FileType fileType, Set<String> allowedLocales) {
        super(task, configFile, currentBundle, outputPath, fileType, allowedLocales);
    }

    @Override
    protected String suffix() {
        return ".ts";
    }

    @Override
    protected String getInterfaceFileName() {
        return this.getInterfacePathName() + "/" + this.transformToFileName(this.getIClass()) + this.suffix();
    }

    private String transformToFileName(String className) {
        String[] parts = BundleWriterTypeScript.splitCamelCase(className);
        StringBuilder result = new StringBuilder();
        boolean dot = false;
        for (String part : parts) {
            if (dot) {
                result.append(".");
            }
            result.append(part.toLowerCase());
            dot = true;
        }
        return result.toString();
    }

    public static String[] splitCamelCase(String name) {
        return name.split("(?<!(^|[A-Z]))(?=[A-Z])|(?<!^)(?=[A-Z][a-z])");
    }

    @Override
    protected void writeStaticIntro(PrintWriter pw) {
        this.writeDoNotAlter(pw);
        this.writeType(pw);
        pw.println(" {");
        pw.println();
        this.indentNum += this.indentSize;
    }

    @Override
    protected boolean isKeysContained() {
        return true;
    }

    @Override
    protected void writeType(PrintWriter pw) {
        pw.print("export class ");
        pw.print(this.getIClass());
    }

    @Override
    protected void writeKeyValue(PrintWriter pw, String key, String value) {
        this.printIndent(pw).print("static ");
        pw.print(key);
        pw.print(": string = \"");
        pw.print(value);
        pw.println("\";");
    }

    @Override
    protected void writeConstants(PrintWriter pw, MBBundle bundle) {
        try {
            Properties map = new Properties();
            JSONObject slot = new JSONObject((Map)map);
            for (String locale : bundle.locales()) {
                BundleWriterNg2Translate.addGroupedEntries(locale, slot, bundle, true, this.debugMode, this.task);
            }
            this.printEntries(pw, bundle, slot, "");
        }
        catch (JSONException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    private void printEntries(PrintWriter pw, MBBundle bundle, JSONObject slot, String context) throws JSONException {
        Iterator it = slot.keys();
        while (it.hasNext()) {
            String key = (String)it.next();
            Object value = slot.get(key);
            if (value instanceof String) {
                MBEntry eachEntry = bundle.getEntry(context + key);
                Iterator<MBText> texts = eachEntry.getTexts().iterator();
                this.printEntryComment(pw, eachEntry, texts);
                String theKey = this.nonReservedWord(this.createKeyName(key));
                String theValue = bundle.getBaseName().replace('/', '.') + "." + context + key;
                this.writeKeyValue(pw, theKey, theValue);
                continue;
            }
            this.printIndent(pw).print("static ");
            this.indentNum += this.indentSize;
            pw.print(this.nonReservedWord(key));
            pw.println(" = class { ");
            String context2 = context + key + ".";
            this.printEntries(pw, bundle, (JSONObject)value, context2);
            this.indentNum -= this.indentSize;
            this.printIndent(pw).println("};");
        }
    }

    private String nonReservedWord(String word) {
        if (word.equals("new")) {
            return "new_";
        }
        if (word.equals("delete")) {
            return "delete_";
        }
        if (word.equals("class")) {
            return "class_";
        }
        if (word.equals("export")) {
            return "export_";
        }
        return word;
    }
}

