/*
 * Decompiled with CFR 0.152.
 */
package de.viaboxx.nlstools.formats;

import de.viaboxx.nlstools.formats.BundleWriterExcel;
import de.viaboxx.nlstools.formats.MBPersistencer;
import de.viaboxx.nlstools.model.MBBundle;
import de.viaboxx.nlstools.model.MBBundles;
import de.viaboxx.nlstools.model.MBEntry;
import de.viaboxx.nlstools.model.MBText;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFCreationHelper;
import org.apache.poi.hssf.usermodel.HSSFDateUtil;
import org.apache.poi.hssf.usermodel.HSSFFont;
import org.apache.poi.hssf.usermodel.HSSFPatriarch;
import org.apache.poi.hssf.usermodel.HSSFRichTextString;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.hssf.util.HSSFColor;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.ClientAnchor;
import org.apache.poi.ss.usermodel.Comment;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.usermodel.RichTextString;
import org.apache.poi.ss.usermodel.Workbook;

public class MBExcelPersistencer
extends MBPersistencer {
    private static final int STYLE_BOLD = 1;
    private static final int STYLE_ITALIC = 2;
    private static final int STYLE_REVIEW = 3;
    private static final int STYLE_MISSING = 4;
    private static final int STYLE_DATETIME = 5;
    private static final int STYLE_MISSING_REVIEW = 6;
    private HSSFWorkbook wb;
    private HSSFCreationHelper helper;
    private HSSFSheet sheet;
    private int rowNum = 0;
    private final Map<Integer, CellStyle> styles = new HashMap<Integer, CellStyle>();
    private BundleWriterExcel bundleWriter;

    private void initStyles(HSSFWorkbook wb) {
        HSSFCellStyle style = wb.createCellStyle();
        HSSFFont font = wb.createFont();
        font.setBold(true);
        style.setFont(font);
        this.styles.put(1, (CellStyle)style);
        style = wb.createCellStyle();
        font = wb.createFont();
        font.setItalic(true);
        style.setFont(font);
        this.styles.put(2, (CellStyle)style);
        style = wb.createCellStyle();
        font = wb.createFont();
        font.setItalic(true);
        font.setColor((short)10);
        style.setFont(font);
        this.styles.put(3, (CellStyle)style);
        style = wb.createCellStyle();
        style.setFillPattern(FillPatternType.FINE_DOTS);
        style.setFillBackgroundColor(HSSFColor.HSSFColorPredefined.BLUE_GREY.getIndex());
        style.setFillForegroundColor(HSSFColor.HSSFColorPredefined.BLUE_GREY.getIndex());
        this.styles.put(4, (CellStyle)style);
        style = wb.createCellStyle();
        style.setFillPattern(FillPatternType.FINE_DOTS);
        style.setFillBackgroundColor(HSSFColor.HSSFColorPredefined.BLUE_GREY.getIndex());
        style.setFillForegroundColor(HSSFColor.HSSFColorPredefined.BLUE_GREY.getIndex());
        style.setFont(font);
        this.styles.put(6, (CellStyle)style);
        style = wb.createCellStyle();
        HSSFCreationHelper createHelper = wb.getCreationHelper();
        style.setDataFormat(createHelper.createDataFormat().getFormat("yyyy-dd-mm hh:mm"));
        this.styles.put(5, (CellStyle)style);
    }

    private int writeHeaders(MBBundle bundle) throws IOException {
        int colNum;
        HSSFRow headerRow = this.createRow();
        HSSFCell cell = headerRow.createCell(0);
        cell.setCellStyle(this.styles.get(1));
        cell.setCellValue("Bundle:");
        cell = headerRow.createCell(1);
        cell.setCellStyle(this.styles.get(1));
        cell.setCellValue(bundle.getBaseName());
        cell = headerRow.createCell(3);
        cell.setCellValue("Created: ");
        cell = headerRow.createCell(4);
        cell.setCellValue(new Date());
        cell.setCellStyle(this.styles.get(5));
        headerRow = this.createRow();
        if (null != bundle.getInterfaceName()) {
            cell = headerRow.createCell(0);
            cell.setCellStyle(this.styles.get(2));
            cell.setCellValue("Interface:");
            cell = headerRow.createCell(1);
            cell.setCellStyle(this.styles.get(2));
            cell.setCellValue(bundle.getInterfaceName());
        }
        if (null != bundle.getSqldomain()) {
            cell = headerRow.createCell(2);
            cell.setCellStyle(this.styles.get(2));
            cell.setCellValue("SQLDomain:");
            cell = headerRow.createCell(3);
            cell.setCellStyle(this.styles.get(2));
            cell.setCellValue(bundle.getSqldomain());
        }
        ++this.rowNum;
        headerRow = this.createRow();
        String[] headerCols = new String[]{"Key", "Aliases", "Description"};
        for (int i = 0; i < headerCols.length; ++i) {
            HSSFCell headerCell = headerRow.createCell(i);
            HSSFRichTextString text = new HSSFRichTextString(headerCols[i]);
            headerCell.setCellStyle(this.styles.get(1));
            headerCell.setCellValue((RichTextString)text);
        }
        int firstCol = colNum = headerCols.length;
        List<String> locales = this.bundleWriter.getLocalesUsed();
        for (String each : locales) {
            HSSFCell headerCell = headerRow.createCell(colNum++);
            HSSFRichTextString text = new HSSFRichTextString(each);
            headerCell.setCellStyle(this.styles.get(1));
            headerCell.setCellValue((RichTextString)text);
        }
        return firstCol;
    }

    private void writeRows(MBBundle bundle, int firstCol) throws IOException {
        List<String> locales = this.bundleWriter.getLocalesUsed();
        for (MBEntry entry : bundle.getEntries()) {
            HSSFRow row = this.createRow();
            HSSFCell cell = row.createCell(0);
            cell.setCellValue((RichTextString)new HSSFRichTextString(entry.getKey()));
            if (entry.getAliases() != null && !entry.getAliases().isEmpty()) {
                cell = row.createCell(1);
                StringBuilder buf = new StringBuilder();
                boolean comma = false;
                for (String each : entry.getAliases()) {
                    if (comma) {
                        buf.append(",");
                    } else {
                        boolean bl = comma = each != null && each.length() > 0;
                    }
                    if (each == null) continue;
                    buf.append(each);
                }
                cell.setCellValue((RichTextString)new HSSFRichTextString(buf.toString()));
            }
            if (entry.getDescription() != null) {
                cell = row.createCell(2);
                cell.setCellValue((RichTextString)new HSSFRichTextString(entry.getDescription()));
            }
            int colNum = firstCol;
            for (String each : locales) {
                MBText text = entry.getText(each);
                if (text != null) {
                    cell = row.createCell(colNum);
                    cell.setCellValue((RichTextString)new HSSFRichTextString(text.getValue()));
                    if (text.getValue() == null || text.getValue().length() == 0) {
                        if (text.isReview()) {
                            this.comment(cell, each);
                            cell.setCellStyle(this.styles.get(6));
                        } else {
                            this.comment(cell, each);
                            cell.setCellStyle(this.styles.get(4));
                        }
                    } else if (text.isReview()) {
                        this.comment(cell, each);
                        cell.setCellStyle(this.styles.get(3));
                    }
                }
                ++colNum;
            }
        }
    }

    private Comment comment(HSSFCell cell, String text) {
        HSSFCreationHelper factory = this.wb.getCreationHelper();
        HSSFPatriarch drawing = this.sheet.createDrawingPatriarch();
        ClientAnchor anchor = factory.createClientAnchor();
        anchor.setCol1(cell.getColumnIndex());
        anchor.setCol2(cell.getColumnIndex() + 1);
        anchor.setRow1(cell.getRow().getRowNum());
        anchor.setRow2(cell.getRow().getRowNum() + 3);
        Comment comment = drawing.createCellComment(anchor);
        RichTextString str = factory.createRichTextString(text);
        comment.setString(str);
        cell.setCellComment(comment);
        return comment;
    }

    private HSSFRow createRow() {
        HSSFRow row = this.sheet.createRow(this.rowNum);
        ++this.rowNum;
        return row;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save(MBBundles obj, File target) throws IOException {
        this.mkdirs(target);
        FileOutputStream out = new FileOutputStream(target);
        try {
            this.wb = new HSSFWorkbook();
            this.initStyles(this.wb);
            for (MBBundle bundle : obj.getBundles()) {
                this.bundleWriter = new BundleWriterExcel(bundle);
                this.rowNum = 0;
                this.sheet = this.wb.createSheet(bundle.getBaseName().replace('/', '.'));
                this.writeRows(bundle, this.writeHeaders(bundle));
            }
            this.wb.write((OutputStream)out);
        }
        finally {
            this.rowNum = 0;
            ((OutputStream)out).close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MBBundles load(File source) throws IOException, ClassNotFoundException {
        FileInputStream in = new FileInputStream(source);
        try {
            MBBundles mBBundles = this.load(in);
            return mBBundles;
        }
        finally {
            ((InputStream)in).close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MBBundles load(InputStream in) throws IOException, ClassNotFoundException {
        try {
            this.wb = new HSSFWorkbook(in);
            MBBundles bundles = new MBBundles();
            int sheetIdx = 0;
            this.sheet = this.wb.getSheetAt(sheetIdx++);
            while (this.sheet != null) {
                MBBundle bundle = new MBBundle();
                if (this.readSheet(bundle)) {
                    bundles.getBundles().add(bundle);
                }
                if (this.wb.getNumberOfSheets() > sheetIdx) {
                    this.sheet = this.wb.getSheetAt(sheetIdx++);
                    continue;
                }
                this.sheet = null;
            }
            MBBundles mBBundles = bundles;
            return mBBundles;
        }
        finally {
            this.rowNum = 0;
        }
    }

    private boolean readSheet(MBBundle bundle) {
        if (this.sheet.getLastRowNum() == 0) {
            return false;
        }
        HSSFRow row = this.sheet.getRow(0);
        if (row.getLastCellNum() < 1 || row.getCell(1) == null) {
            return false;
        }
        bundle.setBaseName(this.getStringValue(row.getCell(1)));
        row = this.sheet.getRow(1);
        if (row != null) {
            if (row.getCell(1) != null) {
                bundle.setInterfaceName(this.getStringValue(row.getCell(1)));
            }
            if (row.getCell(3) != null) {
                bundle.setSqldomain(this.getStringValue(row.getCell(3)));
            }
        }
        int firstCol = 2;
        this.rowNum = 3;
        row = this.sheet.getRow(this.rowNum++);
        String aliasOrDescriptionHeader = this.getStringValue(row.getCell(1));
        boolean aliasColumnAvailable = false;
        if (aliasOrDescriptionHeader != null && "Aliases".equals(aliasOrDescriptionHeader.trim())) {
            ++firstCol;
            aliasColumnAvailable = true;
        }
        int colNum = firstCol;
        ArrayList<String> locales = new ArrayList<String>();
        HSSFCell cell = row.getCell(colNum++);
        while (colNum <= row.getLastCellNum()) {
            if (cell != null) {
                locales.add(this.getStringValue(cell));
            }
            if (row.getLastCellNum() >= colNum) {
                cell = row.getCell(colNum++);
                continue;
            }
            cell = null;
        }
        row = this.sheet.getRow(this.rowNum++);
        while (row != null) {
            if (row.getCell(0) != null) {
                String aliasesCommaSeparated;
                MBEntry entry = new MBEntry();
                bundle.getEntries().add(entry);
                entry.setKey(this.getStringValue(row.getCell(0)));
                if (aliasColumnAvailable && (aliasesCommaSeparated = this.getStringValue(row.getCell(1))) != null) {
                    StringTokenizer tokens = new StringTokenizer(aliasesCommaSeparated, ", ");
                    ArrayList<String> aliases = new ArrayList<String>();
                    while (tokens.hasMoreTokens()) {
                        aliases.add(tokens.nextToken());
                    }
                    entry.setAliases(aliases);
                }
                if (row.getCell(firstCol - 1) != null) {
                    entry.setDescription(this.getStringValue(row.getCell(firstCol - 1)));
                }
                colNum = firstCol;
                for (String each : locales) {
                    String svalue;
                    if ((cell = row.getCell(colNum++)) == null || !StringUtils.isNotEmpty((CharSequence)(svalue = this.getStringValue(cell))) && cell.getCellStyle().getFillBackgroundColor() != HSSFColor.HSSFColorPredefined.BLUE_GREY.getIndex() && cell.getCellStyle().getFillForegroundColor() != HSSFColor.HSSFColorPredefined.BLUE_GREY.getIndex() && cell.getCellStyle().getFont((Workbook)this.wb).getColor() != 10) continue;
                    MBText text = new MBText();
                    text.setLocale(each);
                    text.setValue(svalue);
                    text.setReview(cell.getCellStyle().getFont((Workbook)this.wb).getColor() == 10);
                    entry.getTexts().add(text);
                }
            }
            row = this.sheet.getRow(this.rowNum++);
        }
        return true;
    }

    private HSSFCreationHelper getCreationHelper() {
        if (this.helper == null) {
            this.helper = this.wb.getCreationHelper();
        }
        return this.helper;
    }

    private String getStringValue(HSSFCell cell) {
        Object value = this.getValue(cell);
        return value == null || value instanceof String ? (String)value : String.valueOf(value);
    }

    private Object getValue(HSSFCell cell) {
        return cell == null ? null : this.getValue(cell, cell.getCellTypeEnum());
    }

    private Object getValue(HSSFCell cell, CellType cellType) {
        switch (cellType) {
            case NUMERIC: {
                if (HSSFDateUtil.isCellDateFormatted((Cell)cell)) {
                    return cell.getDateCellValue();
                }
                return cell.getNumericCellValue();
            }
            case FORMULA: {
                return this.getValue(cell, cell.getCachedFormulaResultTypeEnum());
            }
            case BOOLEAN: {
                return cell.getBooleanCellValue();
            }
            case STRING: {
                return cell.getStringCellValue();
            }
            case ERROR: {
                return cell.getErrorCellValue();
            }
        }
        return null;
    }
}

