/*
 * Decompiled with CFR 0.152.
 */
package de.viaboxx.nlstools.model;

import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.thoughtworks.xstream.annotations.XStreamAsAttribute;
import com.thoughtworks.xstream.annotations.XStreamImplicit;
import de.viaboxx.nlstools.model.MBText;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@XStreamAlias(value="entry")
public class MBEntry
implements Comparable,
Cloneable {
    @XStreamAsAttribute
    private String key;
    @XStreamImplicit(itemFieldName="alias")
    private List<String> aliases;
    private String description;
    @XStreamImplicit(itemFieldName="text")
    private List<MBText> texts = new ArrayList<MBText>();

    public List<String> getAliases() {
        return this.aliases;
    }

    public void setAliases(List<String> aliases) {
        this.aliases = aliases;
    }

    public void sort() {
        if (this.texts != null) {
            Collections.sort(this.texts);
        }
    }

    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public List<MBText> getTexts() {
        if (this.texts == null) {
            this.texts = new ArrayList<MBText>();
        }
        return this.texts;
    }

    public void setTexts(List<MBText> texts) {
        this.texts = texts;
    }

    public MBText getText(String locale) {
        for (MBText text : this.getTexts()) {
            if (locale == null || !locale.equals(text.getLocale())) continue;
            return text;
        }
        return null;
    }

    public MBText findExampleText(String exampleLocale) {
        if (StringUtils.isEmpty((CharSequence)exampleLocale)) {
            for (MBText each : this.getTexts()) {
                if (each.getValue() == null || each.getValue().length() <= 0) continue;
                return each;
            }
        } else {
            return this.getText(exampleLocale);
        }
        return null;
    }

    public boolean isReview(String reviewLocale) {
        if (this.texts == null || this.texts.isEmpty()) {
            return true;
        }
        if (reviewLocale == null) {
            for (MBText each : this.texts) {
                if (!each.isReview() && (each.isUseDefault() || !StringUtils.isEmpty((CharSequence)each.getValue()))) continue;
                return true;
            }
            return false;
        }
        MBText text = this.getText(reviewLocale);
        return text == null || text.isReview() || !text.isUseDefault() && StringUtils.isEmpty((CharSequence)text.getValue());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MBEntry mbEntry = (MBEntry)o;
        return !((this.description == null ? mbEntry.description != null : !this.description.equals(mbEntry.description)) || (this.key == null ? mbEntry.key != null : !this.key.equals(mbEntry.key)) || (this.texts == null ? mbEntry.texts != null : !this.texts.equals(mbEntry.texts)));
    }

    public int compareTo(Object o) {
        if (o instanceof MBEntry) {
            if (this.getKey() != null) {
                return this.getKey().compareTo(((MBEntry)o).getKey());
            }
            return 1;
        }
        return -1;
    }

    public MBEntry copy() {
        try {
            MBEntry entry = (MBEntry)this.clone();
            entry.setTexts(new ArrayList<MBText>(this.getTexts().size()));
            for (MBText text : this.getTexts()) {
                entry.getTexts().add(text.copy());
            }
            return entry;
        }
        catch (CloneNotSupportedException ex) {
            return null;
        }
    }

    public Set<String> locales() {
        HashSet<String> locales = new HashSet<String>();
        for (MBText text : this.getTexts()) {
            locales.add(text.getLocale());
        }
        return locales;
    }
}

