/*
 * Decompiled with CFR 0.152.
 */
package de.viaboxx.nlstools.tasks;

import de.viaboxx.nlstools.formats.MBPersistencer;
import de.viaboxx.nlstools.model.MBBundle;
import de.viaboxx.nlstools.model.MBBundles;
import de.viaboxx.nlstools.model.MBEntry;
import java.io.File;
import java.io.FileWriter;
import java.io.Writer;
import java.util.ArrayList;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;

public class CompareBundlesTask
extends Task {
    private File original;
    private File newer;
    private File results;

    public void execute() throws BuildException {
        ArrayList<String> missingKeys = new ArrayList<String>();
        ArrayList<String> missingBundles = new ArrayList<String>();
        try {
            MBBundles originalBundles = MBPersistencer.loadFile(this.original);
            MBBundles newBundles = MBPersistencer.loadFile(this.newer);
            for (MBBundle originalBundle : originalBundles.getBundles()) {
                MBBundle newBundle = newBundles.getBundle(originalBundle.getBaseName());
                if (newBundle == null) {
                    missingBundles.add(originalBundle.getBaseName());
                    continue;
                }
                for (MBEntry originalEntry : originalBundle.getEntries()) {
                    MBEntry newEntry = newBundle.getEntry(originalEntry.getKey());
                    if (newEntry != null) continue;
                    missingKeys.add(originalEntry.getKey());
                }
            }
        }
        catch (Exception e) {
            throw new BuildException((Throwable)e);
        }
        try {
            FileWriter writer = new FileWriter(this.results);
            ((Writer)writer).append("# Comparison of ").append(this.original.getAbsolutePath()).append(" (original) and ").append(this.newer.getAbsolutePath()).append(" (new version)");
            if (missingBundles.size() > 0) {
                ((Writer)writer).append("# Missing bundles (").append(String.valueOf(missingKeys.size())).append("):\n");
                for (String missingBundle : missingBundles) {
                    ((Writer)writer).append(missingBundle);
                    ((Writer)writer).append("\n");
                }
            } else {
                ((Writer)writer).append("# No bundles missing.\n");
            }
            if (missingKeys.size() > 0) {
                ((Writer)writer).append("Missing keys (").append(String.valueOf(missingKeys.size())).append("):\n");
                for (String missingKey : missingKeys) {
                    ((Writer)writer).append(missingKey);
                    ((Writer)writer).append("\n");
                }
            } else {
                ((Writer)writer).append("No missing keys.\n");
            }
            ((Writer)writer).close();
        }
        catch (Exception e) {
            throw new BuildException((Throwable)e);
        }
    }

    public File getOriginal() {
        return this.original;
    }

    public void setOriginal(File original) {
        this.original = original;
    }

    public File getNewer() {
        return this.newer;
    }

    public void setNewer(File newer) {
        this.newer = newer;
    }

    public File getResults() {
        return this.results;
    }

    public void setResults(File results) {
        this.results = results;
    }
}

