/*
 * Decompiled with CFR 0.152.
 */
package de.viaboxx.nlstools.tasks;

import de.viaboxx.nlstools.formats.MBBundlesZipper;
import de.viaboxx.nlstools.model.MBFile;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.util.FileUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CopyBundlesTask
extends Task {
    private File masterFile;
    private File dest;
    private boolean zip = true;

    public File getMasterFile() {
        return this.masterFile;
    }

    public void setMasterFile(File masterFile) {
        this.masterFile = masterFile;
    }

    public File getDest() {
        return this.dest;
    }

    public void setDest(File dest) {
        this.dest = dest;
    }

    public boolean isZip() {
        return this.zip;
    }

    public void setZip(boolean zip) {
        this.zip = zip;
    }

    public void execute() {
        if (this.masterFile == null) {
            throw new BuildException("masterFile required");
        }
        if (this.dest == null) {
            this.dest = new File(this.getProject().getBaseDir(), "bundles");
        }
        try {
            Map<String, File> mappings = CopyBundlesTask.readControlFileMapping(this.masterFile);
            if (!this.zip) {
                this.dest.mkdirs();
                for (Map.Entry<String, File> entry : mappings.entrySet()) {
                    File source = entry.getValue();
                    File target = new File(this.dest, entry.getKey());
                    FileUtils.getFileUtils().copyFile(source, target);
                }
            } else {
                if (this.dest.getParentFile() != null) {
                    this.dest.getParentFile().mkdirs();
                }
                ArrayList<MBFile> files = new ArrayList<MBFile>();
                for (Map.Entry<String, File> entry : mappings.entrySet()) {
                    File source = entry.getValue();
                    MBFile file = new MBFile();
                    FileReader reader = new FileReader(source);
                    file.setContent(IOUtils.toString((Reader)reader));
                    file.setLastModified(source.lastModified());
                    file.setName(entry.getKey());
                    reader.close();
                    files.add(file);
                }
                FileOutputStream fout = new FileOutputStream(this.dest);
                MBBundlesZipper.zip(files, fout);
                fout.close();
            }
        }
        catch (Exception ex) {
            throw new BuildException((Throwable)ex);
        }
    }

    static Map<String, File> readControlFileMapping(File controlFile) throws IOException {
        FileReader reader = new FileReader(controlFile);
        List controlFileContent = IOUtils.readLines((Reader)reader);
        reader.close();
        HashMap<String, File> controlFileMapping = new HashMap<String, File>(controlFileContent.size());
        for (String line : controlFileContent) {
            if ((line = line.trim()).length() <= 0) continue;
            int i = line.lastIndexOf(47);
            String name = line.substring(i + 1);
            controlFileMapping.put(name, new File(controlFile.getParent(), line));
        }
        return controlFileMapping;
    }
}

