/*
 * Decompiled with CFR 0.152.
 */
package de.vinado.boot.secrets;

import de.vinado.boot.secrets.PropertyIndexSupplier;
import de.vinado.boot.secrets.Utils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.BinaryOperator;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import org.springframework.core.env.PropertyResolver;
import org.springframework.util.Assert;

public class CompositePropertyIndexSupplier
implements PropertyIndexSupplier {
    private final List<PropertyIndexSupplier> delegates;
    private final BinaryOperator<String> mergeFunction;
    private final PropertyResolver resolver;

    @Override
    public Map<String, String> get() throws IllegalStateException {
        return this.delegates.stream().map(Supplier::get).map(Map::entrySet).flatMap(Collection::stream).map(Utils.value(this.substituteIfNotNull())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, this.mergeFunction));
    }

    private UnaryOperator<String> substituteIfNotNull() {
        if (null == this.resolver) {
            return UnaryOperator.identity();
        }
        return this.substitute(this.resolver);
    }

    @Override
    public PropertyIndexSupplier substituteValues(PropertyResolver resolver) {
        Assert.notNull((Object)resolver, (String)"Property resolver must not be null");
        return () -> this.get().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, this.substituteValue(resolver)));
    }

    @Override
    public UnaryOperator<String> substitute(PropertyResolver resolver) {
        Assert.notNull((Object)resolver, (String)"Property resolver must not be null");
        return value -> resolver.getProperty(value, value);
    }

    public static Builder builder() {
        return CompositePropertyIndexSupplier.using((u, v) -> {
            throw new IllegalStateException("Duplicate key " + u);
        });
    }

    public static Builder keeping() {
        return CompositePropertyIndexSupplier.using((u, v) -> u);
    }

    public static Builder overriding() {
        return CompositePropertyIndexSupplier.using((u, v) -> v);
    }

    public static Builder using(BinaryOperator<String> mergeFunction) {
        Assert.notNull(mergeFunction, (String)"Merge function must not be null");
        return new Builder(mergeFunction);
    }

    private CompositePropertyIndexSupplier(List<PropertyIndexSupplier> delegates, BinaryOperator<String> mergeFunction, PropertyResolver resolver) {
        this.delegates = delegates;
        this.mergeFunction = mergeFunction;
        this.resolver = resolver;
    }

    public static class Builder {
        private final List<PropertyIndexSupplier> delegates = new ArrayList<PropertyIndexSupplier>();
        private final BinaryOperator<String> mergeFunction;

        public Builder add(Map<String, String> properties) {
            Assert.notNull(properties, (String)"Properties must not be null");
            PropertyIndexSupplier supplier = PropertyIndexSupplier.from(properties);
            this.delegates.add(supplier);
            return this;
        }

        public Builder add(PropertyIndexSupplier supplier) {
            Assert.notNull((Object)supplier, (String)"Property index supplier must not be null");
            this.delegates.add(supplier);
            return this;
        }

        public Builder addAll(Collection<PropertyIndexSupplier> suppliers) {
            Assert.notNull(suppliers, (String)"Property index supplier collection must not be null");
            this.delegates.addAll(suppliers);
            return this;
        }

        public CompositePropertyIndexSupplier build() {
            return new CompositePropertyIndexSupplier(new ArrayList<PropertyIndexSupplier>(this.delegates), this.mergeFunction, null);
        }

        public CompositePropertyIndexSupplier buildAndSubstitute(PropertyResolver resolver) {
            Assert.notNull((Object)resolver, (String)"Property resolver collection must not be null");
            return new CompositePropertyIndexSupplier(new ArrayList<PropertyIndexSupplier>(this.delegates), this.mergeFunction, resolver);
        }

        private Builder(BinaryOperator<String> mergeFunction) {
            this.mergeFunction = mergeFunction;
        }
    }
}

