/*
 * Decompiled with CFR 0.152.
 */
package de.vinado.boot.secrets;

import de.vinado.boot.secrets.SecretResolver;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Optional;
import java.util.function.Function;
import lombok.NonNull;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.lang.Nullable;
import org.springframework.util.StreamUtils;
import org.springframework.util.StringUtils;

public class DefaultSecretResolver
implements SecretResolver {
    @NonNull
    private final ResourceLoader resourceLoader;

    @Override
    public Optional<String> loadContent(@Nullable String location) {
        return Optional.ofNullable(location).flatMap(this.resolveWith(this.resourceLoader)).map(this::readContent).filter(StringUtils::hasText).map(String::trim);
    }

    private Function<String, Optional<Resource>> resolveWith(ResourceLoader resourceLoader) {
        return location -> this.loadResource((String)location, resourceLoader);
    }

    private Optional<Resource> loadResource(String location, ResourceLoader resourceLoader) {
        return Optional.of(location).filter(StringUtils::hasText).map(arg_0 -> ((ResourceLoader)resourceLoader).getResource(arg_0)).filter(Resource::exists);
    }

    private String readContent(Resource resource) {
        String string;
        block8: {
            InputStream stream = resource.getInputStream();
            try {
                string = StreamUtils.copyToString((InputStream)stream, (Charset)StandardCharsets.UTF_8);
                if (stream == null) break block8;
            }
            catch (Throwable throwable) {
                if (stream != null) {
                    try {
                        stream.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            stream.close();
        }
        return string;
    }

    public DefaultSecretResolver(@NonNull ResourceLoader resourceLoader) {
        if (resourceLoader == null) {
            throw new IllegalArgumentException("resourceLoader is marked non-null but is null");
        }
        this.resourceLoader = resourceLoader;
    }
}

