/*
 * Decompiled with CFR 0.152.
 */
package de.vinado.boot.secrets;

import de.vinado.boot.secrets.PropertyIndexSupplier;
import de.vinado.boot.secrets.SecretPropertiesPropertySource;
import de.vinado.boot.secrets.SecretResolver;
import de.vinado.boot.secrets.Utils;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import org.apache.commons.logging.Log;
import org.springframework.boot.logging.DeferredLogFactory;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.util.Assert;

public class SecretsEnvironment {
    private final Log log;
    private final ConfigurableEnvironment environment;
    private final SecretResolver resolver;
    private final PropertyIndexSupplier propertyIndexSupplier;
    private final Map<String, Object> source = new HashMap<String, Object>();

    public SecretsEnvironment(DeferredLogFactory logFactory, ConfigurableEnvironment environment, SecretResolver resolver, PropertyIndexSupplier propertyIndexSupplier) {
        Assert.notNull((Object)logFactory, (String)"Log factory must not be null");
        Assert.notNull((Object)environment, (String)"Environment must not be null");
        Assert.notNull((Object)resolver, (String)"Resolver must not be null");
        Assert.notNull((Object)propertyIndexSupplier, (String)"Property index supplier must not be null");
        this.log = logFactory.getLog(this.getClass());
        this.environment = environment;
        this.resolver = resolver;
        this.propertyIndexSupplier = propertyIndexSupplier;
    }

    public final void processAndApply() {
        this.resolveSecretResources();
        SecretPropertiesPropertySource.merge(this.source, this.environment.getPropertySources());
    }

    protected void resolveSecretResources() {
        for (Map.Entry entry : ((Map)this.propertyIndexSupplier.get()).entrySet()) {
            String propertyName = (String)entry.getKey();
            String location = (String)entry.getValue();
            this.resolver.loadContent(location).ifPresent(Utils.acceptAndLog(this.putTo(propertyName), arg_0 -> ((Log)this.log).info(arg_0), "Use secret value to set [%s]", propertyValue -> propertyName));
        }
    }

    private Consumer<Object> putTo(String systemProperty) {
        return secretValue -> this.source.put(systemProperty, secretValue);
    }
}

