/*
 * Decompiled with CFR 0.152.
 */
package de.vinado.boot.secrets;

import de.vinado.boot.secrets.DefaultSecretResolver;
import de.vinado.boot.secrets.PropertyIndexSupplier;
import de.vinado.boot.secrets.SecretResolver;
import de.vinado.boot.secrets.SecretsEnvironment;
import org.apache.commons.logging.Log;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.env.EnvironmentPostProcessor;
import org.springframework.boot.logging.DeferredLogFactory;
import org.springframework.core.Ordered;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.io.DefaultResourceLoader;
import org.springframework.core.io.ResourceLoader;

public abstract class SecretsEnvironmentPostProcessor
implements EnvironmentPostProcessor,
Ordered {
    private final Log log;
    private final DeferredLogFactory logFactory;

    public SecretsEnvironmentPostProcessor(DeferredLogFactory logFactory) {
        this.logFactory = logFactory;
        this.log = logFactory.getLog(this.getClass());
    }

    public void postProcessEnvironment(ConfigurableEnvironment environment, SpringApplication application) {
        ResourceLoader resourceLoader = application.getResourceLoader();
        this.postProcessEnvironment(environment, (ResourceLoader)(null == resourceLoader ? new DefaultResourceLoader() : resourceLoader));
    }

    void postProcessEnvironment(ConfigurableEnvironment environment, ResourceLoader resourceLoader) {
        this.log.trace((Object)"Post-processing environment to add secrets");
        this.createSecretsEnvironment(environment, resourceLoader).processAndApply();
    }

    protected SecretsEnvironment createSecretsEnvironment(ConfigurableEnvironment environment, ResourceLoader resourceLoader) {
        SecretResolver secretResolver = this.getSecretResolver(resourceLoader);
        PropertyIndexSupplier indexSupplier = this.getPropertyIndexSupplier(environment);
        return new SecretsEnvironment(this.logFactory, environment, secretResolver, indexSupplier);
    }

    protected SecretResolver getSecretResolver(ResourceLoader resourceLoader) {
        return new DefaultSecretResolver(resourceLoader);
    }

    protected abstract PropertyIndexSupplier getPropertyIndexSupplier(ConfigurableEnvironment var1);

    public int getOrder() {
        return -2147483538;
    }
}

