/*
 * Decompiled with CFR 0.152.
 */
package de.wenzlaff.blockchain.be;

import de.wenzlaff.blockchain.be.Fee;
import de.wenzlaff.blockchain.be.Transaktion;
import java.time.LocalDateTime;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Block {
    private static final Logger LOG = LogManager.getLogger(Block.class);
    private int previousHash;
    private List<Transaktion> data;
    private int hash;

    public Block(List<Transaktion> data, int previousHash) {
        this.data = data;
        this.previousHash = previousHash;
        Integer uhrzeit = LocalDateTime.now().toLocalTime().toSecondOfDay();
        Integer zufall = new Random().nextInt();
        this.hash = Arrays.hashCode((Object[])new Integer[]{data.hashCode(), previousHash, uhrzeit, zufall});
        LOG.info("Neuen Block erzeugt mit Hash: " + this.hash);
    }

    public boolean isValid() {
        return true;
    }

    public Block mining() {
        Fee miningFee = new Fee();
        miningFee.setBetrag(6.25);
        Object block = null;
        return null;
    }

    public int getPreviousHash() {
        return this.previousHash;
    }

    public void setPreviousHash(int previousHash) {
        this.previousHash = previousHash;
    }

    public List<Transaktion> getData() {
        return this.data;
    }

    public void setData(List<Transaktion> data) {
        this.data = data;
    }

    public int getHash() {
        return this.hash;
    }

    public void setHash(int hash) {
        this.hash = hash;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.data == null ? 0 : this.data.hashCode());
        result = 31 * result + this.hash;
        result = 31 * result + this.previousHash;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Block other = (Block)obj;
        if (this.data == null ? other.data != null : !this.data.equals(other.data)) {
            return false;
        }
        if (this.hash != other.hash) {
            return false;
        }
        return this.previousHash == other.previousHash;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("Block [previousHash=");
        builder.append(this.previousHash);
        builder.append(", ");
        builder.append("hash=");
        builder.append(this.hash);
        if (this.data != null) {
            builder.append(", ");
            builder.append("data=");
            builder.append(this.data);
        }
        builder.append("]");
        return builder.toString();
    }
}

