/*
 * Decompiled with CFR 0.152.
 */
package de.wenzlaff.dump1090.action;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import de.wenzlaff.dump1090.action.Aktion;
import de.wenzlaff.dump1090.action.JsonReader;
import de.wenzlaff.dump1090.action.LogAktion;
import de.wenzlaff.dump1090.action.PushoverAktion;
import de.wenzlaff.dump1090.be.Flugzeug;
import de.wenzlaff.dump1090.be.Flugzeuge;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.ConnectException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TimerTask;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TimerAktion
extends TimerTask
implements Aktion {
    private static final int MAX_GESPEICHERTE_FLUGZEUGE = 50;
    private static final Logger LOG = LoggerFactory.getLogger(TimerAktion.class);
    private String serverUrl;
    private Map<String, Flugzeug> benachrichtigteFlugzeuge;

    public TimerAktion(String ip) {
        this.setUrl(ip);
        this.benachrichtigteFlugzeuge = new HashMap<String, Flugzeug>();
    }

    @Override
    public void run() {
        Date aktuelle = new Date();
        LOG.debug("Timer Aktion {}", (Object)aktuelle);
        Thread.currentThread().setName("Dump1090-TimerAktion-" + aktuelle);
        try {
            List<Flugzeug> alleImLandeAnflug;
            InputStream is = new URL(this.serverUrl).openStream();
            BufferedReader br = new BufferedReader(new InputStreamReader(is, StandardCharsets.UTF_8));
            String aircraftDatei = JsonReader.readAll(br);
            br.close();
            Gson gson = new GsonBuilder().create();
            Flugzeuge flugzeuge = (Flugzeuge)gson.fromJson(aircraftDatei, Flugzeuge.class);
            if (flugzeuge.getNotfall().size() > 0) {
                LogAktion log = new LogAktion(flugzeuge);
                log.run();
                PushoverAktion pushover = new PushoverAktion(flugzeuge);
                pushover.run();
            }
            if ((alleImLandeAnflug = flugzeuge.getFlugzeugeImAnAbflug()).size() > 0) {
                for (int i = 0; i < alleImLandeAnflug.size(); ++i) {
                    Flugzeug flugzeug = alleImLandeAnflug.get(i);
                    String keyHex = flugzeug.getHex().trim();
                    if (this.benachrichtigteFlugzeuge.containsKey(keyHex)) continue;
                    LOG.info("Nachricht senden: {}", (Object)flugzeug);
                    this.benachrichtigteFlugzeuge.put(keyHex, flugzeug);
                    PushoverAktion pushover = new PushoverAktion(flugzeug);
                    pushover.sendPushoverNachricht();
                }
            }
            if (this.benachrichtigteFlugzeuge.values().size() > 50) {
                LOG.info("L\u00d6SCHE alle {} Flugzeuge im Speicher.", (Object)50);
                this.benachrichtigteFlugzeuge.clear();
            }
        }
        catch (ConnectException e) {
            LOG.error("Verbindungs Error zu Adresse {} Error: {}", (Object)this.serverUrl, (Object)e);
        }
        catch (IOException e1) {
            LOG.error("Error {}", (Throwable)e1);
        }
        catch (Exception e2) {
            LOG.error("Error {}", (Throwable)e2);
        }
    }

    private void setUrl(String ip) {
        this.serverUrl = "http://" + ip + "/dump1090/data/aircraft.json";
    }
}

