package de.wenzlaff.dump1090.action;

import java.io.InputStream;
import java.util.Properties;

/**
 * Versions Klasse.
 * 
 * @author Thomas Wenzlaff
 *
 */
public class Version {

	private static final String GROUP_ID = "de.wenzlaff.dump1090";

	private static final String ARTIFACT_ID = "de.wenzlaff.dump1090";

	public String getVersion() {
		String version = null;

		// wir lesen zuerst aus der pom.propertie Datei, die enthält z.B.
		// #Generated by Maven Integration for Eclipse
		// #Wed Nov 23 15:46:31 CET 2016
		// version=0.0.5-SNAPSHOT
		// groupId=de.wenzlaff.dump1090
		// m2e.projectName=de.wenzlaff.dump1090
		// m2e.projectLocation=/Users/thomaswenzlaff/git/Dump1090
		// artifactId=de.wenzlaff.dump1090
		try {
			Properties p = new Properties();
			InputStream is = getClass().getResourceAsStream("/META-INF/maven/" + GROUP_ID + "/" + ARTIFACT_ID + "/pom.properties");
			if (is != null) {
				p.load(is);
				version = p.getProperty("version", "");
			}
		} catch (Exception e) {
			// ignore
		}

		// fallback mit Java API
		if (version == null) {
			Package aPackage = getClass().getPackage();
			if (aPackage != null) {
				version = aPackage.getImplementationVersion();
				if (version == null) {
					version = aPackage.getSpecificationVersion();
				}
			}
		}

		if (version == null) {
			// es konnte keine Version ermittelt werden, dann lassen wir sie leer
			version = "";
		}
		return version;
	}

}
