/*
 * Decompiled with CFR 0.152.
 */
package de.wenzlaff.dump1090.action;

import de.wenzlaff.dump1090.action.Aktion;
import de.wenzlaff.dump1090.action.SetupReader;
import de.wenzlaff.dump1090.be.Converter;
import de.wenzlaff.dump1090.be.Flugzeug;
import de.wenzlaff.dump1090.be.Flugzeuge;
import de.wenzlaff.dump1090.be.PushoverSound;
import java.util.Date;
import java.util.Properties;
import net.pushover.client.MessagePriority;
import net.pushover.client.PushoverException;
import net.pushover.client.PushoverMessage;
import net.pushover.client.PushoverRestClient;
import net.pushover.client.Status;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PushoverAktion
implements Aktion {
    private static final String NACHRICHTEN_TITEL = "de.wenzlaff.dump1090";
    private static final Logger LOG = LoggerFactory.getLogger(PushoverAktion.class);
    private String pushoverUserToken;
    private String pushoverMyApiToken;
    private String pushoverNachrichtUrl;
    private String[] pushoverDevices;
    private Flugzeuge flugzeuge;
    private Flugzeug flugzeug;

    public PushoverAktion(Flugzeuge flugzeuge) {
        this.flugzeuge = flugzeuge;
        this.setProperties();
    }

    public PushoverAktion(Flugzeug flugzeug) {
        this.flugzeug = flugzeug;
        this.setProperties();
    }

    public PushoverAktion() {
        this.setProperties();
    }

    private void setProperties() {
        Properties properties = SetupReader.getProperties();
        this.pushoverUserToken = properties.getProperty("pushover_user_id_token");
        this.pushoverMyApiToken = properties.getProperty("pushover_my_app_api_token");
        this.pushoverNachrichtUrl = properties.getProperty("pushover_nachricht_url");
        String pushoverDevice = properties.getProperty("pushover_device", "device");
        this.pushoverDevices = pushoverDevice.split(";");
    }

    @Override
    public void run() {
        LOG.info("Pushover Aktion mit {} ... ", (Object)this.flugzeuge);
        PushoverRestClient client = new PushoverRestClient();
        for (int i = 0; i < this.flugzeuge.getAnzahlFlugzeuge(); ++i) {
            String nachricht = this.flugzeuge.toString();
            LOG.info(nachricht);
            String nachrichtenUrl = this.pushoverNachrichtUrl + this.flugzeuge.getFlugzeuge().get(i).getHex();
            LOG.info("Nachrichten URL: {}", (Object)nachrichtenUrl);
            for (int j = 0; j < this.pushoverDevices.length; ++j) {
                Status result = null;
                try {
                    result = client.pushMessage(PushoverMessage.builderWithApiToken((String)this.pushoverMyApiToken).setUserId(this.pushoverUserToken).setMessage(nachricht).setDevice(this.pushoverDevices[j]).setPriority(MessagePriority.HIGH).setTitle("Flugzeug - Alarm!").setUrl(nachrichtenUrl).setTitleForURL("Flugzeug Notfall").setSound(PushoverSound.magic.name()).build());
                }
                catch (PushoverException e) {
                    LOG.error("Fehler: Pushover Status: {}", result);
                    LOG.error("Fehler:{}", (Throwable)e);
                    return;
                }
                if (result.getStatus() != 1) {
                    LOG.error(String.format("Fehler: Pushover Status: %d, Request ID: %s", result.getStatus(), result.getRequestId()));
                    continue;
                }
                LOG.info("OK: Pushover Nachricht (Request Id: {} ) erfolgreich versendet um {}.", (Object)result.getRequestId(), (Object)new Date());
            }
        }
    }

    public void sendPushoverNachricht(String nachricht) {
        LOG.info("OK: Versende Pushover Aktion mit folgender Nachricht: {}", (Object)nachricht);
        PushoverRestClient client = new PushoverRestClient();
        for (int i = 0; i < this.pushoverDevices.length; ++i) {
            Status result = null;
            try {
                result = client.pushMessage(PushoverMessage.builderWithApiToken((String)this.pushoverMyApiToken).setUserId(this.pushoverUserToken).setMessage(nachricht).setDevice(this.pushoverDevices[i]).setPriority(MessagePriority.HIGH).setTitle(NACHRICHTEN_TITEL).setUrl("http://www.wenzlaff.info").setTitleForURL("www.wenzlaff.info").setSound(PushoverSound.magic.name()).build());
                continue;
            }
            catch (PushoverException e) {
                LOG.error("Fehler beim versenden der Pushover Nachricht: {} wegen: {} mit Result: {}", new Object[]{nachricht, e, result});
            }
        }
    }

    public void sendPushoverNachricht() {
        if (this.flugzeug != null) {
            String nachricht = this.getNachrichtFormat(this.flugzeug);
            LOG.info("Versende Pushover Aktion mit folgender Nachricht: {}", (Object)nachricht);
            String nachrichtenUrl = this.pushoverNachrichtUrl + this.flugzeug.getHex();
            LOG.info("Nachrichten URL: {}", (Object)nachrichtenUrl);
            PushoverRestClient client = new PushoverRestClient();
            for (int i = 0; i < this.pushoverDevices.length; ++i) {
                Status result = null;
                try {
                    result = client.pushMessage(PushoverMessage.builderWithApiToken((String)this.pushoverMyApiToken).setUserId(this.pushoverUserToken).setMessage(nachricht).setDevice(this.pushoverDevices[i]).setPriority(MessagePriority.HIGH).setTitle(NACHRICHTEN_TITEL).setUrl(nachrichtenUrl).setTitleForURL(this.pushoverNachrichtUrl).setSound(PushoverSound.magic.name()).build());
                    continue;
                }
                catch (PushoverException e) {
                    LOG.error("Fehler beim versenden der Pushover Nachricht: {} wegen: {} mit Result: {}", new Object[]{nachricht, e, result});
                }
            }
        }
    }

    private String getNachrichtFormat(Flugzeug flugzeug) {
        StringBuilder builder = new StringBuilder();
        builder.append("Flugzeug ");
        if (flugzeug != null) {
            if (flugzeug.getFlight() != null) {
                builder.append("Flug: ");
                builder.append(flugzeug.getFlight().trim());
                builder.append(", ");
            }
            if (flugzeug.getHex() != null) {
                builder.append("HEX: ");
                builder.append(flugzeug.getHex().toUpperCase());
                builder.append(", ");
            }
            if (flugzeug.getAltitudeAsString() != null) {
                builder.append("H\u00f6he: ");
                builder.append(Converter.getMeterVonFuss(flugzeug.getAltitudeAsString()));
                builder.append(" m, ");
            }
            if (flugzeug.getSpeed() != null) {
                builder.append("Geschwindigkeit: ");
                builder.append(Converter.getKmVonKnoten(flugzeug.getSpeed()));
                builder.append(" km/h, ");
            }
            if (flugzeug.getSquawk() != null) {
                builder.append("Squawk: ");
                builder.append(flugzeug.getSquawk());
                builder.append(", ");
            }
            if (flugzeug.getLat() != null) {
                builder.append("Lat: ");
                builder.append(flugzeug.getLat());
                builder.append(", ");
            }
            if (flugzeug.getLon() != null) {
                builder.append("Lon: ");
                builder.append(flugzeug.getLon());
            }
        }
        return builder.toString();
    }
}

