/*
 * Decompiled with CFR 0.152.
 */
package de.wenzlaff.dump1090.be;

import de.wenzlaff.dump1090.action.SetupReader;
import de.wenzlaff.dump1090.be.Flugzeug;
import de.wenzlaff.dump1090.be.Luftnotfall;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Flugzeuge {
    private static final Logger LOG = LoggerFactory.getLogger(Flugzeuge.class);
    private String laengengradMin;
    private int maxHoehe;
    private String now;
    private String messages;
    private List<Flugzeug> aircraft = new ArrayList<Flugzeug>();

    public Flugzeuge() {
        Properties properties = SetupReader.getProperties();
        this.laengengradMin = properties.getProperty("pushover_laengengrad_min", "9.742556");
        this.maxHoehe = Integer.valueOf(properties.getProperty("pushover_max_hoehe", "3000"));
    }

    public List<Flugzeug> getNotfall() {
        ArrayList<Flugzeug> notfallFlugzeuge = new ArrayList<Flugzeug>();
        for (Flugzeug flugzeug : this.aircraft) {
            if (flugzeug.getSquawk() == null || !flugzeug.getSquawk().equals(Luftnotfall.ENTFUEHRUNG.getCode()) && !flugzeug.getSquawk().equals(Luftnotfall.FUNKAUSFALL.getCode()) && !flugzeug.getSquawk().equals(Luftnotfall.LUFTNOTFALL.getCode())) continue;
            notfallFlugzeuge.add(flugzeug);
        }
        return notfallFlugzeuge;
    }

    public List<Flugzeug> getFlugzeugeImAnAbflug() {
        ArrayList<Flugzeug> flugzeuge = new ArrayList<Flugzeug>();
        for (Flugzeug flugzeug : this.aircraft) {
            if (!this.isImStartUndLandeanflug(flugzeug)) continue;
            LOG.debug("erfasst {}", (Object)flugzeug);
            flugzeuge.add(flugzeug);
        }
        return flugzeuge;
    }

    private boolean isImStartUndLandeanflug(Flugzeug flugzeug) {
        boolean status = false;
        if (flugzeug.getAltitude() != null && flugzeug.getAltitude() < this.maxHoehe && flugzeug.getAltitude() > 0 && flugzeug.getLongitude().compareTo(new BigDecimal(this.laengengradMin)) > 0) {
            status = true;
        }
        return status;
    }

    public void addFlugzeug(Flugzeug f) {
        this.aircraft.add(f);
    }

    public void clear() {
        this.aircraft.clear();
    }

    public List<Flugzeug> getFlugzeuge() {
        return this.aircraft;
    }

    public int getAnzahlFlugzeuge() {
        return this.aircraft.size();
    }

    public String getNow() {
        return this.now;
    }

    public void setNow(String now) {
        this.now = now;
    }

    public String getMessages() {
        return this.messages;
    }

    public void setMessages(String messages) {
        this.messages = messages;
    }

    public void setFlugzeuge(List<Flugzeug> flugzeuge) {
        this.aircraft = flugzeuge;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("Flugzeuge [");
        if (this.now != null) {
            builder.append("now=");
            builder.append(this.now);
            builder.append(", ");
        }
        if (this.messages != null) {
            builder.append("messages=");
            builder.append(this.messages);
            builder.append(", ");
            builder.append("\n");
        }
        if (this.aircraft != null) {
            builder.append("aircraft=");
            builder.append(this.aircraft);
        }
        builder.append("]");
        return builder.toString();
    }
}

