/*
 * Decompiled with CFR 0.152.
 */
package de.wenzlaff.dump1090;

import de.wenzlaff.dump1090.action.PushoverAktion;
import de.wenzlaff.dump1090.action.TimerAktion;
import de.wenzlaff.dump1090.action.Version;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StartFlugabfrage {
    private static final Logger LOG = LoggerFactory.getLogger(StartFlugabfrage.class);
    private static final String VERSION = new Version().getVersion();
    private ScheduledExecutorService scheduler;
    private String ipAdresse;
    private String intervalInMinuten;

    public static void main(String[] args) {
        if (args.length != 2) {
            LOG.error("Programm Abbruch, da nicht die richtige Anzahl von Parametern \u00fcbergeben.");
            LOG.error("Aufruf des StartFlugabfrage Programms mit zwei Parametern: [Server IP] [Intervall in Minuten]");
            LOG.error("z.B.: java -jar de.wenzlaff.dump1090-0.0.2-SNAPSHOT.jar 10.0.9.32 5");
            LOG.error("Details zum Programm de.wenzlaff.dump1090 mit Versions Nr. {} siehe http://www.wenzlaff.info", (Object)VERSION);
            System.exit(8);
        }
        String ip = args[0];
        String interval = args[1];
        LOG.info("Starte abfrage der Flugzeuge die einen Notfall melden. Server IP Adresse: {} Intervall alle: {} Minuten", (Object)ip, (Object)interval);
        StartFlugabfrage task = new StartFlugabfrage(ip, interval);
        task.startEndlosNotfallabfrage();
    }

    public StartFlugabfrage(String ipAdresse, String intervalInMinuten) {
        this.ipAdresse = ipAdresse;
        this.intervalInMinuten = intervalInMinuten;
        PushoverAktion startNachrich = new PushoverAktion();
        startNachrich.sendPushoverNachricht("Starte das de.wenzlaff.dump1090 " + VERSION + " Programm alle " + this.intervalInMinuten + " Minuten gegen IP Adresse: " + ipAdresse);
        this.scheduler = Executors.newScheduledThreadPool(1);
    }

    public void startEndlosNotfallabfrage() {
        this.startAnzahlProTagTimer(this.ipAdresse, this.intervalInMinuten);
    }

    private void startAnzahlProTagTimer(String ipAdresse, String intervalInMinuten) {
        LOG.info("Frage nun alle " + intervalInMinuten + " Minuten ohne weitere Ausgaben ab ...");
        this.scheduler.scheduleAtFixedRate(new TimerAktion(ipAdresse), 0L, Long.parseLong(intervalInMinuten), TimeUnit.MINUTES);
    }
}

