package de.wenzlaff.ki.model;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.List;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;

/**
 * KI-Model Demo.
 * 
 * @author Thomas Wenzlaff
 */
public class KIModelle {

	public static final String JSON_MODEL_DATEI = "src/main/resources/de/wenzlaff/ki/model/ki_modelle.json";

	/**
	 * Das KIModel.
	 * 
	 * @author Thomas Wenzlaff
	 */
	static class KIModel {

		public String modell;
		public String beschreibungUndVorteile;
		public String groesse;
		public String veroeffentlichungsdatum;
		public boolean kannFotosErzeugen;

		@Override
		public String toString() {
			return "Modell: " + modell + "\n" + "Beschreibung: " + beschreibungUndVorteile + "\n" + "Größe: " + groesse + "\n" + "Veröffentlichungsdatum: "
					+ veroeffentlichungsdatum + "\n" + "Kann Fotos erzeugen: " + (kannFotosErzeugen ? "Ja" : "Nein") + "\n";
		}
	}

	public List<KIModel> loadModelsFromJson(String filePath) throws IOException {
		var objectMapper = new ObjectMapper();
		var jsonContent = Files.readString(Path.of(filePath));
		return objectMapper.readValue(jsonContent, new TypeReference<List<KIModel>>() {
		});
	}

	public static void main(String[] args) {
		var kiModelle = new KIModelle();
		try {
			var modelle = kiModelle.loadModelsFromJson(JSON_MODEL_DATEI);
			System.out.println("Liste von " + modelle.size() + " perplexity Modellen aus der JSON-Datei:\n");
			modelle.forEach(modell -> {
				System.out.println(modell);
				System.out.println("-------------------------");
			});
		} catch (IOException e) {
			System.err.println("Fehler beim Laden der JSON-Datei: " + e.getMessage());
		}
	}
}
