package de.wenzlaff.mathe;

/**
 * Satz von Bayes.
 * 
 * Aufruf: java StatzVonBayes 0.01 0.95 0.05
 * 
 * @author Thomas Wenzlaff
 *
 */
public class SatzVonBayes {

	/**
	 * 
	 * @param args Parameter 1. Wahrscheinlichkeit, krank zu sein, 2.
	 *             Wahrscheinlichkeit, dass der Test bei Krankheit positiv ist 3.
	 *             Wahrscheinlichkeit, dass der Test fälschlicherweise positiv ist
	 */
	public static void main(String[] args) {
		if (args.length != 3) {
			System.out.println("Bitte geben Sie drei Parameter an, z.B. Aufruf: java StatzVonBayes 0.01 0.95 0.05");
			System.out.println("1. Wahrscheinlichkeit, krank zu sein\n" + "2. Wahrscheinlichkeit, dass der Test bei Krankheit positiv ist\n"
					+ "3. Wahrscheinlichkeit, dass der Test fälschlicherweise positiv ist");
			return;
		}

		double prevalence = Double.parseDouble(args[0]); // 0.01; // Wahrscheinlichkeit, krank zu sein (1 %)
		double sensitivity = Double.parseDouble(args[1]); // 0.95; // Wahrscheinlichkeit, dass der Test bei Krankheit positiv ist
		double falsePositiveRate = Double.parseDouble(args[2]); // 0.05; // Wahrscheinlichkeit, dass der Test fälschlicherweise positiv ist

		double probabilityHealthy = 1 - prevalence; // Wahrscheinlichkeit, gesund zu sein
		double totalPositive = (sensitivity * prevalence) + (falsePositiveRate * probabilityHealthy);

		double probabilitySickGivenPositive = (sensitivity * prevalence) / totalPositive;
		double probabilitySickGivenPositivePercent = probabilitySickGivenPositive * 100;

		printResult(prevalence, sensitivity, falsePositiveRate, probabilitySickGivenPositivePercent);
	}

	private static void printResult(double prevalence, double sensitivity, double falsePositiveRate, double probabilitySickGivenPositivePercent) {
		System.out.printf("Wahrscheinlichkeit krank zu sein (prevalence): %.2f%%\n", prevalence);
		System.out.printf("Wahrscheinlichkeit, dass der Test bei Krankheit positiv ist (sensitivity): %.2f%%\n", sensitivity);
		System.out.printf("Wahrscheinlichkeit, dass der Test fälschlicherweise positiv ist (falsePositiveRate): %.2f%%\n", falsePositiveRate);

		System.out.printf("Ergebnis: Die Wahrscheinlichkeit, krank zu sein, wenn der Test positiv ist: %.2f%%\n", probabilitySickGivenPositivePercent);
	}
}
