package de.wenzlaff.mathe;

import java.util.Arrays;

public class SieveOfEratosthenes {

	public static void main(String[] args) {
		int N = 1000000; // Beispielobergrenze, kann angepasst werden
		sieveOfEratosthenes(N);
	}

	// Methode, die das Sieb des Eratosthenes implementiert
	public static void sieveOfEratosthenes(int N) {
		// Array zur Kennzeichnung der Primzahlen
		boolean[] isPrime = new boolean[N + 1];
		Arrays.fill(isPrime, true); // Setze alle Werte auf "true"
		isPrime[0] = false; // 0 ist keine Primzahl
		isPrime[1] = false; // 1 ist keine Primzahl

		// Sieb-Prozess
		for (int p = 2; p * p <= N; p++) {
			// Wenn p eine Primzahl ist, streiche alle Vielfachen von p
			if (isPrime[p]) {
				for (int multiple = p * p; multiple <= N; multiple += p) {
					isPrime[multiple] = false; // Markiere alle Vielfachen als nicht prim
				}
			}
		}

		// Ausgabe der gefundenen Primzahlen
		System.out.println("Primzahlen bis " + N + ":");
		for (int i = 2; i <= N; i++) {
			if (isPrime[i]) {
				System.out.print(i + "\n");
			}
		}
	}
}
