#!/usr/bin/env python

# Thomas Wenzlaff, kleinhirn.eu

import matplotlib.pyplot as plt
import networkx as nx

# Erstelle den Baum als gerichteten Graphen
G = nx.DiGraph()

# Hinzufügen der Knoten
G.add_node("Start")
G.add_node("Krank (1%)")
G.add_node("Gesund (99%)")
G.add_node("Positiv (95%)")
G.add_node("Negativ (5%)")
G.add_node("Falsch Positiv (5%)")
G.add_node("Richtig Negativ (95%)")

# Hinzufügen der Verbindungen
G.add_edge("Start", "Krank (1%)", weight=0.01)
G.add_edge("Start", "Gesund (99%)", weight=0.99)
G.add_edge("Krank (1%)", "Positiv (95%)", weight=0.95)
G.add_edge("Krank (1%)", "Negativ (5%)", weight=0.05)
G.add_edge("Gesund (99%)", "Falsch Positiv (5%)", weight=0.05)
G.add_edge("Gesund (99%)", "Richtig Negativ (95%)", weight=0.95)

# Position der Knoten im Baumdiagramm
pos = {
    "Start": (0, 3),
    "Krank (1%)": (-1, 2),
    "Gesund (99%)": (1, 2),
    "Positiv (95%)": (-1.5, 1),
    "Negativ (5%)": (-0.5, 1),
    "Falsch Positiv (5%)": (0.5, 1),
    "Richtig Negativ (95%)": (1.5, 1),
}

# Erstellen der Graphen-Labels
labels = {
    ("Start", "Krank (1%)"): "1%",
    ("Start", "Gesund (99%)"): "99%",
    ("Krank (1%)", "Positiv (95%)"): "95%",
    ("Krank (1%)", "Negativ (5%)"): "5%",
    ("Gesund (99%)", "Falsch Positiv (5%)"): "5%",
    ("Gesund (99%)", "Richtig Negativ (95%)"): "95%",
}

# die Labels mit Dezimalzahlen zusätzlich zu den Prozentwerten
labels_decimal = {
    ("Start", "Krank (1%)"): "1% (0.01)",
    ("Start", "Gesund (99%)"): "99% (0.99)",
    ("Krank (1%)", "Positiv (95%)"): "95% (0.95)",
    ("Krank (1%)", "Negativ (5%)"): "5% (0.05)",
    ("Gesund (99%)", "Falsch Positiv (5%)"): "5% (0.05)",
    ("Gesund (99%)", "Richtig Negativ (95%)"): "95% (0.95)",
}

# Erstelle den Baum mit einer horizontalen Ausrichtung (links nach rechts)
pos_horizontal = {
    "Start": (0, 0),
    "Krank (1%)": (1, 1),
    "Gesund (99%)": (1, -1),
    "Positiv (95%)": (2, 1.5),
    "Negativ (5%)": (2, 0.5),
    "Falsch Positiv (5%)": (2, -0.5),
    "Richtig Negativ (95%)": (2, -1.5),
}

# Zeichne den Graphen horizontal mit den neuen Labels
plt.figure(figsize=(12, 6))

nx.draw(G, pos_horizontal, with_labels=True, node_size=3000, node_color="lightblue", font_size=10, font_weight="bold")
nx.draw_networkx_edge_labels(G, pos_horizontal, edge_labels=labels_decimal, font_color="red")

plt.title("Baumdiagramm für den Satz von Bayes")

plt.show()
