#!/usr/bin/env python

# Thomas Wenzlaff, kleinhirn.eu

import pandas as pd
import matplotlib.pyplot as plt

# Daten für die Vierfeldertafel
data = {
    "": ["Positiver Test", "Negativer Test", "Summe"],
    "Krank (1%)": [0.0095, 0.0005, 0.01],
    "Gesund (99%)": [0.0495, 0.9405, 0.99],
    "Summe": [0.059, 0.941, 1.0]
}

# Erstelle die Tabelle
table = pd.DataFrame(data)
table.set_index("", inplace=True)

# Erstellen und Anzeigen der Tabelle als Grafik
fig, ax = plt.subplots(figsize=(8, 4))
ax.axis('tight')
ax.axis('off')
table_display = ax.table(cellText=table.values, colLabels=table.columns, rowLabels=table.index, loc='center', cellLoc='center')

# Styling der Tabelle
table_display.auto_set_font_size(False)
table_display.set_fontsize(12)
table_display.scale(1.2, 1.2)

plt.title("Vierfeldertafel für den Satz von Bayes")
plt.show()

