/*
 * Decompiled with CFR 0.152.
 */
package de.wenzlaff.twflug;

import de.wenzlaff.twflug.be.Parameter;
import org.apache.commons.cli.BasicParser;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Kommandozeile {
    private static final Logger LOG = LogManager.getLogger((String)Kommandozeile.class.getName());
    private static final String ANWENDUNG_NAME = "TWFlug";
    private static final String ANWENDUNG_VERSION = "0.1.0";
    private static final String ANWENDUNG_UND_VERSION = "TWFlug 0.1.0";

    public static Parameter parseCommandline(String[] args) {
        BasicParser parser = new BasicParser();
        Options options = new Options();
        Option help = new Option("h", "help", false, "print help and exit");
        options.addOption(help);
        options.addOption("n", "no-gui", false, "display no GUI. Only logfile output (default: false) ");
        Option version = new Option("v", "version", false, "print the version information and exit");
        options.addOption(version);
        Option debug = new Option("d", "debug", false, "print debugging information (default: false)");
        options.addOption(debug);
        OptionBuilder.withLongOpt((String)"ip");
        OptionBuilder.withDescription((String)"ip adress from DUMP1090");
        OptionBuilder.hasArg();
        OptionBuilder.isRequired();
        options.addOption(OptionBuilder.create((String)"i"));
        OptionBuilder.withLongOpt((String)"port");
        OptionBuilder.withDescription((String)"port from DUMP1090 (default: 30003)");
        OptionBuilder.hasArg();
        options.addOption(OptionBuilder.create((String)"p"));
        OptionBuilder.withLongOpt((String)"max-count");
        OptionBuilder.withDescription((String)"set max count value (default: 50)");
        OptionBuilder.hasArg();
        options.addOption(OptionBuilder.create((String)"max"));
        OptionBuilder.withLongOpt((String)"min-count");
        OptionBuilder.withDescription((String)"set min count value (default: 0) ");
        OptionBuilder.hasArg();
        options.addOption(OptionBuilder.create((String)"min"));
        OptionBuilder.withLongOpt((String)"window-width");
        OptionBuilder.withDescription((String)"set window with (default: 600)");
        OptionBuilder.hasArg();
        options.addOption(OptionBuilder.create((String)"width"));
        OptionBuilder.withLongOpt((String)"window-height");
        OptionBuilder.withDescription((String)"set window hight (default: 600)");
        OptionBuilder.hasArg();
        options.addOption(OptionBuilder.create((String)"height"));
        OptionBuilder.withLongOpt((String)"refresh-time");
        OptionBuilder.withDescription((String)"refresh time in ms (default: 300000 ms = 5 Minuten)");
        OptionBuilder.hasArg();
        options.addOption(OptionBuilder.create((String)"r"));
        OptionBuilder.withLongOpt((String)"copy-time");
        OptionBuilder.withDescription((String)"copy time in Minuten (default: 60 Minuten)");
        OptionBuilder.hasArg();
        options.addOption(OptionBuilder.create((String)"c"));
        options.addOption("k", "copy", false, "copy output file to destination (default: false)");
        OptionBuilder.withLongOpt((String)"ziel-ip");
        OptionBuilder.withDescription((String)"ip adress for copy destination");
        OptionBuilder.hasArg();
        options.addOption(OptionBuilder.create((String)"dip"));
        OptionBuilder.withLongOpt((String)"ziel-user");
        OptionBuilder.withDescription((String)"destination User (default: pi");
        OptionBuilder.hasArg();
        options.addOption(OptionBuilder.create((String)"duser"));
        OptionBuilder.withLongOpt((String)"ziel-passwort");
        OptionBuilder.withDescription((String)"passwort from destination User");
        OptionBuilder.hasArg();
        options.addOption(OptionBuilder.create((String)"dpsw"));
        OptionBuilder.withLongOpt((String)"thing-speak-channel-id");
        OptionBuilder.withDescription((String)"channel ID for ThingSpeak");
        OptionBuilder.hasArg();
        options.addOption(OptionBuilder.create((String)"channel"));
        OptionBuilder.withLongOpt((String)"thing-speak-api-write-key");
        OptionBuilder.withDescription((String)"api write Key for ThingSpeak");
        OptionBuilder.hasArg();
        options.addOption(OptionBuilder.create((String)"writekey"));
        Parameter parameter = new Parameter();
        try {
            CommandLine line = parser.parse(options, args);
            parameter.setIp(line.getOptionValue("i"));
            parameter.setPort(line.getOptionValue("p"));
            parameter.setMaxCount(line.getOptionValue("max"));
            parameter.setMinCount(line.getOptionValue("min"));
            parameter.setBreite(line.getOptionValue("width"));
            parameter.setHoehe(line.getOptionValue("height"));
            if (line.hasOption("dpsw")) {
                parameter.setZielPasswort(line.getOptionValue("dpsw"));
            }
            if (line.hasOption("duser")) {
                parameter.setZielUser(line.getOptionValue("duser"));
            } else {
                parameter.setZielUser("pi");
            }
            if (line.hasOption("dip")) {
                parameter.setZielIp(line.getOptionValue("dip"));
            } else {
                parameter.setZielIp("pi-home");
            }
            if (line.hasOption("channel")) {
                parameter.setThingSpeakChannelId(Integer.valueOf(line.getOptionValue("channel")));
            } else {
                parameter.setThingSpeakChannelId(null);
            }
            if (line.hasOption("writekey")) {
                parameter.setThingSpeakApiWriteKey(line.getOptionValue("writekey"));
            } else {
                parameter.setThingSpeakApiWriteKey(null);
            }
            parameter.setRefreshTime(line.getOptionValue("r"));
            parameter.setCopyTime(line.getOptionValue("c"));
            if (line.hasOption("d")) {
                System.out.println("Starte TWFlug 0.1.0 im Debug Modus ...");
                LOG.debug("Starte TWFlug 0.1.0 im Debug Modus ...");
                parameter.setDebug(true);
            }
            if (line.hasOption("n")) {
                System.out.println("Starte TWFlug 0.1.0 ohne GUI ...");
                parameter.setNoGui(true);
            }
            if (line.hasOption("k")) {
                parameter.setCopy(true);
            }
            if (line.hasOption("v")) {
                System.out.println(ANWENDUNG_UND_VERSION);
                return null;
            }
            if (line.hasOption("h")) {
                Kommandozeile.printHelp(options);
                return null;
            }
            if (parameter.isDebug()) {
                System.out.println("Starte TWFlug 0.1.0 mit Parameter: " + parameter);
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("Starte TWFlug 0.1.0 mit Parameter: " + parameter);
            }
        }
        catch (ParseException exp) {
            System.out.println("Fehler beim parsen der Kommandozeile: " + exp.getMessage());
            Kommandozeile.printHelp(options);
            return null;
        }
        return parameter;
    }

    private static void printHelp(Options options) {
        HelpFormatter formatter = new HelpFormatter();
        formatter.printHelp(ANWENDUNG_NAME, options);
    }
}

