/*
 * Decompiled with CFR 0.152.
 */
package de.wenzlaff.twflug;

import com.jcraft.jsch.Channel;
import com.jcraft.jsch.ChannelExec;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.Session;
import com.jcraft.jsch.UserInfo;
import de.wenzlaff.twflug.Util;
import de.wenzlaff.twflug.be.Parameter;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Properties;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ScpTo {
    private static final Logger LOG = LogManager.getLogger((String)ScpTo.class.getName());

    public static void copyFile(Parameter parameter) {
        String zielUser = parameter.getZielUser();
        String zielPasswort = parameter.getZielPasswort();
        String zielIp = parameter.getZielIp();
        File lokaleOutputDatei = Util.getLokaleOutputDatei();
        File entfernteOutputDatei = Util.getEntfernteOutputDatei();
        if (lokaleOutputDatei != null && zielUser != null && zielPasswort != null && zielIp != null && entfernteOutputDatei != null) {
            if (parameter.isDebug()) {
                LOG.debug("Starte kopieren mit lokaleDatendatei=" + lokaleOutputDatei + ", user=" + zielUser + ", passwort=" + zielPasswort + ", host=" + zielIp + ", zielDatei=" + entfernteOutputDatei);
            }
            FileInputStream fis = null;
            try {
                int len;
                String lokalDateiPath = lokaleOutputDatei.getAbsolutePath();
                if (!lokaleOutputDatei.exists()) {
                    LOG.info("Konnte Datei " + lokalDateiPath + " nicht kopieren, da sie nicht vorhanden ist.");
                    return;
                }
                String zielDateiName = entfernteOutputDatei.getAbsolutePath();
                JSch jsch = new JSch();
                Session session = jsch.getSession(zielUser, zielIp, 22);
                PrivateUserInfo ui = new PrivateUserInfo();
                session.setUserInfo((UserInfo)ui);
                session.setPassword(zielPasswort);
                Properties config = new Properties();
                config.put("StrictHostKeyChecking", "no");
                session.setConfig(config);
                session.connect();
                boolean ptimestamp = true;
                String command = "scp " + (ptimestamp ? "-p" : "") + " -t " + zielDateiName;
                Channel channel = session.openChannel("exec");
                ((ChannelExec)channel).setCommand(command);
                OutputStream out = channel.getOutputStream();
                InputStream in = channel.getInputStream();
                channel.connect();
                if (ScpTo.checkAck(in) != 0) {
                    LOG.error("ERROR 1, kein kopieren erfolgt");
                    return;
                }
                File _lfile = new File(lokalDateiPath);
                if (ptimestamp) {
                    command = "T " + _lfile.lastModified() / 1000L + " 0";
                    command = command + " " + _lfile.lastModified() / 1000L + " 0\n";
                    out.write(command.getBytes());
                    out.flush();
                    if (ScpTo.checkAck(in) != 0) {
                        LOG.error("ERROR 2, kein kopieren erfolgt");
                        return;
                    }
                }
                long filesize = _lfile.length();
                command = "C0644 " + filesize + " ";
                command = lokalDateiPath.lastIndexOf(47) > 0 ? command + lokalDateiPath.substring(lokalDateiPath.lastIndexOf(47) + 1) : command + lokalDateiPath;
                command = command + "\n";
                out.write(command.getBytes());
                out.flush();
                if (ScpTo.checkAck(in) != 0) {
                    LOG.error("ERROR 3, kein kopieren erfolgt");
                    return;
                }
                fis = new FileInputStream(lokalDateiPath);
                byte[] buf = new byte[1024];
                while ((len = fis.read(buf, 0, buf.length)) > 0) {
                    out.write(buf, 0, len);
                }
                fis.close();
                fis = null;
                buf[0] = 0;
                out.write(buf, 0, 1);
                out.flush();
                if (ScpTo.checkAck(in) != 0) {
                    LOG.error("ERROR 4, kein kopieren erfolgt");
                    return;
                }
                out.close();
                channel.disconnect();
                session.disconnect();
                if (parameter.isDebug()) {
                    LOG.info("Ok, Datei " + zielDateiName + " auf Zielsystem IP: " + parameter.getZielIp() + " kopiert");
                }
            }
            catch (Exception e) {
                LOG.error((Object)e);
                try {
                    if (fis != null) {
                        fis.close();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (parameter.isDebug()) {
                LOG.info("Ok, Datei " + entfernteOutputDatei.getAbsolutePath() + " auf Zielsystem IP: " + parameter.getZielIp() + " kopiert");
            }
        } else {
            LOG.error("Konnte Datei nicht kopieren, da ein Parameter null ist. lokaleDatendatei=" + lokaleOutputDatei + ", zielUser=" + zielUser + ", passwort=" + zielPasswort + ", host=" + zielIp + ", zielDatei" + entfernteOutputDatei);
        }
    }

    private static int checkAck(InputStream in) throws IOException {
        int b = in.read();
        if (b == 0) {
            return b;
        }
        if (b == -1) {
            return b;
        }
        if (b == 1 || b == 2) {
            int c;
            StringBuffer sb = new StringBuffer();
            do {
                c = in.read();
                sb.append((char)c);
            } while (c != 10);
            if (b == 1) {
                LOG.error("Error" + sb.toString());
            }
            if (b == 2) {
                LOG.error("Fatal error" + sb.toString());
            }
        }
        return b;
    }

    public static class PrivateUserInfo
    implements UserInfo {
        public String getPassphrase() {
            return null;
        }

        public String getPassword() {
            return null;
        }

        public boolean promptPassword(String message) {
            return false;
        }

        public boolean promptPassphrase(String message) {
            return false;
        }

        public boolean promptYesNo(String message) {
            return false;
        }

        public void showMessage(String message) {
        }
    }
}

