/*
 * Decompiled with CFR 0.152.
 */
package de.wenzlaff.twflug.be;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class FieldDataRaw {
    private static final Logger LOG = LogManager.getLogger((String)FieldDataRaw.class.getName());
    private String messageType;
    private String transmissionType;
    private String sessionId;
    private String aircraftId;
    private String hexIdent;
    private String flightId;
    private String dateMessageGenerated;
    private String timeMessageGenerated;
    private String dateMessageLogged;
    private String timeMessageLogged;
    private String callsign;
    private String altitude;
    private String groundSpeed;
    private String track;
    private String latitude;
    private String longitude;
    private String verticalRate;
    private String squawk;
    private String alertSquawkChange;
    private String emergency;
    private String spiIdent;
    private String isOnGround;
    private static final SimpleDateFormat DATUMS_FORMAT_DE = new SimpleDateFormat("dd.MM.YY");
    private static final DateFormat DATUMS_FORMAT_US = new SimpleDateFormat("yyyy/MM/dd");

    public String getMessageType() {
        return this.messageType;
    }

    public void setMessageType(String messageType) {
        this.messageType = messageType;
    }

    public String getTransmissionType() {
        return this.transmissionType;
    }

    public void setTransmissionType(String transmissionType) {
        this.transmissionType = transmissionType;
    }

    public String getSessionId() {
        return this.sessionId;
    }

    public void setSessionId(String sessionId) {
        this.sessionId = sessionId;
    }

    public String getAircraftId() {
        return this.aircraftId;
    }

    public void setAircraftId(String aircraftId) {
        this.aircraftId = aircraftId;
    }

    public String getHexIdent() {
        return this.hexIdent;
    }

    public void setHexIdent(String hexIdent) {
        this.hexIdent = hexIdent;
    }

    public String getFlightId() {
        return this.flightId;
    }

    public void setFlightId(String flightId) {
        this.flightId = flightId;
    }

    public String getDateMessageGenerated() {
        return this.dateMessageGenerated;
    }

    public void setDateMessageGenerated(String dateMessageGenerated) {
        this.dateMessageGenerated = dateMessageGenerated;
    }

    public String getTimeMessageGenerated() {
        return this.timeMessageGenerated;
    }

    public void setTimeMessageGenerated(String timeMessageGenerated) {
        this.timeMessageGenerated = timeMessageGenerated;
    }

    public String getDateMessageLogged() {
        return this.dateMessageLogged;
    }

    public void setDateMessageLogged(String dateMessageLogged) {
        this.dateMessageLogged = dateMessageLogged;
    }

    public String getTimeMessageLogged() {
        return this.timeMessageLogged;
    }

    public void setTimeMessageLogged(String timeMessageLogged) {
        this.timeMessageLogged = timeMessageLogged;
    }

    public String getCallsign() {
        return this.callsign;
    }

    public void setCallsign(String callsign) {
        this.callsign = callsign;
    }

    public String getAltitude() {
        return this.altitude;
    }

    public void setAltitude(String altitude) {
        this.altitude = altitude;
    }

    public String getGroundSpeed() {
        return this.groundSpeed;
    }

    public void setGroundSpeed(String groundSpeed) {
        this.groundSpeed = groundSpeed;
    }

    public String getTrack() {
        return this.track;
    }

    public void setTrack(String track) {
        this.track = track;
    }

    public String getLatitude() {
        return this.latitude;
    }

    public void setLatitude(String latitude) {
        this.latitude = latitude;
    }

    public String getLongitude() {
        return this.longitude;
    }

    public void setLongitude(String longitude) {
        this.longitude = longitude;
    }

    public String getVerticalRate() {
        return this.verticalRate;
    }

    public void setVerticalRate(String verticalRate) {
        this.verticalRate = verticalRate;
    }

    public String getSquawk() {
        return this.squawk;
    }

    public void setSquawk(String squawk) {
        this.squawk = squawk;
    }

    public SQUAWK_CHANGE isSquawkChangey() {
        if (this.alertSquawkChange == null) {
            return SQUAWK_CHANGE.NOT_USED;
        }
        if (this.alertSquawkChange.equals("0")) {
            return SQUAWK_CHANGE.NO;
        }
        if (this.alertSquawkChange.equals("1")) {
            return SQUAWK_CHANGE.YES;
        }
        return SQUAWK_CHANGE.NOT_USED;
    }

    public String getAlertSquawkChange() {
        return this.alertSquawkChange;
    }

    public void setAlertSquawkChange(String alertSquawkChange) {
        this.alertSquawkChange = alertSquawkChange;
    }

    public String getEmergency() {
        return this.emergency;
    }

    public void setEmergency(String emergency) {
        this.emergency = emergency;
    }

    public EMERGENCY isEmergency() {
        if (this.emergency == null) {
            return EMERGENCY.NOT_USED;
        }
        if (this.emergency.equals("0")) {
            return EMERGENCY.NO;
        }
        if (this.emergency.equals("1")) {
            return EMERGENCY.YES;
        }
        return EMERGENCY.NOT_USED;
    }

    public String getSpiIdent() {
        return this.spiIdent;
    }

    public void setSpiIdent(String spiIdent) {
        this.spiIdent = spiIdent;
    }

    public SPI_IDENT isSpiIdent() {
        if (this.spiIdent == null) {
            return SPI_IDENT.NOT_USED;
        }
        if (this.spiIdent.equals("0")) {
            return SPI_IDENT.NO;
        }
        if (this.spiIdent.equals("1")) {
            return SPI_IDENT.YES;
        }
        return SPI_IDENT.NOT_USED;
    }

    public String getIsOnGround() {
        return this.isOnGround;
    }

    public ON_GROUND isOnGround() {
        if (this.isOnGround == null) {
            return ON_GROUND.NOT_USED;
        }
        if (this.isOnGround.equals("0")) {
            return ON_GROUND.NO;
        }
        if (this.isOnGround.equals("1")) {
            return ON_GROUND.YES;
        }
        return ON_GROUND.NOT_USED;
    }

    public void setIsOnGround(String isOnGround) {
        this.isOnGround = isOnGround.trim();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.hexIdent == null ? 0 : this.hexIdent.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        FieldDataRaw other = (FieldDataRaw)obj;
        return !(this.hexIdent == null ? other.hexIdent != null : !this.hexIdent.equals(other.hexIdent));
    }

    public String getDatumFormatiert(Date date) {
        return DATUMS_FORMAT_DE.format(date);
    }

    public Date getMessageLogged() {
        Date date = this.parseDatum(this.dateMessageLogged);
        return date;
    }

    public Date getMessageGenerated() {
        Date date = this.parseDatum(this.dateMessageGenerated);
        return date;
    }

    private Date parseDatum(String datum) {
        Date date = null;
        try {
            date = DATUMS_FORMAT_US.parse(datum);
        }
        catch (ParseException e) {
            System.out.println("Parse Error mit Datum (" + datum + ") deshalb mit Systemdatum gefixt");
            date = new Date(System.currentTimeMillis());
            System.out.println("Verwende als Datum nun: " + datum);
        }
        return date;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("FieldDataRaw: ");
        if (this.hexIdent != null && !this.hexIdent.isEmpty()) {
            builder.append("hexIdent=");
            builder.append(this.hexIdent);
            builder.append(", ");
        }
        if (this.messageType != null && !this.messageType.isEmpty()) {
            builder.append("messageType=");
            builder.append(this.messageType);
            builder.append(", ");
        }
        if (this.transmissionType != null && !this.transmissionType.isEmpty()) {
            builder.append("transmissionType=");
            builder.append(this.transmissionType);
            builder.append(", ");
        }
        if (this.sessionId != null && !this.sessionId.isEmpty()) {
            builder.append("sessionId=");
            builder.append(this.sessionId);
            builder.append(", ");
        }
        if (this.aircraftId != null && !this.aircraftId.isEmpty()) {
            builder.append("aircraftId=");
            builder.append(this.aircraftId);
            builder.append(", ");
        }
        if (this.flightId != null && !this.flightId.isEmpty()) {
            builder.append("flightId=");
            builder.append(this.flightId);
            builder.append(", ");
        }
        if (this.dateMessageGenerated != null && !this.dateMessageGenerated.isEmpty()) {
            builder.append("dateMessageGenerated=");
            builder.append(this.getDatumFormatiert(this.getMessageGenerated()));
            builder.append(", ");
        }
        if (this.timeMessageGenerated != null && !this.timeMessageGenerated.isEmpty()) {
            builder.append("timeMessageGenerated=");
            builder.append(this.timeMessageGenerated);
            builder.append(", ");
        }
        if (this.dateMessageLogged != null && !this.dateMessageLogged.isEmpty()) {
            builder.append("dateMessageLogged=");
            builder.append(this.getDatumFormatiert(this.getMessageLogged()));
            builder.append(", ");
        }
        if (this.timeMessageLogged != null && !this.timeMessageLogged.isEmpty()) {
            builder.append("timeMessageLogged=");
            builder.append(this.timeMessageLogged);
            builder.append(", ");
        }
        if (this.callsign != null && !this.callsign.isEmpty()) {
            builder.append("callsign=");
            builder.append(this.callsign);
            builder.append(", ");
        }
        if (this.altitude != null && !this.altitude.isEmpty()) {
            builder.append("altitude=");
            builder.append(this.altitude);
            builder.append(", ");
        }
        if (this.groundSpeed != null && !this.groundSpeed.isEmpty()) {
            builder.append("groundSpeed=");
            builder.append(this.groundSpeed);
            builder.append(", ");
        }
        if (this.track != null && !this.track.isEmpty()) {
            builder.append("track=");
            builder.append(this.track);
            builder.append(", ");
        }
        if (this.latitude != null && !this.latitude.isEmpty()) {
            builder.append("latitude=");
            builder.append(this.latitude);
            builder.append(", ");
        }
        if (this.longitude != null && !this.longitude.isEmpty()) {
            builder.append("longitude=");
            builder.append(this.longitude);
            builder.append(", ");
        }
        if (this.verticalRate != null && !this.verticalRate.isEmpty()) {
            builder.append("verticalRate=");
            builder.append(this.verticalRate);
            builder.append(", ");
        }
        if (this.squawk != null && !this.squawk.isEmpty()) {
            builder.append("squawk=");
            builder.append(this.squawk);
            builder.append(", ");
        }
        if (this.alertSquawkChange != null && !this.alertSquawkChange.isEmpty() && this.isSquawkChangey() != SQUAWK_CHANGE.NOT_USED) {
            builder.append("alertSquawkChange=");
            builder.append((Object)this.isSquawkChangey());
            builder.append(", ");
        }
        if (this.emergency != null && !this.emergency.isEmpty() && this.isEmergency() != EMERGENCY.NOT_USED) {
            builder.append("emergency=");
            builder.append((Object)this.isEmergency());
            builder.append(", ");
        }
        if (this.spiIdent != null && !this.spiIdent.isEmpty() && this.isSpiIdent() != SPI_IDENT.NOT_USED) {
            builder.append("spiIdent=");
            builder.append((Object)this.isSpiIdent());
            builder.append(", ");
        }
        if (this.isOnGround != null && !this.isOnGround.isEmpty() && this.isOnGround() != ON_GROUND.NOT_USED) {
            builder.append("isOnGround=");
            builder.append((Object)this.isOnGround());
        }
        return builder.toString();
    }

    public static enum SQUAWK_CHANGE {
        YES,
        NO,
        NOT_USED;

    }

    public static enum EMERGENCY {
        YES,
        NO,
        NOT_USED;

    }

    public static enum SPI_IDENT {
        YES,
        NO,
        NOT_USED;

    }

    public static enum ON_GROUND {
        YES,
        NO,
        NOT_USED;

    }
}

