/*
 * Decompiled with CFR 0.152.
 */
package de.wenzlaff.twflug.gui;

import de.wenzlaff.twflug.be.Parameter;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GradientPaint;
import java.awt.Paint;
import java.awt.Point;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.dial.DialBackground;
import org.jfree.chart.plot.dial.DialFrame;
import org.jfree.chart.plot.dial.DialLayer;
import org.jfree.chart.plot.dial.DialPlot;
import org.jfree.chart.plot.dial.DialPointer;
import org.jfree.chart.plot.dial.DialScale;
import org.jfree.chart.plot.dial.DialTextAnnotation;
import org.jfree.chart.plot.dial.DialValueIndicator;
import org.jfree.chart.plot.dial.StandardDialFrame;
import org.jfree.chart.plot.dial.StandardDialScale;
import org.jfree.data.general.DefaultValueDataset;
import org.jfree.data.general.ValueDataset;
import org.jfree.ui.GradientPaintTransformType;
import org.jfree.ui.GradientPaintTransformer;
import org.jfree.ui.StandardGradientPaintTransformer;

public class HauptFenster {
    private final JFrame frame = new JFrame();
    private static DefaultValueDataset anzahlFlugzeuge;
    private DialPlot plot;
    private static boolean isNoGui;

    public void aktualisieren(int maxAnzahl) {
        anzahlFlugzeuge = new DefaultValueDataset((double)maxAnzahl);
        this.plot.setDataset((ValueDataset)anzahlFlugzeuge);
    }

    public HauptFenster(Parameter parameter) {
        isNoGui = parameter.isNoGui();
        this.frame.setPreferredSize(new Dimension(parameter.getBreite(), parameter.getHoehe()));
        this.frame.add((Component)this.buildDialPlot(parameter.getMinCount(), parameter.getMaxCount(), 10));
        this.frame.pack();
        this.frame.setLocationRelativeTo(null);
        this.frame.setDefaultCloseOperation(3);
        this.frame.setTitle("Anzahl sichtbarer Flugzeuge");
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                HauptFenster.this.frame.setVisible(!isNoGui);
            }
        });
    }

    private ChartPanel buildDialPlot(int minimumValue, int maximumValue, int majorTickGap) {
        this.plot = new DialPlot((ValueDataset)anzahlFlugzeuge);
        this.plot.setDialFrame((DialFrame)new StandardDialFrame());
        DialValueIndicator wert = new DialValueIndicator(0);
        wert.getNumberFormat().setMinimumFractionDigits(0);
        this.plot.addLayer((DialLayer)wert);
        this.plot.addLayer((DialLayer)new DialPointer.Pointer());
        GradientPaint graPaint = new GradientPaint(new Point(), new Color(255, 255, 255), new Point(), new Color(170, 170, 220));
        DialBackground background = new DialBackground((Paint)graPaint);
        background.setGradientPaintTransformer((GradientPaintTransformer)new StandardGradientPaintTransformer(GradientPaintTransformType.VERTICAL));
        this.plot.setBackground((DialLayer)background);
        StandardDialScale scale = new StandardDialScale((double)minimumValue, (double)maximumValue, -120.0, -300.0, (double)majorTickGap, majorTickGap - 1);
        scale.setTickRadius(0.88);
        scale.setTickLabelOffset(0.2);
        scale.setTickLabelFormatter((NumberFormat)new DecimalFormat());
        this.plot.addScale(0, (DialScale)scale);
        DialTextAnnotation annotation1 = new DialTextAnnotation("Flugzeuge");
        annotation1.setFont(new Font("Dialog", 1, 16));
        annotation1.setRadius(0.7);
        this.plot.addLayer((DialLayer)annotation1);
        ChartPanel chartPanel = new ChartPanel(new JFreeChart((Plot)this.plot));
        return chartPanel;
    }
}

