/*
 * Decompiled with CFR 0.152.
 */
package de.westnordost.countryboundaries;

import de.westnordost.countryboundaries.CountryBoundariesCell;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class CountryBoundaries {
    private final CountryBoundariesCell[] raster;
    private final int rasterWidth;
    private final Map<String, Double> geometrySizes;

    CountryBoundaries(CountryBoundariesCell[] raster, int rasterWidth, Map<String, Double> geometrySizes) {
        this.raster = raster;
        this.rasterWidth = rasterWidth;
        this.geometrySizes = geometrySizes;
    }

    public static CountryBoundaries load(InputStream is) throws IOException {
        return CountryBoundaries.read(new ObjectInputStream(is));
    }

    public boolean isInAny(double longitude, double latitude, Collection<String> ids) {
        return this.getCell(longitude, latitude).isInAny(longitude, latitude, ids);
    }

    public boolean isIn(double longitude, double latitude, String id) {
        return this.isInAny(longitude, latitude, Collections.singleton(id));
    }

    public List<String> getIds(double longitude, double latitude) {
        List<String> result = this.getCell(longitude, latitude).getIds(longitude, latitude);
        Collections.sort(result, this::compareSize);
        return result;
    }

    public Set<String> getContainingIds(double minLongitude, double minLatitude, double maxLongitude, double maxLatitude) {
        HashSet<String> ids = new HashSet<String>();
        this.forCellsIn(minLongitude, minLatitude, maxLongitude, maxLatitude, cell -> {
            if (ids.isEmpty()) {
                ids.addAll(cell.getContainingIds());
            } else {
                ids.retainAll(cell.getContainingIds());
            }
        });
        return ids;
    }

    public Set<String> getIntersectingIds(double minLongitude, double minLatitude, double maxLongitude, double maxLatitude) {
        HashSet<String> ids = new HashSet<String>();
        this.forCellsIn(minLongitude, minLatitude, maxLongitude, maxLatitude, cell -> ids.addAll(cell.getAllIds()));
        return ids;
    }

    private void forCellsIn(double minLongitude, double minLatitude, double maxLongitude, double maxLatitude, CellRunnable runnable) {
        if (minLatitude < -90.0 || minLatitude > 90.0) {
            throw new IllegalArgumentException("minLatitude is out of bounds");
        }
        if (maxLatitude < -90.0 || maxLatitude > 90.0) {
            throw new IllegalArgumentException("maxLatitude is out of bounds");
        }
        if (minLatitude > maxLatitude) {
            throw new IllegalArgumentException("maxLatitude is smaller than minLatitude");
        }
        int minX = this.longitudeToCellX(minLongitude);
        int maxY = this.latitudeToCellY(minLatitude);
        int maxX = this.longitudeToCellX(maxLongitude);
        int minY = this.latitudeToCellY(maxLatitude);
        int stepsX = minX > maxX ? this.rasterWidth - minX + maxX : maxX - minX;
        for (int xStep = 0; xStep <= stepsX; ++xStep) {
            int x = (minX + xStep) % this.rasterWidth;
            for (int y = minY; y <= maxY; ++y) {
                runnable.run(this.raster[y * this.rasterWidth + x]);
            }
        }
    }

    private CountryBoundariesCell getCell(double longitude, double latitude) {
        if (latitude < -90.0 || latitude > 90.0) {
            throw new IllegalArgumentException("latitude is out of bounds");
        }
        int x = this.longitudeToCellX(longitude);
        int y = this.latitudeToCellY(latitude);
        return this.raster[y * this.rasterWidth + x];
    }

    private int longitudeToCellX(double longitude) {
        return (int)Math.min((double)(this.rasterWidth - 1), Math.floor((180.0 + CountryBoundaries.normalize(longitude, -180.0, 360.0)) / 360.0 * (double)this.rasterWidth));
    }

    private int latitudeToCellY(double latitude) {
        int rasterHeight = this.raster.length / this.rasterWidth;
        return (int)Math.min((double)(rasterHeight - 1), Math.floor((90.0 - latitude) / 180.0 * (double)rasterHeight));
    }

    private static double normalize(double value, double startAt, double base) {
        while (value < startAt) {
            value += base;
        }
        while (value > startAt + base) {
            value -= base;
        }
        return value;
    }

    private double getSize(String id) {
        Double size = this.geometrySizes.get(id);
        return size != null ? size : 0.0;
    }

    private int compareSize(String isoCode1, String isoCode2) {
        return (int)(this.getSize(isoCode1) - this.getSize(isoCode2));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CountryBoundaries that = (CountryBoundaries)o;
        return this.rasterWidth == that.rasterWidth && Arrays.equals(this.raster, that.raster) && this.geometrySizes.equals(that.geometrySizes);
    }

    public int hashCode() {
        return this.rasterWidth + 31 * (Arrays.hashCode(this.raster) + 31 * this.geometrySizes.hashCode());
    }

    void write(ObjectOutputStream out) throws IOException {
        out.writeInt(this.geometrySizes.size());
        for (Map.Entry<String, Double> e : this.geometrySizes.entrySet()) {
            out.writeUTF(e.getKey());
            out.writeDouble(e.getValue());
        }
        out.writeInt(this.rasterWidth);
        out.writeInt(this.raster.length);
        for (int c = 0; c < this.raster.length; ++c) {
            this.raster[c].write(out);
        }
    }

    static CountryBoundaries read(ObjectInputStream in) throws IOException {
        int geometrySizesCount = in.readInt();
        HashMap<String, Double> geometrySizes = new HashMap<String, Double>(geometrySizesCount);
        for (int i = 0; i < geometrySizesCount; ++i) {
            geometrySizes.put(in.readUTF().intern(), in.readDouble());
        }
        int rasterWidth = in.readInt();
        int rasterSize = in.readInt();
        CountryBoundariesCell[] raster = new CountryBoundariesCell[rasterSize];
        for (int i = 0; i < rasterSize; ++i) {
            raster[i] = CountryBoundariesCell.read(in);
        }
        return new CountryBoundaries(raster, rasterWidth, geometrySizes);
    }

    private static interface CellRunnable {
        public void run(CountryBoundariesCell var1);
    }
}

