/*
 * Decompiled with CFR 0.152.
 */
package de.westnordost.countryboundaries;

import de.westnordost.countryboundaries.Point;
import java.util.Arrays;

class CountryAreas {
    final String id;
    final Point[][] outer;
    final Point[][] inner;

    CountryAreas(String id, Point[][] outer, Point[][] inner) {
        this.id = id;
        this.outer = outer;
        this.inner = inner;
    }

    boolean covers(Point point) {
        int insides = 0;
        for (Point[] area : this.outer) {
            if (!CountryAreas.isPointInPolygon(point, area)) continue;
            ++insides;
        }
        for (Point[] area : this.inner) {
            if (!CountryAreas.isPointInPolygon(point, area)) continue;
            --insides;
        }
        return insides > 0;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CountryAreas that = (CountryAreas)o;
        return this.id.equals(that.id) && Arrays.deepEquals((Object[])this.inner, (Object[])that.inner) && Arrays.deepEquals((Object[])this.outer, (Object[])that.outer);
    }

    public int hashCode() {
        return 31 * (31 * this.id.hashCode() + Arrays.deepHashCode((Object[])this.outer)) + Arrays.deepHashCode((Object[])this.inner);
    }

    public String toString() {
        return "" + this.id + ":" + Arrays.deepToString((Object[])this.outer) + " - " + Arrays.deepToString((Object[])this.inner);
    }

    private static boolean isPointInPolygon(Point p, Point[] v) {
        int wn = 0;
        if (v.length == 0) {
            return false;
        }
        Point a = v[v.length - 1];
        for (Point b : v) {
            if (a.y <= p.y) {
                if (b.y > p.y && CountryAreas.isLeft(a, b, p) > 0L) {
                    ++wn;
                }
            } else if (b.y <= p.y && CountryAreas.isLeft(a, b, p) < 0L) {
                --wn;
            }
            a = b;
        }
        return wn != 0;
    }

    private static long isLeft(Point p0, Point p1, Point p) {
        return ((long)p1.x - (long)p0.x) * ((long)p.y - (long)p0.y) - ((long)p.x - (long)p0.x) * ((long)p1.y - (long)p0.y);
    }
}

