/*
 * Decompiled with CFR 0.152.
 */
package de.westnordost.countryboundaries;

import de.westnordost.countryboundaries.CountryAreas;
import de.westnordost.countryboundaries.Point;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;

class CountryBoundariesCell {
    final Collection<String> containingIds;
    final Collection<CountryAreas> intersectingCountries;

    CountryBoundariesCell(Collection<String> containingIds, Collection<CountryAreas> intersectingCountries) {
        this.containingIds = containingIds;
        this.intersectingCountries = intersectingCountries;
    }

    boolean isInAny(int x, int y, Collection<String> ids) {
        for (String id : this.containingIds) {
            if (!ids.contains(id)) continue;
            return true;
        }
        if (!this.intersectingCountries.isEmpty()) {
            Point point = new Point(x, y);
            for (CountryAreas areas : this.intersectingCountries) {
                if (!ids.contains(areas.id) || !areas.covers(point)) continue;
                return true;
            }
        }
        return false;
    }

    List<String> getIds(int x, int y) {
        ArrayList<String> result = new ArrayList<String>(this.containingIds.size());
        result.addAll(this.containingIds);
        if (!this.intersectingCountries.isEmpty()) {
            Point point = new Point(x, y);
            for (CountryAreas areas : this.intersectingCountries) {
                if (!areas.covers(point)) continue;
                result.add(areas.id);
            }
        }
        return result;
    }

    Collection<String> getAllIds() {
        ArrayList<String> result = new ArrayList<String>(this.containingIds.size() + this.intersectingCountries.size());
        result.addAll(this.containingIds);
        for (CountryAreas areas : this.intersectingCountries) {
            result.add(areas.id);
        }
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CountryBoundariesCell that = (CountryBoundariesCell)o;
        return this.containingIds.equals(that.containingIds) && this.intersectingCountries.equals(that.intersectingCountries);
    }

    public int hashCode() {
        return 31 * this.containingIds.hashCode() + this.intersectingCountries.hashCode();
    }

    public String toString() {
        return Arrays.toString(this.containingIds.toArray()) + " " + Arrays.toString(this.intersectingCountries.toArray());
    }
}

