/*
 * Decompiled with CFR 0.152.
 */
package de.westnordost.osm_opening_hours.model;

import de.westnordost.osm_opening_hours.model.ClockTime;
import de.westnordost.osm_opening_hours.model.ExtendedClockTime;
import de.westnordost.osm_opening_hours.model.ExtendedTime;
import de.westnordost.osm_opening_hours.model.Time;
import de.westnordost.osm_opening_hours.model.TimeSpansSelector;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\t\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\b\u0010\u0010\u001a\u00020\u0011H\u0016J\t\u0010\u0012\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0013\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0014\u001a\u00020\u0007H\u00c6\u0003J'\u0010\u0015\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0007H\u00c6\u0001J\u0013\u0010\u0016\u001a\u00020\u00072\b\u0010\u0017\u001a\u0004\u0018\u00010\u0018H\u00d6\u0003J\t\u0010\u0019\u001a\u00020\u001aH\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u001b"}, d2={"Lde/westnordost/osm_opening_hours/model/TimeSpan;", "Lde/westnordost/osm_opening_hours/model/TimeSpansSelector;", "start", "Lde/westnordost/osm_opening_hours/model/Time;", "end", "Lde/westnordost/osm_opening_hours/model/ExtendedTime;", "openEnd", "", "<init>", "(Lde/westnordost/osm_opening_hours/model/Time;Lde/westnordost/osm_opening_hours/model/ExtendedTime;Z)V", "getStart", "()Lde/westnordost/osm_opening_hours/model/Time;", "getEnd", "()Lde/westnordost/osm_opening_hours/model/ExtendedTime;", "getOpenEnd", "()Z", "toString", "", "component1", "component2", "component3", "copy", "equals", "other", "", "hashCode", "", "osm-opening-hours"})
public final class TimeSpan
implements TimeSpansSelector {
    @NotNull
    private final Time start;
    @NotNull
    private final ExtendedTime end;
    private final boolean openEnd;

    public TimeSpan(@NotNull Time start, @NotNull ExtendedTime end, boolean openEnd) {
        Intrinsics.checkNotNullParameter((Object)start, (String)"start");
        Intrinsics.checkNotNullParameter((Object)end, (String)"end");
        this.start = start;
        this.end = end;
        this.openEnd = openEnd;
    }

    public /* synthetic */ TimeSpan(Time time, ExtendedTime extendedTime, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            bl = false;
        }
        this(time, extendedTime, bl);
    }

    @NotNull
    public final Time getStart() {
        return this.start;
    }

    @NotNull
    public final ExtendedTime getEnd() {
        return this.end;
    }

    public final boolean getOpenEnd() {
        return this.openEnd;
    }

    @NotNull
    public String toString() {
        ExtendedTime beautifiedEnd = this.end;
        if (this.end instanceof ExtendedClockTime) {
            int endMin = ((ExtendedClockTime)this.end).getHour() * 60 + ((ExtendedClockTime)this.end).getMinutes();
            if (this.start instanceof ClockTime) {
                int startMin = ((ClockTime)this.start).getHour() * 60 + ((ClockTime)this.start).getMinutes();
                int hour24 = 1440;
                if (endMin > hour24 && endMin - startMin < hour24) {
                    beautifiedEnd = ExtendedClockTime.copy$default((ExtendedClockTime)this.end, ((ExtendedClockTime)this.end).getHour() - 24, 0, 2, null);
                } else if (endMin == 0 && startMin > 0) {
                    beautifiedEnd = new ExtendedClockTime(24, 0, 2, null);
                }
            } else if (endMin == 0) {
                beautifiedEnd = new ExtendedClockTime(24, 0, 2, null);
            }
        }
        return this.start + "-" + beautifiedEnd + (this.openEnd ? "+" : "");
    }

    @NotNull
    public final Time component1() {
        return this.start;
    }

    @NotNull
    public final ExtendedTime component2() {
        return this.end;
    }

    public final boolean component3() {
        return this.openEnd;
    }

    @NotNull
    public final TimeSpan copy(@NotNull Time start, @NotNull ExtendedTime end, boolean openEnd) {
        Intrinsics.checkNotNullParameter((Object)start, (String)"start");
        Intrinsics.checkNotNullParameter((Object)end, (String)"end");
        return new TimeSpan(start, end, openEnd);
    }

    public static /* synthetic */ TimeSpan copy$default(TimeSpan timeSpan, Time time, ExtendedTime extendedTime, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            time = timeSpan.start;
        }
        if ((n & 2) != 0) {
            extendedTime = timeSpan.end;
        }
        if ((n & 4) != 0) {
            bl = timeSpan.openEnd;
        }
        return timeSpan.copy(time, extendedTime, bl);
    }

    public int hashCode() {
        int result = this.start.hashCode();
        result = result * 31 + this.end.hashCode();
        result = result * 31 + Boolean.hashCode(this.openEnd);
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof TimeSpan)) {
            return false;
        }
        TimeSpan timeSpan = (TimeSpan)other;
        if (!Intrinsics.areEqual((Object)this.start, (Object)timeSpan.start)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.end, (Object)timeSpan.end)) {
            return false;
        }
        return this.openEnd == timeSpan.openEnd;
    }
}

