/*
 * Decompiled with CFR 0.152.
 */
package de.westnordost.osm_opening_hours.parser;

import de.westnordost.osm_opening_hours.model.AnnualEvent;
import de.westnordost.osm_opening_hours.model.CalendarDate;
import de.westnordost.osm_opening_hours.model.Date;
import de.westnordost.osm_opening_hours.model.DateRange;
import de.westnordost.osm_opening_hours.model.DatesInMonth;
import de.westnordost.osm_opening_hours.model.LastNth;
import de.westnordost.osm_opening_hours.model.Month;
import de.westnordost.osm_opening_hours.model.MonthDay;
import de.westnordost.osm_opening_hours.model.MonthDayRange;
import de.westnordost.osm_opening_hours.model.MonthDaySelector;
import de.westnordost.osm_opening_hours.model.MonthRange;
import de.westnordost.osm_opening_hours.model.MonthsOrDateSelector;
import de.westnordost.osm_opening_hours.model.NextWeekday;
import de.westnordost.osm_opening_hours.model.Nth;
import de.westnordost.osm_opening_hours.model.NthPointSelector;
import de.westnordost.osm_opening_hours.model.PreviousWeekday;
import de.westnordost.osm_opening_hours.model.SingleMonth;
import de.westnordost.osm_opening_hours.model.SpecificWeekdayDate;
import de.westnordost.osm_opening_hours.model.StartingAtDate;
import de.westnordost.osm_opening_hours.model.VariableDate;
import de.westnordost.osm_opening_hours.model.Weekday;
import de.westnordost.osm_opening_hours.model.WeekdayOffset;
import de.westnordost.osm_opening_hours.parser.HolidaySelectorParserKt;
import de.westnordost.osm_opening_hours.parser.ParseUtilsKt;
import de.westnordost.osm_opening_hours.parser.StringWithCursor;
import de.westnordost.osm_opening_hours.parser.TimesSelectorParserKt;
import de.westnordost.osm_opening_hours.parser.WeekdaysSelectorParserKt;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.NoSuchElementException;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u0000^\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\b\u0006\u001a\u0016\u0010\u0000\u001a\u0004\u0018\u00010\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u0004H\u0000\u001a%\u0010\u0005\u001a\u0004\u0018\u00010\u0006*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u00042\b\u0010\u0007\u001a\u0004\u0018\u00010\bH\u0000\u00a2\u0006\u0002\u0010\t\u001a-\u0010\n\u001a\u0004\u0018\u00010\u000b*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u00042\b\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\f\u001a\u00020\rH\u0002\u00a2\u0006\u0002\u0010\u000e\u001a\u0014\u0010\u000f\u001a\u00020\u0004*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u0004H\u0002\u001a-\u0010\u0010\u001a\u0004\u0018\u00010\u0011*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u00042\b\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\f\u001a\u00020\rH\u0002\u00a2\u0006\u0002\u0010\u0012\u001a\u0014\u0010\u0013\u001a\u00020\u0004*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u0004H\u0002\u001a\u0016\u0010\u0014\u001a\u0004\u0018\u00010\u0015*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u0004H\u0002\u001a%\u0010\u0016\u001a\u0004\u0018\u00010\u0017*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u00042\b\u0010\u0007\u001a\u0004\u0018\u00010\bH\u0000\u00a2\u0006\u0002\u0010\u0018\u001a\u0016\u0010\u0019\u001a\u0004\u0018\u00010\u001a*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u0004H\u0002\u001a\u0016\u0010\u001b\u001a\u0004\u0018\u00010\u001c*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u0004H\u0000\u001a\u0016\u0010\u001d\u001a\u0004\u0018\u00010\r*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u0004H\u0000\u001a\u000e\u0010\"\u001a\u0004\u0018\u00010\r*\u00020\u0002H\u0002\u001a\u000e\u0010%\u001a\u0004\u0018\u00010\r*\u00020\u0002H\u0002\"\u001a\u0010\u001e\u001a\u000e\u0012\u0004\u0012\u00020 \u0012\u0004\u0012\u00020\r0\u001fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010!\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u001a\u0010#\u001a\u000e\u0012\u0004\u0012\u00020 \u0012\u0004\u0012\u00020\r0\u001fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010$\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"parseMonthsOrDatesSelector", "Lde/westnordost/osm_opening_hours/model/MonthsOrDateSelector;", "Lde/westnordost/osm_opening_hours/parser/StringWithCursor;", "lenient", "", "parseDate", "Lde/westnordost/osm_opening_hours/model/Date;", "year", "", "(Lde/westnordost/osm_opening_hours/parser/StringWithCursor;ZLjava/lang/Integer;)Lde/westnordost/osm_opening_hours/model/Date;", "parseCalendarDate", "Lde/westnordost/osm_opening_hours/model/CalendarDate;", "month", "Lde/westnordost/osm_opening_hours/model/Month;", "(Lde/westnordost/osm_opening_hours/parser/StringWithCursor;ZLjava/lang/Integer;Lde/westnordost/osm_opening_hours/model/Month;)Lde/westnordost/osm_opening_hours/model/CalendarDate;", "nextIsClockTime", "parseSpecificWeekdayDate", "Lde/westnordost/osm_opening_hours/model/SpecificWeekdayDate;", "(Lde/westnordost/osm_opening_hours/parser/StringWithCursor;ZLjava/lang/Integer;Lde/westnordost/osm_opening_hours/model/Month;)Lde/westnordost/osm_opening_hours/model/SpecificWeekdayDate;", "nextIsWeekdayOrHolidaySelector", "parseWeekdayOffset", "Lde/westnordost/osm_opening_hours/model/WeekdayOffset;", "parseDatesInMonth", "Lde/westnordost/osm_opening_hours/model/DatesInMonth;", "(Lde/westnordost/osm_opening_hours/parser/StringWithCursor;ZLjava/lang/Integer;)Lde/westnordost/osm_opening_hours/model/DatesInMonth;", "parseMonthDaySelector", "Lde/westnordost/osm_opening_hours/model/MonthDaySelector;", "parseAnnualEvent", "Lde/westnordost/osm_opening_hours/model/AnnualEvent;", "parseMonth", "monthsMap", "", "", "monthsMaxLength", "parseMonthStrict", "lenientMonthsMap", "lenientMonthsMaxLength", "parseMonthLenient", "osm-opening-hours"})
@SourceDebugExtension(value={"SMAP\nMonthsOrDateSelectorParser.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MonthsOrDateSelectorParser.kt\nde/westnordost/osm_opening_hours/parser/MonthsOrDateSelectorParserKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,254:1\n1#2:255\n1202#3,2:256\n1230#3,4:258\n1202#3,2:262\n1230#3,4:264\n1202#3,2:268\n1230#3,4:270\n1246#3,4:276\n477#4:274\n423#4:275\n*S KotlinDebug\n*F\n+ 1 MonthsOrDateSelectorParser.kt\nde/westnordost/osm_opening_hours/parser/MonthsOrDateSelectorParserKt\n*L\n214#1:256,2\n214#1:258,4\n226#1:262,2\n226#1:264,4\n228#1:268,2\n228#1:270,4\n244#1:276,4\n244#1:274\n244#1:275\n*E\n"})
public final class MonthsOrDateSelectorParserKt {
    @NotNull
    private static final Map<String, Month> monthsMap;
    private static final int monthsMaxLength;
    @NotNull
    private static final Map<String, Month> lenientMonthsMap;
    private static final int lenientMonthsMaxLength;

    @Nullable
    public static final MonthsOrDateSelector parseMonthsOrDatesSelector(@NotNull StringWithCursor $this$parseMonthsOrDatesSelector, boolean lenient) {
        DatesInMonth datesInMonth;
        Intrinsics.checkNotNullParameter((Object)$this$parseMonthsOrDatesSelector, (String)"<this>");
        int initial = $this$parseMonthsOrDatesSelector.getCursor();
        String yearStr = ParseUtilsKt.nextNumberAndAdvance($this$parseMonthsOrDatesSelector, 4);
        if (yearStr != null) {
            if (yearStr.length() != 4) {
                $this$parseMonthsOrDatesSelector.retreatBy(yearStr.length());
            } else {
                ParseUtilsKt.skipWhitespaces($this$parseMonthsOrDatesSelector, lenient);
            }
        }
        String string = yearStr;
        Integer year = string != null ? Integer.valueOf(Integer.parseInt(string)) : null;
        DatesInMonth datesInMonth2 = datesInMonth = MonthsOrDateSelectorParserKt.parseDatesInMonth($this$parseMonthsOrDatesSelector, lenient, year);
        if (datesInMonth2 != null) {
            return datesInMonth2;
        }
        Date date = MonthsOrDateSelectorParserKt.parseDate($this$parseMonthsOrDatesSelector, lenient, year);
        if (date != null) {
            if (ParseUtilsKt.nextIsAndAdvance$default($this$parseMonthsOrDatesSelector, '+', lenient, true, false, 8, null)) {
                return new StartingAtDate(date);
            }
            if (ParseUtilsKt.nextIsRangeAndAdvance($this$parseMonthsOrDatesSelector, lenient)) {
                ParseUtilsKt.skipWhitespaces($this$parseMonthsOrDatesSelector, lenient);
                String endYearStr = ParseUtilsKt.nextNumberAndAdvance($this$parseMonthsOrDatesSelector, 4);
                if (endYearStr != null) {
                    if (endYearStr.length() != 4) {
                        $this$parseMonthsOrDatesSelector.retreatBy(endYearStr.length());
                    } else {
                        ParseUtilsKt.skipWhitespaces($this$parseMonthsOrDatesSelector, lenient);
                    }
                }
                String string2 = endYearStr;
                Integer endYear = string2 != null ? Integer.valueOf(Integer.parseInt(string2)) : null;
                Date date2 = MonthsOrDateSelectorParserKt.parseDate($this$parseMonthsOrDatesSelector, lenient, endYear);
                if (date2 == null) {
                    ParseUtilsKt.fail($this$parseMonthsOrDatesSelector, "Expected end date");
                    throw new KotlinNothingValueException();
                }
                Date endDate = date2;
                return new DateRange(date, endDate);
            }
            return date;
        }
        Month month = MonthsOrDateSelectorParserKt.parseMonth($this$parseMonthsOrDatesSelector, lenient);
        if (month != null) {
            if (ParseUtilsKt.nextIsRangeAndAdvance($this$parseMonthsOrDatesSelector, lenient)) {
                ParseUtilsKt.skipWhitespaces($this$parseMonthsOrDatesSelector, lenient);
                Month month2 = MonthsOrDateSelectorParserKt.parseMonth($this$parseMonthsOrDatesSelector, lenient);
                if (month2 == null) {
                    ParseUtilsKt.fail($this$parseMonthsOrDatesSelector, "Expected end month");
                    throw new KotlinNothingValueException();
                }
                Month endMonth = month2;
                return new MonthRange(year, month, endMonth);
            }
            return new SingleMonth(year, month);
        }
        $this$parseMonthsOrDatesSelector.setCursor(initial);
        return null;
    }

    @Nullable
    public static final Date parseDate(@NotNull StringWithCursor $this$parseDate, boolean lenient, @Nullable Integer year) {
        Intrinsics.checkNotNullParameter((Object)$this$parseDate, (String)"<this>");
        int initial = $this$parseDate.getCursor();
        Month month = MonthsOrDateSelectorParserKt.parseMonth($this$parseDate, lenient);
        if (month != null) {
            ParseUtilsKt.skipWhitespaces($this$parseDate, lenient);
            SpecificWeekdayDate specificWeekdayDate = MonthsOrDateSelectorParserKt.parseSpecificWeekdayDate($this$parseDate, lenient, year, month);
            if (specificWeekdayDate != null) {
                return specificWeekdayDate;
            }
            CalendarDate calendarDate = MonthsOrDateSelectorParserKt.parseCalendarDate($this$parseDate, lenient, year, month);
            if (calendarDate != null) {
                return calendarDate;
            }
            $this$parseDate.setCursor(initial);
            return null;
        }
        AnnualEvent event = MonthsOrDateSelectorParserKt.parseAnnualEvent($this$parseDate, lenient);
        if (event != null) {
            WeekdayOffset weekdayOffset = MonthsOrDateSelectorParserKt.parseWeekdayOffset($this$parseDate, lenient);
            Integer n = WeekdaysSelectorParserKt.parseDayOffset($this$parseDate, lenient);
            int dayOffset = n != null ? n : 0;
            return new VariableDate(year, event, weekdayOffset, dayOffset);
        }
        $this$parseDate.setCursor(initial);
        return null;
    }

    private static final CalendarDate parseCalendarDate(StringWithCursor $this$parseCalendarDate, boolean lenient, Integer year, Month month) {
        if (MonthsOrDateSelectorParserKt.nextIsClockTime($this$parseCalendarDate, lenient) || StringWithCursor.nextIs$default($this$parseCalendarDate, "24/7", false, 2, null)) {
            return null;
        }
        String string = ParseUtilsKt.nextNumberAndAdvance($this$parseCalendarDate, 2);
        if (string == null) {
            return null;
        }
        String day = string;
        if (!lenient && day.length() != 2) {
            ParseUtilsKt.fail($this$parseCalendarDate, "Expected month day to consist of two digits");
            throw new KotlinNothingValueException();
        }
        WeekdayOffset weekdayOffset = MonthsOrDateSelectorParserKt.parseWeekdayOffset($this$parseCalendarDate, lenient);
        Integer n = WeekdaysSelectorParserKt.parseDayOffset($this$parseCalendarDate, lenient);
        int dayOffset = n != null ? n : 0;
        return new CalendarDate(year, month, Integer.parseInt(day), weekdayOffset, dayOffset);
    }

    private static final boolean nextIsClockTime(StringWithCursor $this$nextIsClockTime, boolean lenient) {
        int initial = $this$nextIsClockTime.getCursor();
        Pair<Integer, Integer> pair = TimesSelectorParserKt.parseHourMinutes($this$nextIsClockTime, lenient, false);
        if (pair == null) {
            return false;
        }
        Integer minutes = (Integer)pair.component2();
        $this$nextIsClockTime.setCursor(initial);
        return minutes != null;
    }

    private static final SpecificWeekdayDate parseSpecificWeekdayDate(StringWithCursor $this$parseSpecificWeekdayDate, boolean lenient, Integer year, Month month) {
        int initial = $this$parseSpecificWeekdayDate.getCursor();
        Weekday weekday = WeekdaysSelectorParserKt.parseWeekday($this$parseSpecificWeekdayDate, lenient);
        if (weekday == null) {
            return null;
        }
        Weekday weekday2 = weekday;
        ParseUtilsKt.skipWhitespaces($this$parseSpecificWeekdayDate, lenient);
        if (!StringWithCursor.nextIsAndAdvance$default($this$parseSpecificWeekdayDate, '[', false, 2, null)) {
            $this$parseSpecificWeekdayDate.setCursor(initial);
            return null;
        }
        ParseUtilsKt.skipWhitespaces($this$parseSpecificWeekdayDate, lenient);
        boolean minus = StringWithCursor.nextIsAndAdvance$default($this$parseSpecificWeekdayDate, '-', false, 2, null);
        ParseUtilsKt.skipWhitespaces($this$parseSpecificWeekdayDate, lenient);
        String string = ParseUtilsKt.nextNumberAndAdvance($this$parseSpecificWeekdayDate, 1);
        if (string == null) {
            ParseUtilsKt.fail($this$parseSpecificWeekdayDate, "Expected an nth");
            throw new KotlinNothingValueException();
        }
        int nth = Integer.parseInt(string);
        ParseUtilsKt.skipWhitespaces($this$parseSpecificWeekdayDate, lenient);
        if (!StringWithCursor.nextIsAndAdvance$default($this$parseSpecificWeekdayDate, ']', false, 2, null)) {
            $this$parseSpecificWeekdayDate.setCursor(initial);
            return null;
        }
        if (MonthsOrDateSelectorParserKt.nextIsWeekdayOrHolidaySelector($this$parseSpecificWeekdayDate, lenient)) {
            $this$parseSpecificWeekdayDate.setCursor(initial);
            return null;
        }
        Nth nthPointSelector = minus ? (NthPointSelector)new LastNth(nth) : Nth.box-impl(Nth.constructor-impl(nth));
        Integer n = WeekdaysSelectorParserKt.parseDayOffset($this$parseSpecificWeekdayDate, lenient);
        int dayOffset = n != null ? n : 0;
        return new SpecificWeekdayDate(year, month, weekday2, nthPointSelector, dayOffset);
    }

    private static final boolean nextIsWeekdayOrHolidaySelector(StringWithCursor $this$nextIsWeekdayOrHolidaySelector, boolean lenient) {
        int initial = $this$nextIsWeekdayOrHolidaySelector.getCursor();
        if (ParseUtilsKt.nextIsAndAdvance$default($this$nextIsWeekdayOrHolidaySelector, ',', true, true, false, 8, null)) {
            ParseUtilsKt.skipWhitespaces($this$nextIsWeekdayOrHolidaySelector, lenient);
            if (WeekdaysSelectorParserKt.parseWeekdaySelector($this$nextIsWeekdayOrHolidaySelector, lenient) != null || HolidaySelectorParserKt.parseHolidaySelector($this$nextIsWeekdayOrHolidaySelector, lenient) != null) {
                $this$nextIsWeekdayOrHolidaySelector.setCursor(initial);
                return true;
            }
        }
        $this$nextIsWeekdayOrHolidaySelector.setCursor(initial);
        return false;
    }

    private static final WeekdayOffset parseWeekdayOffset(StringWithCursor $this$parseWeekdayOffset, boolean lenient) {
        boolean bl;
        int initial = $this$parseWeekdayOffset.getCursor();
        if (ParseUtilsKt.nextIsAndAdvance$default($this$parseWeekdayOffset, '+', lenient, true, false, 8, null)) {
            bl = true;
        } else if (ParseUtilsKt.nextIsAndAdvance$default($this$parseWeekdayOffset, '-', lenient, true, false, 8, null)) {
            bl = false;
        } else {
            return null;
        }
        boolean isPositive = bl;
        Weekday weekday = WeekdaysSelectorParserKt.parseWeekday($this$parseWeekdayOffset, lenient);
        if (weekday == null) {
            $this$parseWeekdayOffset.setCursor(initial);
            return null;
        }
        return isPositive ? (WeekdayOffset)new NextWeekday(weekday) : (WeekdayOffset)new PreviousWeekday(weekday);
    }

    @Nullable
    public static final DatesInMonth parseDatesInMonth(@NotNull StringWithCursor $this$parseDatesInMonth, boolean lenient, @Nullable Integer year) {
        Intrinsics.checkNotNullParameter((Object)$this$parseDatesInMonth, (String)"<this>");
        int initial = $this$parseDatesInMonth.getCursor();
        Month month = MonthsOrDateSelectorParserKt.parseMonth($this$parseDatesInMonth, lenient);
        if (month == null) {
            return null;
        }
        Month month2 = month;
        ParseUtilsKt.skipWhitespaces($this$parseDatesInMonth, lenient);
        List monthDays = ParseUtilsKt.parseCommaSeparated($this$parseDatesInMonth, lenient, arg_0 -> MonthsOrDateSelectorParserKt.parseDatesInMonth$lambda$0(lenient, arg_0));
        if (monthDays == null || CollectionsKt.singleOrNull(monthDays) instanceof MonthDay) {
            $this$parseDatesInMonth.setCursor(initial);
            return null;
        }
        if (monthDays.size() > 1 && !lenient) {
            ParseUtilsKt.fail($this$parseDatesInMonth, "List of month days not allowed in date(s) selector");
            throw new KotlinNothingValueException();
        }
        return new DatesInMonth(year, month2, monthDays);
    }

    private static final MonthDaySelector parseMonthDaySelector(StringWithCursor $this$parseMonthDaySelector, boolean lenient) {
        int initial = $this$parseMonthDaySelector.getCursor();
        String string = ParseUtilsKt.nextNumberAndAdvance($this$parseMonthDaySelector, 2);
        if (string == null) {
            return null;
        }
        String day = string;
        if (!lenient && day.length() != 2) {
            ParseUtilsKt.fail($this$parseMonthDaySelector, "Expected month day to consist of two digits");
            throw new KotlinNothingValueException();
        }
        if (ParseUtilsKt.nextIsRangeAndAdvance($this$parseMonthDaySelector, lenient)) {
            ParseUtilsKt.skipWhitespaces($this$parseMonthDaySelector, lenient);
            String endDay = ParseUtilsKt.nextNumberAndAdvance($this$parseMonthDaySelector, 2);
            if (endDay == null) {
                $this$parseMonthDaySelector.setCursor(initial);
                return null;
            }
            if (!lenient && endDay.length() != 2) {
                ParseUtilsKt.fail($this$parseMonthDaySelector, "Expected month day to consist of two digits");
                throw new KotlinNothingValueException();
            }
            return new MonthDayRange(Integer.parseInt(day), Integer.parseInt(endDay));
        }
        return new MonthDay(Integer.parseInt(day));
    }

    @Nullable
    public static final AnnualEvent parseAnnualEvent(@NotNull StringWithCursor $this$parseAnnualEvent, boolean lenient) {
        Object v0;
        block1: {
            Intrinsics.checkNotNullParameter((Object)$this$parseAnnualEvent, (String)"<this>");
            Iterable iterable = (Iterable)AnnualEvent.getEntries();
            for (Object t : iterable) {
                AnnualEvent it = (AnnualEvent)((Object)t);
                boolean bl = false;
                if (!$this$parseAnnualEvent.nextIsAndAdvance(it.getOsm$osm_opening_hours(), lenient)) continue;
                v0 = t;
                break block1;
            }
            v0 = null;
        }
        return v0;
    }

    @Nullable
    public static final Month parseMonth(@NotNull StringWithCursor $this$parseMonth, boolean lenient) {
        Intrinsics.checkNotNullParameter((Object)$this$parseMonth, (String)"<this>");
        return lenient ? MonthsOrDateSelectorParserKt.parseMonthLenient($this$parseMonth) : MonthsOrDateSelectorParserKt.parseMonthStrict($this$parseMonth);
    }

    private static final Month parseMonthStrict(StringWithCursor $this$parseMonthStrict) {
        String string = ParseUtilsKt.getNextKeyword($this$parseMonthStrict, monthsMaxLength);
        if (string == null) {
            return null;
        }
        String word = string;
        Month month = monthsMap.get(word);
        if (month == null) {
            return null;
        }
        Month month2 = month;
        $this$parseMonthStrict.advanceBy(word.length());
        return month2;
    }

    private static final Month parseMonthLenient(StringWithCursor $this$parseMonthLenient) {
        String string;
        block5: {
            block4: {
                string = ParseUtilsKt.getNextKeyword($this$parseMonthLenient, lenientMonthsMaxLength);
                if (string == null) break block4;
                String string2 = string.toLowerCase(Locale.ROOT);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toLowerCase(...)");
                string = string2;
                if (string2 != null) break block5;
            }
            return null;
        }
        String word = string;
        Month month = lenientMonthsMap.get(word);
        if (month == null) {
            return null;
        }
        Month event = month;
        $this$parseMonthLenient.advanceBy(word.length());
        StringWithCursor.nextIsAndAdvance$default($this$parseMonthLenient, '.', false, 2, null);
        return event;
    }

    private static final MonthDaySelector parseDatesInMonth$lambda$0(boolean $lenient, StringWithCursor $this$parseCommaSeparated) {
        Intrinsics.checkNotNullParameter((Object)$this$parseCommaSeparated, (String)"$this$parseCommaSeparated");
        return MonthsOrDateSelectorParserKt.parseMonthDaySelector($this$parseCommaSeparated, $lenient);
    }

    /*
     * WARNING - void declaration
     */
    static {
        void $this$mapKeysTo$iv$iv;
        Pair[] $this$associateByTo$iv$iv;
        Month it;
        Map map;
        void $this$associateByTo$iv$iv2;
        Pair[] $this$associateBy$iv = (Pair[])Month.getEntries();
        boolean $i$f$associateBy232 = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
        Pair[] pairArray = $this$associateBy$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateByTo = false;
        for (Object t : $this$associateByTo$iv$iv2) {
            Month month = (Month)((Object)t);
            map = destination$iv$iv;
            boolean bl = false;
            map.put(it.getOsm$osm_opening_hours(), t);
        }
        monthsMap = destination$iv$iv;
        Iterator $i$f$associateBy232 = ((Iterable)monthsMap.keySet()).iterator();
        if (!$i$f$associateBy232.hasNext()) {
            throw new NoSuchElementException();
        }
        String it232 = (String)$i$f$associateBy232.next();
        boolean bl = false;
        int it232 = it232.length();
        while ($i$f$associateBy232.hasNext()) {
            String it332 = (String)$i$f$associateBy232.next();
            boolean bl2 = false;
            int it332 = it332.length();
            if (it232 >= it332) continue;
            it232 = it332;
        }
        monthsMaxLength = it232;
        $this$associateBy$iv = (Iterable)Month.getEntries();
        boolean $i$f$associateBy = false;
        capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
        Pair[] it332 = $this$associateBy$iv;
        destination$iv$iv = new LinkedHashMap(capacity$iv);
        $i$f$associateByTo = false;
        for (Object t : $this$associateByTo$iv$iv) {
            it = (Month)((Object)t);
            map = destination$iv$iv;
            boolean bl2 = false;
            map.put(it.getOsm$osm_opening_hours(), t);
        }
        $this$associateBy$iv = (Iterable)Month.getEntries();
        map = destination$iv$iv;
        $i$f$associateBy = false;
        int capacity$iv32 = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
        $this$associateByTo$iv$iv = $this$associateBy$iv;
        destination$iv$iv = new LinkedHashMap(capacity$iv32);
        $i$f$associateByTo = false;
        for (Object t : $this$associateByTo$iv$iv) {
            it = (Month)((Object)t);
            Map map2 = destination$iv$iv;
            boolean bl3 = false;
            map2.put(it.name(), t);
        }
        $this$associateBy$iv = new Pair[]{TuplesKt.to((Object)"Jan", (Object)((Object)Month.January)), TuplesKt.to((Object)"Feb", (Object)((Object)Month.February)), TuplesKt.to((Object)"M\u00e4rz", (Object)((Object)Month.March)), TuplesKt.to((Object)"Apr", (Object)((Object)Month.April)), TuplesKt.to((Object)"Mai", (Object)((Object)Month.May)), TuplesKt.to((Object)"Jun", (Object)((Object)Month.June)), TuplesKt.to((Object)"Jul", (Object)((Object)Month.July)), TuplesKt.to((Object)"Aug", (Object)((Object)Month.August)), TuplesKt.to((Object)"Sept", (Object)((Object)Month.September)), TuplesKt.to((Object)"Okt", (Object)((Object)Month.October)), TuplesKt.to((Object)"Nov", (Object)((Object)Month.November)), TuplesKt.to((Object)"Dez", (Object)((Object)Month.December))};
        Map $this$mapKeys$iv = MapsKt.plus((Map)MapsKt.plus((Map)map, (Map)destination$iv$iv), (Map)MapsKt.mapOf((Pair[])$this$associateBy$iv));
        boolean $i$f$mapKeys = false;
        Map capacity$iv32 = $this$mapKeys$iv;
        Map destination$iv$iv2 = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapKeys$iv.size()));
        boolean $i$f$mapKeysTo = false;
        Iterable $this$associateByTo$iv$iv$iv = $this$mapKeysTo$iv$iv.entrySet();
        boolean $i$f$associateByTo2 = false;
        for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
            String string;
            void it$iv$iv;
            void it3;
            Map.Entry bl3 = (Map.Entry)element$iv$iv$iv;
            map = destination$iv$iv2;
            boolean bl4 = false;
            Intrinsics.checkNotNullExpressionValue((Object)((String)it3.getKey()).toLowerCase(Locale.ROOT), (String)"toLowerCase(...)");
            Map.Entry entry = (Map.Entry)element$iv$iv$iv;
            Map map3 = map;
            boolean bl5 = false;
            Object v = it$iv$iv.getValue();
            map3.put(string, v);
        }
        lenientMonthsMap = destination$iv$iv2;
        Iterator iterator = ((Iterable)lenientMonthsMap.keySet()).iterator();
        if (!iterator.hasNext()) {
            throw new NoSuchElementException();
        }
        String it4 = (String)iterator.next();
        boolean bl6 = false;
        int n = it4.length();
        while (iterator.hasNext()) {
            String it5 = (String)iterator.next();
            boolean bl3 = false;
            int n2 = it5.length();
            if (n >= n2) continue;
            n = n2;
        }
        lenientMonthsMaxLength = n;
    }
}

