/*
 * Decompiled with CFR 0.152.
 */
package de.westnordost.osm_opening_hours.parser;

import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.CharsKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\f\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0002\n\u0002\b\t\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0018\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u0007H\u0086\u0002\u00a2\u0006\u0002\u0010\u000fJ\u0018\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00032\b\b\u0002\u0010\u0013\u001a\u00020\u0011J\u0018\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0014\u001a\u00020\r2\b\b\u0002\u0010\u0013\u001a\u00020\u0011J'\u0010\u0010\u001a\u0004\u0018\u00010\r2\u0012\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u00110\u0016H\u0086\b\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0017J\u0010\u0010\u0018\u001a\u00020\u00112\b\b\u0002\u0010\u0019\u001a\u00020\u0007J\"\u0010\u001a\u001a\u00020\u00072\u0006\u0010\u0012\u001a\u00020\u00032\b\b\u0002\u0010\u0019\u001a\u00020\u00072\b\b\u0002\u0010\u0013\u001a\u00020\u0011J\"\u0010\u001a\u001a\u00020\u00072\u0006\u0010\u0014\u001a\u00020\r2\b\b\u0002\u0010\u0019\u001a\u00020\u00072\b\b\u0002\u0010\u0013\u001a\u00020\u0011J\u0006\u0010\u001b\u001a\u00020\rJ\u000e\u0010\u001c\u001a\u00020\u00032\u0006\u0010\u001d\u001a\u00020\u0007J\u000e\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u001d\u001a\u00020\u0007J\u0018\u0010 \u001a\u00020\u00112\u0006\u0010\u0014\u001a\u00020\r2\b\b\u0002\u0010\u0013\u001a\u00020\u0011J\u0018\u0010 \u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00032\b\b\u0002\u0010\u0013\u001a\u00020\u0011J \u0010 \u001a\u00020\u00112\u0012\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u00110\u0016H\u0086\b\u00f8\u0001\u0000J \u0010!\u001a\u00020\u00072\u0012\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u00110\u0016H\u0086\b\u00f8\u0001\u0000J \u0010\"\u001a\u00020\u00072\u0012\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u00110\u0016H\u0086\b\u00f8\u0001\u0000J3\u0010#\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010$\u001a\u0004\u0018\u00010\u00072\u0012\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u00110\u0016H\u0086\b\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010%J\u0010\u0010&\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\u0007H\u0002J\b\u0010'\u001a\u00020\u0003H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000b\u0082\u0002\u0007\n\u0005\b\u009920\u0001\u00a8\u0006("}, d2={"Lde/westnordost/osm_opening_hours/parser/StringWithCursor;", "", "string", "", "<init>", "(Ljava/lang/String;)V", "cursor", "", "getCursor", "()I", "setCursor", "(I)V", "get", "", "index", "(I)Ljava/lang/Character;", "nextIsAndAdvance", "", "str", "ignoreCase", "c", "block", "Lkotlin/Function1;", "(Lkotlin/jvm/functions/Function1;)Ljava/lang/Character;", "isAtEnd", "offs", "findNext", "advance", "advanceBy", "x", "retreatBy", "", "nextIs", "advanceWhile", "retreatWhile", "getNextWord", "maxLength", "(Ljava/lang/Integer;Lkotlin/jvm/functions/Function1;)Ljava/lang/String;", "toDelta", "toString", "osm-opening-hours"})
@SourceDebugExtension(value={"SMAP\nStringWithCursor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 StringWithCursor.kt\nde/westnordost/osm_opening_hours/parser/StringWithCursor\n*L\n1#1,142:1\n99#1:143\n*S KotlinDebug\n*F\n+ 1 StringWithCursor.kt\nde/westnordost/osm_opening_hours/parser/StringWithCursor\n*L\n30#1:143\n*E\n"})
public final class StringWithCursor {
    @NotNull
    private final String string;
    private int cursor;

    public StringWithCursor(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"string");
        this.string = string;
    }

    public final int getCursor() {
        return this.cursor;
    }

    public final void setCursor(int n) {
        this.cursor = n;
    }

    @Nullable
    public final Character get(int index) {
        return index < this.string.length() ? Character.valueOf(this.string.charAt(index)) : null;
    }

    public final boolean nextIsAndAdvance(@NotNull String str, boolean ignoreCase) {
        Intrinsics.checkNotNullParameter((Object)str, (String)"str");
        if (!this.nextIs(str, ignoreCase)) {
            return false;
        }
        this.advanceBy(str.length());
        return true;
    }

    public static /* synthetic */ boolean nextIsAndAdvance$default(StringWithCursor stringWithCursor, String string, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        return stringWithCursor.nextIsAndAdvance(string, bl);
    }

    public final boolean nextIsAndAdvance(char c, boolean ignoreCase) {
        if (!this.nextIs(c, ignoreCase)) {
            return false;
        }
        this.advance();
        return true;
    }

    public static /* synthetic */ boolean nextIsAndAdvance$default(StringWithCursor stringWithCursor, char c, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        return stringWithCursor.nextIsAndAdvance(c, bl);
    }

    @Nullable
    public final Character nextIsAndAdvance(@NotNull Function1<? super Character, Boolean> block) {
        Intrinsics.checkNotNullParameter(block, (String)"block");
        boolean $i$f$nextIsAndAdvance = false;
        StringWithCursor this_$iv = this;
        boolean $i$f$nextIs = false;
        Character c = this_$iv.get(this_$iv.getCursor());
        if (!(c != null ? ((Boolean)block.invoke((Object)c)).booleanValue() : false)) {
            return null;
        }
        return Character.valueOf(this.advance());
    }

    public final boolean isAtEnd(int offs) {
        return this.cursor + offs >= this.string.length();
    }

    public static /* synthetic */ boolean isAtEnd$default(StringWithCursor stringWithCursor, int n, int n2, Object object) {
        if ((n2 & 1) != 0) {
            n = 0;
        }
        return stringWithCursor.isAtEnd(n);
    }

    public final int findNext(@NotNull String str, int offs, boolean ignoreCase) {
        Intrinsics.checkNotNullParameter((Object)str, (String)"str");
        return this.toDelta(StringsKt.indexOf((CharSequence)this.string, (String)str, (int)(this.cursor + offs), (boolean)ignoreCase));
    }

    public static /* synthetic */ int findNext$default(StringWithCursor stringWithCursor, String string, int n, boolean bl, int n2, Object object) {
        if ((n2 & 2) != 0) {
            n = 0;
        }
        if ((n2 & 4) != 0) {
            bl = false;
        }
        return stringWithCursor.findNext(string, n, bl);
    }

    public final int findNext(char c, int offs, boolean ignoreCase) {
        return this.toDelta(StringsKt.indexOf((CharSequence)this.string, (char)c, (int)(this.cursor + offs), (boolean)ignoreCase));
    }

    public static /* synthetic */ int findNext$default(StringWithCursor stringWithCursor, char c, int n, boolean bl, int n2, Object object) {
        if ((n2 & 2) != 0) {
            n = 0;
        }
        if ((n2 & 4) != 0) {
            bl = false;
        }
        return stringWithCursor.findNext(c, n, bl);
    }

    public final char advance() {
        if (StringWithCursor.isAtEnd$default(this, 0, 1, null)) {
            throw new IndexOutOfBoundsException();
        }
        char result = this.string.charAt(this.cursor);
        this.cursor = Math.min(this.string.length(), this.cursor + 1);
        return result;
    }

    @NotNull
    public final String advanceBy(int x) {
        if (x < 0) {
            throw new IndexOutOfBoundsException();
        }
        int end = this.cursor + x;
        String result = null;
        if (this.string.length() < end) {
            String string = this.string.substring(this.cursor);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            result = string;
            this.cursor = this.string.length();
        } else {
            String string = this.string.substring(this.cursor, end);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            result = string;
            this.cursor = end;
        }
        return result;
    }

    public final void retreatBy(int x) {
        if (x < 0) {
            throw new IndexOutOfBoundsException();
        }
        this.cursor = Math.max(0, this.cursor - x);
    }

    public final boolean nextIs(char c, boolean ignoreCase) {
        Character c2 = this.get(this.cursor);
        return c2 != null ? CharsKt.equals((char)c2.charValue(), (char)c, (boolean)ignoreCase) : false;
    }

    public static /* synthetic */ boolean nextIs$default(StringWithCursor stringWithCursor, char c, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        return stringWithCursor.nextIs(c, bl);
    }

    public final boolean nextIs(@NotNull String str, boolean ignoreCase) {
        Intrinsics.checkNotNullParameter((Object)str, (String)"str");
        return StringsKt.startsWith((String)this.string, (String)str, (int)this.cursor, (boolean)ignoreCase);
    }

    public static /* synthetic */ boolean nextIs$default(StringWithCursor stringWithCursor, String string, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        return stringWithCursor.nextIs(string, bl);
    }

    public final boolean nextIs(@NotNull Function1<? super Character, Boolean> block) {
        Intrinsics.checkNotNullParameter(block, (String)"block");
        boolean $i$f$nextIs = false;
        Character c = this.get(this.getCursor());
        return c != null ? ((Boolean)block.invoke((Object)c)).booleanValue() : false;
    }

    public final int advanceWhile(@NotNull Function1<? super Character, Boolean> block) {
        Intrinsics.checkNotNullParameter(block, (String)"block");
        boolean $i$f$advanceWhile = false;
        int i = 0;
        while (this.getCursor() < this.string.length() && ((Boolean)block.invoke((Object)Character.valueOf(this.string.charAt(this.getCursor())))).booleanValue()) {
            this.setCursor(this.getCursor() + 1);
            this.getCursor();
            ++i;
        }
        return i;
    }

    public final int retreatWhile(@NotNull Function1<? super Character, Boolean> block) {
        Intrinsics.checkNotNullParameter(block, (String)"block");
        boolean $i$f$retreatWhile = false;
        int i = 0;
        while (this.getCursor() > 0 && ((Boolean)block.invoke((Object)Character.valueOf(this.string.charAt(this.getCursor() - 1)))).booleanValue()) {
            this.setCursor(this.getCursor() + -1);
            this.getCursor();
            ++i;
        }
        return i;
    }

    @Nullable
    public final String getNextWord(@Nullable Integer maxLength, @NotNull Function1<? super Character, Boolean> block) {
        String string;
        Intrinsics.checkNotNullParameter(block, (String)"block");
        boolean $i$f$getNextWord = false;
        int i = 0;
        while (!this.isAtEnd(i) && ((Boolean)block.invoke((Object)Character.valueOf(this.string.charAt(this.getCursor() + i)))).booleanValue()) {
            if (maxLength == null || ++i <= maxLength) continue;
            return null;
        }
        if (i == 0) {
            string = null;
        } else {
            String string2 = this.string.substring(this.getCursor(), this.getCursor() + i);
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
        }
        return string;
    }

    public static /* synthetic */ String getNextWord$default(StringWithCursor $this, Integer maxLength, Function1 block, int n, Object object) {
        String string;
        if ((n & 1) != 0) {
            maxLength = null;
        }
        Intrinsics.checkNotNullParameter((Object)block, (String)"block");
        boolean $i$f$getNextWord = false;
        int i = 0;
        while (!$this.isAtEnd(i) && ((Boolean)block.invoke((Object)Character.valueOf($this.string.charAt($this.getCursor() + i)))).booleanValue()) {
            if (maxLength == null || ++i <= maxLength) continue;
            return null;
        }
        if (i == 0) {
            string = null;
        } else {
            String string2 = $this.string.substring($this.getCursor(), $this.getCursor() + i);
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
        }
        return string;
    }

    private final int toDelta(int index) {
        return index == -1 ? this.string.length() - this.cursor : index - this.cursor;
    }

    @NotNull
    public String toString() {
        String string = this.string.substring(0, this.cursor);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
        String string2 = this.string.substring(this.cursor);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
        return string + "\u25ba" + string2;
    }
}

