/*
 * Decompiled with CFR 0.152.
 */
package de.westnordost.osm_opening_hours.parser;

import de.westnordost.osm_opening_hours.model.ClockTime;
import de.westnordost.osm_opening_hours.model.EventTime;
import de.westnordost.osm_opening_hours.model.ExtendedClockTime;
import de.westnordost.osm_opening_hours.model.ExtendedTime;
import de.westnordost.osm_opening_hours.model.Interval;
import de.westnordost.osm_opening_hours.model.IntervalMinutes;
import de.westnordost.osm_opening_hours.model.OffsetOp;
import de.westnordost.osm_opening_hours.model.StartingAtTime;
import de.westnordost.osm_opening_hours.model.Time;
import de.westnordost.osm_opening_hours.model.TimeIntervals;
import de.westnordost.osm_opening_hours.model.TimeOffset;
import de.westnordost.osm_opening_hours.model.TimeSpan;
import de.westnordost.osm_opening_hours.model.TimesSelector;
import de.westnordost.osm_opening_hours.model.VariableTime;
import de.westnordost.osm_opening_hours.parser.Clock12;
import de.westnordost.osm_opening_hours.parser.ParseUtilsKt;
import de.westnordost.osm_opening_hours.parser.StringWithCursor;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.NoSuchElementException;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.CharsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u0000b\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\u001a\u0016\u0010\b\u001a\u0004\u0018\u00010\t*\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0000\u001a\u000e\u0010\r\u001a\u0004\u0018\u00010\u000e*\u00020\nH\u0000\u001a\u000e\u0010\u000f\u001a\u0004\u0018\u00010\u0010*\u00020\nH\u0000\u001a\u0016\u0010\u0011\u001a\u0004\u0018\u00010\u0012*\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0000\u001a\u0016\u0010\u0013\u001a\u0004\u0018\u00010\u0014*\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0000\u001a\u0016\u0010\u0015\u001a\u0004\u0018\u00010\u0016*\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0000\u001a\u0016\u0010\u0017\u001a\u0004\u0018\u00010\u0018*\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0000\u001a\u0016\u0010\u0019\u001a\u0004\u0018\u00010\u001a*\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0000\u001a.\u0010\u001b\u001a\u0012\u0012\u0004\u0012\u00020\u0005\u0012\u0006\u0012\u0004\u0018\u00010\u0005\u0018\u00010\u001c*\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\b\b\u0002\u0010\u001d\u001a\u00020\fH\u0000\u001a$\u0010\u001e\u001a\u0012\u0012\u0004\u0012\u00020\u0005\u0012\u0006\u0012\u0004\u0018\u00010\u0005\u0018\u00010\u001c*\u00020\n2\u0006\u0010\u001d\u001a\u00020\fH\u0002\u001a$\u0010\u001f\u001a\u0012\u0012\u0004\u0012\u00020\u0005\u0012\u0006\u0012\u0004\u0018\u00010\u0005\u0018\u00010\u001c*\u00020\n2\u0006\u0010\u001d\u001a\u00020\fH\u0002\u001a\u000e\u0010 \u001a\u0004\u0018\u00010!*\u00020\nH\u0000\u001a\u0016\u0010\"\u001a\u0004\u0018\u00010\u0003*\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0000\u001a\u000e\u0010#\u001a\u0004\u0018\u00010\u0003*\u00020\nH\u0000\u001a\u000e\u0010$\u001a\u0004\u0018\u00010\u0003*\u00020\nH\u0002\"\u001a\u0010\u0000\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u001a\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0007\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"eventTimeMap", "", "", "Lde/westnordost/osm_opening_hours/model/EventTime;", "eventTimeMaxLength", "", "lenientEventTimeMap", "lenientEventTimeMaxLength", "parseTimesSelector", "Lde/westnordost/osm_opening_hours/model/TimesSelector;", "Lde/westnordost/osm_opening_hours/parser/StringWithCursor;", "lenient", "", "parseInterval", "Lde/westnordost/osm_opening_hours/model/Interval;", "parseIntervalMinutes", "Lde/westnordost/osm_opening_hours/model/IntervalMinutes;", "parseTime", "Lde/westnordost/osm_opening_hours/model/Time;", "parseExtendedTime", "Lde/westnordost/osm_opening_hours/model/ExtendedTime;", "parseVariableTime", "Lde/westnordost/osm_opening_hours/model/VariableTime;", "parseClockTime", "Lde/westnordost/osm_opening_hours/model/ClockTime;", "parseExtendedClockTime", "Lde/westnordost/osm_opening_hours/model/ExtendedClockTime;", "parseHourMinutes", "Lkotlin/Pair;", "allowWhitespacesAroundMinuteSeparator", "parseHourMinutesStrict", "parseHourMinutesLenient", "parseAmPm", "Lde/westnordost/osm_opening_hours/parser/Clock12;", "parseEventTime", "parseEventTimeLenient", "parseEventTimeStrict", "osm-opening-hours"})
@SourceDebugExtension(value={"SMAP\nTimesSelectorParser.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TimesSelectorParser.kt\nde/westnordost/osm_opening_hours/parser/TimesSelectorParserKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 StringWithCursor.kt\nde/westnordost/osm_opening_hours/parser/StringWithCursor\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 5 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,206:1\n1#2:207\n30#3:208\n99#3:209\n31#3:210\n1202#4,2:211\n1230#4,4:213\n1202#4,2:217\n1230#4,4:219\n1246#4,4:225\n477#5:223\n423#5:224\n*S KotlinDebug\n*F\n+ 1 TimesSelectorParser.kt\nde/westnordost/osm_opening_hours/parser/TimesSelectorParserKt\n*L\n135#1:208\n135#1:209\n135#1:210\n7#1:211,2\n7#1:213,4\n12#1:217,2\n12#1:219,4\n18#1:225,4\n18#1:223\n18#1:224\n*E\n"})
public final class TimesSelectorParserKt {
    @NotNull
    private static final Map<String, EventTime> eventTimeMap;
    private static final int eventTimeMaxLength;
    @NotNull
    private static final Map<String, EventTime> lenientEventTimeMap;
    private static final int lenientEventTimeMaxLength;

    @Nullable
    public static final TimesSelector parseTimesSelector(@NotNull StringWithCursor $this$parseTimesSelector, boolean lenient) {
        Interval step;
        Interval interval;
        ExtendedTime endTime;
        ExtendedTime extendedTime;
        Intrinsics.checkNotNullParameter((Object)$this$parseTimesSelector, (String)"<this>");
        Time time = TimesSelectorParserKt.parseTime($this$parseTimesSelector, lenient);
        if (time == null) {
            return null;
        }
        Time startTime = time;
        if (ParseUtilsKt.nextIsRangeAndAdvance($this$parseTimesSelector, lenient)) {
            ParseUtilsKt.skipWhitespaces($this$parseTimesSelector, lenient);
            extendedTime = TimesSelectorParserKt.parseExtendedTime($this$parseTimesSelector, lenient);
            if (extendedTime == null) {
                ParseUtilsKt.fail($this$parseTimesSelector, "Expected an end time");
                throw new KotlinNothingValueException();
            }
        } else {
            extendedTime = null;
        }
        if ((endTime = extendedTime) != null && ParseUtilsKt.nextIsAndAdvance$default($this$parseTimesSelector, '/', lenient, true, false, 8, null)) {
            ParseUtilsKt.skipWhitespaces($this$parseTimesSelector, lenient);
            interval = TimesSelectorParserKt.parseInterval($this$parseTimesSelector);
            if (interval == null) {
                ParseUtilsKt.fail($this$parseTimesSelector, "Expected an interval");
                throw new KotlinNothingValueException();
            }
        } else {
            interval = null;
        }
        boolean openEnd = (step = interval) == null && ParseUtilsKt.nextIsAndAdvance$default($this$parseTimesSelector, '+', lenient, true, false, 8, null);
        return step != null && endTime != null ? (TimesSelector)new TimeIntervals(startTime, endTime, step) : (endTime != null ? (TimesSelector)new TimeSpan(startTime, endTime, openEnd) : (openEnd ? (TimesSelector)new StartingAtTime(startTime) : (TimesSelector)startTime));
    }

    @Nullable
    public static final Interval parseInterval(@NotNull StringWithCursor $this$parseInterval) {
        Intrinsics.checkNotNullParameter((Object)$this$parseInterval, (String)"<this>");
        ClockTime clockTime = TimesSelectorParserKt.parseClockTime($this$parseInterval, false);
        return clockTime != null ? (Interval)clockTime : (Interval)TimesSelectorParserKt.parseIntervalMinutes($this$parseInterval);
    }

    @Nullable
    public static final IntervalMinutes parseIntervalMinutes(@NotNull StringWithCursor $this$parseIntervalMinutes) {
        Intrinsics.checkNotNullParameter((Object)$this$parseIntervalMinutes, (String)"<this>");
        String string = ParseUtilsKt.nextNumberAndAdvance$default($this$parseIntervalMinutes, null, 1, null);
        if (string == null) {
            return null;
        }
        String number = string;
        return IntervalMinutes.box-impl(IntervalMinutes.constructor-impl(Integer.parseInt(number)));
    }

    @Nullable
    public static final Time parseTime(@NotNull StringWithCursor $this$parseTime, boolean lenient) {
        Time time;
        Intrinsics.checkNotNullParameter((Object)$this$parseTime, (String)"<this>");
        VariableTime variableTime = TimesSelectorParserKt.parseVariableTime($this$parseTime, lenient);
        if (variableTime != null) {
            time = variableTime;
        } else {
            VariableTime variableTime2;
            EventTime eventTime = TimesSelectorParserKt.parseEventTime($this$parseTime, lenient);
            if (eventTime != null) {
                EventTime it = eventTime;
                boolean bl = false;
                variableTime2 = new VariableTime(it, null, 2, null);
            } else {
                variableTime2 = null;
            }
            time = variableTime2 != null ? (Time)variableTime2 : (Time)TimesSelectorParserKt.parseClockTime($this$parseTime, lenient);
        }
        return time;
    }

    @Nullable
    public static final ExtendedTime parseExtendedTime(@NotNull StringWithCursor $this$parseExtendedTime, boolean lenient) {
        ExtendedTime extendedTime;
        Intrinsics.checkNotNullParameter((Object)$this$parseExtendedTime, (String)"<this>");
        VariableTime variableTime = TimesSelectorParserKt.parseVariableTime($this$parseExtendedTime, lenient);
        if (variableTime != null) {
            extendedTime = variableTime;
        } else {
            VariableTime variableTime2;
            EventTime eventTime = TimesSelectorParserKt.parseEventTime($this$parseExtendedTime, lenient);
            if (eventTime != null) {
                EventTime it = eventTime;
                boolean bl = false;
                variableTime2 = new VariableTime(it, null, 2, null);
            } else {
                variableTime2 = null;
            }
            extendedTime = variableTime2 != null ? (ExtendedTime)variableTime2 : (ExtendedTime)TimesSelectorParserKt.parseExtendedClockTime($this$parseExtendedTime, lenient);
        }
        return extendedTime;
    }

    @Nullable
    public static final VariableTime parseVariableTime(@NotNull StringWithCursor $this$parseVariableTime, boolean lenient) {
        OffsetOp offsetOp;
        Intrinsics.checkNotNullParameter((Object)$this$parseVariableTime, (String)"<this>");
        if (!StringWithCursor.nextIsAndAdvance$default($this$parseVariableTime, '(', false, 2, null)) {
            return null;
        }
        ParseUtilsKt.skipWhitespaces($this$parseVariableTime, lenient);
        EventTime eventTime = TimesSelectorParserKt.parseEventTime($this$parseVariableTime, lenient);
        if (eventTime == null) {
            ParseUtilsKt.fail($this$parseVariableTime, "Expected an event time");
            throw new KotlinNothingValueException();
        }
        EventTime eventTime2 = eventTime;
        ParseUtilsKt.skipWhitespaces($this$parseVariableTime, lenient);
        if (StringWithCursor.nextIsAndAdvance$default($this$parseVariableTime, '+', false, 2, null)) {
            offsetOp = OffsetOp.Plus;
        } else if (StringWithCursor.nextIsAndAdvance$default($this$parseVariableTime, '-', false, 2, null)) {
            offsetOp = OffsetOp.Minus;
        } else {
            ParseUtilsKt.fail($this$parseVariableTime, "Expected '+' or '-'");
            throw new KotlinNothingValueException();
        }
        OffsetOp op = offsetOp;
        ParseUtilsKt.skipWhitespaces($this$parseVariableTime, lenient);
        ClockTime clockTime = TimesSelectorParserKt.parseClockTime($this$parseVariableTime, false);
        if (clockTime == null) {
            ParseUtilsKt.fail($this$parseVariableTime, "Expected an offset time");
            throw new KotlinNothingValueException();
        }
        ClockTime offsetTime = clockTime;
        ParseUtilsKt.skipWhitespaces($this$parseVariableTime, lenient);
        if (!StringWithCursor.nextIsAndAdvance$default($this$parseVariableTime, ')', false, 2, null)) {
            ParseUtilsKt.fail($this$parseVariableTime, "Expected a ')'");
            throw new KotlinNothingValueException();
        }
        return new VariableTime(eventTime2, new TimeOffset(op, offsetTime));
    }

    @Nullable
    public static final ClockTime parseClockTime(@NotNull StringWithCursor $this$parseClockTime, boolean lenient) {
        Integer minutes;
        Intrinsics.checkNotNullParameter((Object)$this$parseClockTime, (String)"<this>");
        Pair pair = TimesSelectorParserKt.parseHourMinutes$default($this$parseClockTime, lenient, false, 2, null);
        if (pair == null) {
            return null;
        }
        Pair pair2 = pair;
        int hour = ((Number)pair2.component1()).intValue();
        Integer n = minutes = (Integer)pair2.component2();
        return new ClockTime(hour, n != null ? n : 0);
    }

    @Nullable
    public static final ExtendedClockTime parseExtendedClockTime(@NotNull StringWithCursor $this$parseExtendedClockTime, boolean lenient) {
        Integer minutes;
        Intrinsics.checkNotNullParameter((Object)$this$parseExtendedClockTime, (String)"<this>");
        Pair pair = TimesSelectorParserKt.parseHourMinutes$default($this$parseExtendedClockTime, lenient, false, 2, null);
        if (pair == null) {
            return null;
        }
        Pair pair2 = pair;
        int hour = ((Number)pair2.component1()).intValue();
        Integer n = minutes = (Integer)pair2.component2();
        return new ExtendedClockTime(hour, n != null ? n : 0);
    }

    @Nullable
    public static final Pair<Integer, Integer> parseHourMinutes(@NotNull StringWithCursor $this$parseHourMinutes, boolean lenient, boolean allowWhitespacesAroundMinuteSeparator) {
        Intrinsics.checkNotNullParameter((Object)$this$parseHourMinutes, (String)"<this>");
        return lenient ? TimesSelectorParserKt.parseHourMinutesLenient($this$parseHourMinutes, allowWhitespacesAroundMinuteSeparator) : TimesSelectorParserKt.parseHourMinutesStrict($this$parseHourMinutes, allowWhitespacesAroundMinuteSeparator);
    }

    public static /* synthetic */ Pair parseHourMinutes$default(StringWithCursor stringWithCursor, boolean bl, boolean bl2, int n, Object object) {
        if ((n & 2) != 0) {
            bl2 = true;
        }
        return TimesSelectorParserKt.parseHourMinutes(stringWithCursor, bl, bl2);
    }

    private static final Pair<Integer, Integer> parseHourMinutesStrict(StringWithCursor $this$parseHourMinutesStrict, boolean allowWhitespacesAroundMinuteSeparator) {
        String minutes;
        int initial = $this$parseHourMinutesStrict.getCursor();
        String string = ParseUtilsKt.nextNumberAndAdvance($this$parseHourMinutesStrict, 2);
        if (string == null) {
            return null;
        }
        String hour = string;
        if (hour.length() != 2) {
            $this$parseHourMinutesStrict.setCursor(initial);
            return null;
        }
        if (allowWhitespacesAroundMinuteSeparator) {
            ParseUtilsKt.skipWhitespaces($this$parseHourMinutesStrict, false);
        }
        if (!StringWithCursor.nextIsAndAdvance$default($this$parseHourMinutesStrict, ':', false, 2, null)) {
            $this$parseHourMinutesStrict.setCursor(initial);
            return null;
        }
        if (allowWhitespacesAroundMinuteSeparator) {
            ParseUtilsKt.skipWhitespaces($this$parseHourMinutesStrict, false);
        }
        if ((minutes = ParseUtilsKt.nextNumberAndAdvance($this$parseHourMinutesStrict, 2)) == null || minutes.length() != 2) {
            $this$parseHourMinutesStrict.setCursor(initial);
            return null;
        }
        return new Pair((Object)Integer.parseInt(hour), (Object)Integer.parseInt(minutes));
    }

    private static final Pair<Integer, Integer> parseHourMinutesLenient(StringWithCursor $this$parseHourMinutesLenient, boolean allowWhitespacesAroundMinuteSeparator) {
        boolean bl;
        int initial = $this$parseHourMinutesLenient.getCursor();
        if (StringWithCursor.nextIs$default($this$parseHourMinutesLenient, "24/7", false, 2, null)) {
            return null;
        }
        String string = ParseUtilsKt.nextNumberAndAdvance($this$parseHourMinutesLenient, 2);
        if (string == null) {
            return null;
        }
        String hourStr = string;
        if (allowWhitespacesAroundMinuteSeparator) {
            ParseUtilsKt.skipWhitespaces($this$parseHourMinutesLenient, true);
        }
        StringWithCursor this_$iv = $this$parseHourMinutesLenient;
        boolean $i$f$nextIsAndAdvance = false;
        StringWithCursor this_$iv$iv = this_$iv;
        boolean $i$f$nextIs = false;
        Character c = this_$iv$iv.get(this_$iv$iv.getCursor());
        if (c != null) {
            char it = c.charValue();
            boolean bl2 = false;
            bl = it == ':' || it == '.' || CharsKt.equals((char)it, (char)'h', (boolean)true);
        } else {
            bl = false;
        }
        Character minuteSeparator = !bl ? null : Character.valueOf(this_$iv.advance());
        String minutesStr = null;
        if (minuteSeparator != null) {
            if (allowWhitespacesAroundMinuteSeparator) {
                ParseUtilsKt.skipWhitespaces($this$parseHourMinutesLenient, true);
            }
            if ((minutesStr = ParseUtilsKt.nextNumberAndAdvance($this$parseHourMinutesLenient, 2)) == null && !CharsKt.equals((char)minuteSeparator.charValue(), (char)'h', (boolean)true) || minutesStr != null && minutesStr.length() != 2) {
                $this$parseHourMinutesLenient.setCursor(initial);
                return null;
            }
            ParseUtilsKt.skipWhitespaces($this$parseHourMinutesLenient, true);
        }
        int hour = Integer.parseInt(hourStr);
        Clock12 clock12 = TimesSelectorParserKt.parseAmPm($this$parseHourMinutesLenient);
        if (clock12 != null && hour <= 12) {
            boolean isPm;
            boolean bl3 = isPm = clock12 == Clock12.PM;
            if (hour == 12) {
                hour = isPm ? 12 : 0;
            } else if (isPm) {
                hour += 12;
            }
        }
        ParseUtilsKt.retreatWhitespaces($this$parseHourMinutesLenient, true);
        String string2 = minutesStr;
        return new Pair((Object)hour, (Object)(string2 != null ? Integer.valueOf(Integer.parseInt(string2)) : null));
    }

    @Nullable
    public static final Clock12 parseAmPm(@NotNull StringWithCursor $this$parseAmPm) {
        Clock12 clock12;
        Intrinsics.checkNotNullParameter((Object)$this$parseAmPm, (String)"<this>");
        if (StringWithCursor.nextIsAndAdvance$default($this$parseAmPm, '\u33c2', false, 2, null)) {
            return Clock12.AM;
        }
        if (StringWithCursor.nextIsAndAdvance$default($this$parseAmPm, '\u33d8', false, 2, null)) {
            return Clock12.PM;
        }
        int initial = $this$parseAmPm.getCursor();
        if ($this$parseAmPm.nextIsAndAdvance('a', true)) {
            clock12 = Clock12.AM;
        } else if ($this$parseAmPm.nextIsAndAdvance('p', true)) {
            clock12 = Clock12.PM;
        } else {
            return null;
        }
        Clock12 clock122 = clock12;
        StringWithCursor.nextIsAndAdvance$default($this$parseAmPm, '.', false, 2, null);
        ParseUtilsKt.skipWhitespaces($this$parseAmPm, true);
        if (!$this$parseAmPm.nextIsAndAdvance('m', true)) {
            $this$parseAmPm.setCursor(initial);
            return null;
        }
        ParseUtilsKt.skipWhitespaces($this$parseAmPm, true);
        StringWithCursor.nextIsAndAdvance$default($this$parseAmPm, '.', false, 2, null);
        ParseUtilsKt.retreatWhitespaces($this$parseAmPm, true);
        return clock122;
    }

    @Nullable
    public static final EventTime parseEventTime(@NotNull StringWithCursor $this$parseEventTime, boolean lenient) {
        Intrinsics.checkNotNullParameter((Object)$this$parseEventTime, (String)"<this>");
        return lenient ? TimesSelectorParserKt.parseEventTimeLenient($this$parseEventTime) : TimesSelectorParserKt.parseEventTimeStrict($this$parseEventTime);
    }

    @Nullable
    public static final EventTime parseEventTimeLenient(@NotNull StringWithCursor $this$parseEventTimeLenient) {
        String string;
        block5: {
            block4: {
                Intrinsics.checkNotNullParameter((Object)$this$parseEventTimeLenient, (String)"<this>");
                string = ParseUtilsKt.getNextKeyword($this$parseEventTimeLenient, lenientEventTimeMaxLength);
                if (string == null) break block4;
                String string2 = string.toLowerCase(Locale.ROOT);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toLowerCase(...)");
                string = string2;
                if (string2 != null) break block5;
            }
            return null;
        }
        String word = string;
        EventTime eventTime = lenientEventTimeMap.get(word);
        if (eventTime == null) {
            return null;
        }
        EventTime event = eventTime;
        $this$parseEventTimeLenient.advanceBy(word.length());
        return event;
    }

    private static final EventTime parseEventTimeStrict(StringWithCursor $this$parseEventTimeStrict) {
        String string = ParseUtilsKt.getNextKeyword($this$parseEventTimeStrict, eventTimeMaxLength);
        if (string == null) {
            return null;
        }
        String word = string;
        EventTime eventTime = eventTimeMap.get(word);
        if (eventTime == null) {
            return null;
        }
        EventTime event = eventTime;
        $this$parseEventTimeStrict.advanceBy(word.length());
        return event;
    }

    /*
     * WARNING - void declaration
     */
    static {
        void $this$mapKeysTo$iv$iv;
        void $this$associateByTo$iv$iv;
        EventTime it;
        Map map;
        void $this$associateByTo$iv$iv2;
        Pair[] $this$associateBy$iv = (Pair[])EventTime.getEntries();
        boolean $i$f$associateBy22 = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
        Pair[] pairArray = $this$associateBy$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv : $this$associateByTo$iv$iv2) {
            EventTime eventTime = (EventTime)((Object)element$iv$iv);
            map = destination$iv$iv;
            boolean bl = false;
            map.put(it.getOsm$osm_opening_hours(), element$iv$iv);
        }
        eventTimeMap = destination$iv$iv;
        Iterator $i$f$associateBy22 = ((Iterable)eventTimeMap.keySet()).iterator();
        if (!$i$f$associateBy22.hasNext()) {
            throw new NoSuchElementException();
        }
        String it22 = (String)$i$f$associateBy22.next();
        boolean bl = false;
        int it22 = it22.length();
        while ($i$f$associateBy22.hasNext()) {
            String it32 = (String)$i$f$associateBy22.next();
            $i$a$-maxOf-TimesSelectorParserKt$eventTimeMaxLength$1 = false;
            int it32 = it32.length();
            if (it22 >= it32) continue;
            it22 = it32;
        }
        eventTimeMaxLength = it22;
        $this$associateBy$iv = (Iterable)EventTime.getEntries();
        boolean $i$f$associateBy = false;
        capacity$iv2 = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
        Pair[] it32 = $this$associateBy$iv;
        destination$iv$iv = new LinkedHashMap(capacity$iv2);
        $i$f$associateByTo = false;
        for (Object element$iv$iv : $this$associateByTo$iv$iv) {
            it = (EventTime)((Object)element$iv$iv);
            map = destination$iv$iv;
            boolean bl2 = false;
            map.put(it.getOsm$osm_opening_hours(), element$iv$iv);
        }
        $this$associateBy$iv = new Pair[]{TuplesKt.to((Object)"sundown", (Object)((Object)EventTime.Sunset)), TuplesKt.to((Object)"sunup", (Object)((Object)EventTime.Sunrise))};
        Map $this$mapKeys$iv = MapsKt.plus((Map)destination$iv$iv, (Map)MapsKt.mapOf((Pair[])$this$associateBy$iv));
        boolean $i$f$mapKeys = false;
        Map capacity$iv2 = $this$mapKeys$iv;
        Map destination$iv$iv2 = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapKeys$iv.size()));
        boolean $i$f$mapKeysTo = false;
        Iterable $this$associateByTo$iv$iv$iv = $this$mapKeysTo$iv$iv.entrySet();
        boolean $i$f$associateByTo2 = false;
        for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
            String string;
            void it$iv$iv;
            void it3;
            Map.Entry bl2 = (Map.Entry)element$iv$iv$iv;
            map = destination$iv$iv2;
            boolean bl3 = false;
            Intrinsics.checkNotNullExpressionValue((Object)((String)it3.getKey()).toLowerCase(Locale.ROOT), (String)"toLowerCase(...)");
            Map.Entry entry = (Map.Entry)element$iv$iv$iv;
            Map map2 = map;
            boolean bl4 = false;
            Object v = it$iv$iv.getValue();
            map2.put(string, v);
        }
        lenientEventTimeMap = destination$iv$iv2;
        Iterator iterator = ((Iterable)lenientEventTimeMap.keySet()).iterator();
        if (!iterator.hasNext()) {
            throw new NoSuchElementException();
        }
        String it4 = (String)iterator.next();
        boolean bl5 = false;
        int n = it4.length();
        while (iterator.hasNext()) {
            String it5 = (String)iterator.next();
            $i$a$-maxOf-TimesSelectorParserKt$lenientEventTimeMaxLength$1 = false;
            int n2 = it5.length();
            if (n >= n2) continue;
            n = n2;
        }
        lenientEventTimeMaxLength = n;
    }
}

