/*
 * Decompiled with CFR 0.152.
 */
package de.westnordost.osm_opening_hours.parser;

import de.westnordost.osm_opening_hours.model.LastNth;
import de.westnordost.osm_opening_hours.model.Nth;
import de.westnordost.osm_opening_hours.model.NthRange;
import de.westnordost.osm_opening_hours.model.NthSelector;
import de.westnordost.osm_opening_hours.model.SpecificWeekdays;
import de.westnordost.osm_opening_hours.model.Weekday;
import de.westnordost.osm_opening_hours.model.WeekdayRange;
import de.westnordost.osm_opening_hours.model.WeekdaysSelector;
import de.westnordost.osm_opening_hours.parser.ParseUtilsKt;
import de.westnordost.osm_opening_hours.parser.StringWithCursor;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.NoSuchElementException;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u00002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\b\u0006\u001a\u0016\u0010\u0000\u001a\u0004\u0018\u00010\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u0004H\u0000\u001a\u001b\u0010\u0005\u001a\u0004\u0018\u00010\u0006*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u0004H\u0000\u00a2\u0006\u0002\u0010\u0007\u001a\u0014\u0010\b\u001a\u00020\t*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u0004H\u0000\u001a\u0016\u0010\n\u001a\u0004\u0018\u00010\u000b*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u0004H\u0000\u001a\u000e\u0010\u0010\u001a\u0004\u0018\u00010\u000b*\u00020\u0002H\u0002\u001a\u000e\u0010\u0013\u001a\u0004\u0018\u00010\u000b*\u00020\u0002H\u0002\"\u001a\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000b0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u000f\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u001a\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000b0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0012\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"parseWeekdaySelector", "Lde/westnordost/osm_opening_hours/model/WeekdaysSelector;", "Lde/westnordost/osm_opening_hours/parser/StringWithCursor;", "lenient", "", "parseDayOffset", "", "(Lde/westnordost/osm_opening_hours/parser/StringWithCursor;Z)Ljava/lang/Integer;", "parseNthSelector", "Lde/westnordost/osm_opening_hours/model/NthSelector;", "parseWeekday", "Lde/westnordost/osm_opening_hours/model/Weekday;", "weekdaysMap", "", "", "weekdaysMaxLength", "parseWeekdayStrict", "lenientWeekdaysMap", "lenientWeekdaysMaxLength", "parseWeekdayLenient", "osm-opening-hours"})
@SourceDebugExtension(value={"SMAP\nWeekdaysSelectorParser.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WeekdaysSelectorParser.kt\nde/westnordost/osm_opening_hours/parser/WeekdaysSelectorParserKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,127:1\n1202#2,2:128\n1230#2,4:130\n1202#2,2:135\n1230#2,4:137\n1202#2,2:141\n1230#2,4:143\n1246#2,4:149\n1#3:134\n477#4:147\n423#4:148\n*S KotlinDebug\n*F\n+ 1 WeekdaysSelectorParser.kt\nde/westnordost/osm_opening_hours/parser/WeekdaysSelectorParserKt\n*L\n82#1:128,2\n82#1:130,4\n94#1:135,2\n94#1:137,4\n96#1:141,2\n96#1:143,4\n117#1:149,4\n117#1:147\n117#1:148\n*E\n"})
public final class WeekdaysSelectorParserKt {
    @NotNull
    private static final Map<String, Weekday> weekdaysMap;
    private static final int weekdaysMaxLength;
    @NotNull
    private static final Map<String, Weekday> lenientWeekdaysMap;
    private static final int lenientWeekdaysMaxLength;

    @Nullable
    public static final WeekdaysSelector parseWeekdaySelector(@NotNull StringWithCursor $this$parseWeekdaySelector, boolean lenient) {
        Intrinsics.checkNotNullParameter((Object)$this$parseWeekdaySelector, (String)"<this>");
        Weekday weekday = WeekdaysSelectorParserKt.parseWeekday($this$parseWeekdaySelector, lenient);
        if (weekday == null) {
            return null;
        }
        Weekday start = weekday;
        if (ParseUtilsKt.nextIsRangeAndAdvance($this$parseWeekdaySelector, lenient)) {
            ParseUtilsKt.skipWhitespaces($this$parseWeekdaySelector, lenient);
            Weekday weekday2 = WeekdaysSelectorParserKt.parseWeekday($this$parseWeekdaySelector, lenient);
            if (weekday2 == null) {
                ParseUtilsKt.fail($this$parseWeekdaySelector, "Expected an end weekday");
                throw new KotlinNothingValueException();
            }
            Weekday end = weekday2;
            return new WeekdayRange(start, end);
        }
        if (ParseUtilsKt.nextIsAndAdvance$default($this$parseWeekdaySelector, '[', lenient, true, false, 8, null)) {
            Integer dayOffset;
            ParseUtilsKt.skipWhitespaces($this$parseWeekdaySelector, lenient);
            List list = ParseUtilsKt.parseCommaSeparated($this$parseWeekdaySelector, lenient, arg_0 -> WeekdaysSelectorParserKt.parseWeekdaySelector$lambda$0(lenient, arg_0));
            if (list == null) {
                list = CollectionsKt.emptyList();
            }
            List nths = list;
            ParseUtilsKt.skipWhitespaces($this$parseWeekdaySelector, lenient);
            if (!StringWithCursor.nextIsAndAdvance$default($this$parseWeekdaySelector, ']', false, 2, null)) {
                ParseUtilsKt.fail($this$parseWeekdaySelector, "Expected a ']'");
                throw new KotlinNothingValueException();
            }
            Integer n = dayOffset = WeekdaysSelectorParserKt.parseDayOffset($this$parseWeekdaySelector, lenient);
            return new SpecificWeekdays(start, nths, n != null ? n : 0);
        }
        return start;
    }

    @Nullable
    public static final Integer parseDayOffset(@NotNull StringWithCursor $this$parseDayOffset, boolean lenient) {
        int n;
        Intrinsics.checkNotNullParameter((Object)$this$parseDayOffset, (String)"<this>");
        int initial = $this$parseDayOffset.getCursor();
        ParseUtilsKt.skipWhitespaces($this$parseDayOffset, lenient);
        if (StringWithCursor.nextIsAndAdvance$default($this$parseDayOffset, '+', false, 2, null)) {
            n = 1;
        } else if (StringWithCursor.nextIsAndAdvance$default($this$parseDayOffset, '-', false, 2, null)) {
            n = -1;
        } else {
            $this$parseDayOffset.setCursor(initial);
            return null;
        }
        int op = n;
        ParseUtilsKt.skipWhitespaces($this$parseDayOffset, lenient);
        String days = ParseUtilsKt.nextNumberAndAdvance$default($this$parseDayOffset, null, 1, null);
        if (days == null) {
            $this$parseDayOffset.setCursor(initial);
            return null;
        }
        ParseUtilsKt.skipWhitespaces($this$parseDayOffset, lenient);
        if (!$this$parseDayOffset.nextIsAndAdvance("day", lenient)) {
            $this$parseDayOffset.setCursor(initial);
            return null;
        }
        $this$parseDayOffset.nextIsAndAdvance('s', lenient);
        return op * Integer.parseInt(days);
    }

    @NotNull
    public static final NthSelector parseNthSelector(@NotNull StringWithCursor $this$parseNthSelector, boolean lenient) {
        Integer n;
        Intrinsics.checkNotNullParameter((Object)$this$parseNthSelector, (String)"<this>");
        boolean minus = StringWithCursor.nextIsAndAdvance$default($this$parseNthSelector, '-', false, 2, null);
        ParseUtilsKt.skipWhitespaces($this$parseNthSelector, lenient);
        String string = ParseUtilsKt.nextNumberAndAdvance($this$parseNthSelector, 1);
        if (string == null) {
            ParseUtilsKt.fail($this$parseNthSelector, "Expected an nth");
            throw new KotlinNothingValueException();
        }
        int start = Integer.parseInt(string);
        if (ParseUtilsKt.nextIsRangeAndAdvance($this$parseNthSelector, lenient)) {
            if (minus) {
                ParseUtilsKt.fail($this$parseNthSelector, "Negative nth not allowed in range");
                throw new KotlinNothingValueException();
            }
            ParseUtilsKt.skipWhitespaces($this$parseNthSelector, lenient);
            String string2 = ParseUtilsKt.nextNumberAndAdvance($this$parseNthSelector, 1);
            if (string2 == null) {
                ParseUtilsKt.fail($this$parseNthSelector, "Expected an end nth");
                throw new KotlinNothingValueException();
            }
            n = Integer.parseInt(string2);
        } else {
            n = null;
        }
        Integer end = n;
        return minus ? (NthSelector)new LastNth(start) : (end != null ? (NthSelector)new NthRange(start, end) : Nth.box-impl(Nth.constructor-impl(start)));
    }

    @Nullable
    public static final Weekday parseWeekday(@NotNull StringWithCursor $this$parseWeekday, boolean lenient) {
        Intrinsics.checkNotNullParameter((Object)$this$parseWeekday, (String)"<this>");
        return lenient ? WeekdaysSelectorParserKt.parseWeekdayLenient($this$parseWeekday) : WeekdaysSelectorParserKt.parseWeekdayStrict($this$parseWeekday);
    }

    private static final Weekday parseWeekdayStrict(StringWithCursor $this$parseWeekdayStrict) {
        String string = ParseUtilsKt.getNextKeyword($this$parseWeekdayStrict, weekdaysMaxLength);
        if (string == null) {
            return null;
        }
        String word = string;
        Weekday weekday = weekdaysMap.get(word);
        if (weekday == null) {
            return null;
        }
        Weekday event = weekday;
        $this$parseWeekdayStrict.advanceBy(word.length());
        return event;
    }

    private static final Weekday parseWeekdayLenient(StringWithCursor $this$parseWeekdayLenient) {
        String string;
        block5: {
            block4: {
                string = ParseUtilsKt.getNextKeyword($this$parseWeekdayLenient, lenientWeekdaysMaxLength);
                if (string == null) break block4;
                String string2 = string.toLowerCase(Locale.ROOT);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toLowerCase(...)");
                string = string2;
                if (string2 != null) break block5;
            }
            return null;
        }
        String word = string;
        Weekday weekday = lenientWeekdaysMap.get(word);
        if (weekday == null) {
            return null;
        }
        Weekday event = weekday;
        $this$parseWeekdayLenient.advanceBy(word.length());
        StringWithCursor.nextIsAndAdvance$default($this$parseWeekdayLenient, '.', false, 2, null);
        return event;
    }

    private static final NthSelector parseWeekdaySelector$lambda$0(boolean $lenient, StringWithCursor $this$parseCommaSeparated) {
        Intrinsics.checkNotNullParameter((Object)$this$parseCommaSeparated, (String)"$this$parseCommaSeparated");
        return WeekdaysSelectorParserKt.parseNthSelector($this$parseCommaSeparated, $lenient);
    }

    /*
     * WARNING - void declaration
     */
    static {
        void $this$mapKeysTo$iv$iv;
        Pair[] $this$associateByTo$iv$iv;
        Weekday it;
        Map map;
        void $this$associateByTo$iv$iv2;
        Pair[] $this$associateBy$iv = (Pair[])Weekday.getEntries();
        boolean $i$f$associateBy232 = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
        Pair[] pairArray = $this$associateBy$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateByTo = false;
        for (Object t : $this$associateByTo$iv$iv2) {
            Weekday weekday = (Weekday)t;
            map = destination$iv$iv;
            boolean bl = false;
            map.put(it.getOsm$osm_opening_hours(), t);
        }
        weekdaysMap = destination$iv$iv;
        Iterator $i$f$associateBy232 = ((Iterable)weekdaysMap.keySet()).iterator();
        if (!$i$f$associateBy232.hasNext()) {
            throw new NoSuchElementException();
        }
        String it232 = (String)$i$f$associateBy232.next();
        boolean bl = false;
        int it232 = it232.length();
        while ($i$f$associateBy232.hasNext()) {
            String it332 = (String)$i$f$associateBy232.next();
            boolean bl2 = false;
            int it332 = it332.length();
            if (it232 >= it332) continue;
            it232 = it332;
        }
        weekdaysMaxLength = it232;
        $this$associateBy$iv = (Iterable)Weekday.getEntries();
        boolean $i$f$associateBy = false;
        capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
        Pair[] it332 = $this$associateBy$iv;
        destination$iv$iv = new LinkedHashMap(capacity$iv);
        $i$f$associateByTo = false;
        for (Object t : $this$associateByTo$iv$iv) {
            it = (Weekday)t;
            map = destination$iv$iv;
            boolean bl2 = false;
            map.put(it.getOsm$osm_opening_hours(), t);
        }
        $this$associateBy$iv = (Iterable)Weekday.getEntries();
        map = destination$iv$iv;
        $i$f$associateBy = false;
        int capacity$iv32 = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
        $this$associateByTo$iv$iv = $this$associateBy$iv;
        destination$iv$iv = new LinkedHashMap(capacity$iv32);
        $i$f$associateByTo = false;
        for (Object t : $this$associateByTo$iv$iv) {
            it = (Weekday)t;
            Map map2 = destination$iv$iv;
            boolean bl3 = false;
            map2.put(it.name(), t);
        }
        $this$associateBy$iv = new Pair[]{TuplesKt.to((Object)"Mon", (Object)Weekday.Monday), TuplesKt.to((Object)"Tue", (Object)Weekday.Tuesday), TuplesKt.to((Object)"Wed", (Object)Weekday.Wednesday), TuplesKt.to((Object)"Thu", (Object)Weekday.Thursday), TuplesKt.to((Object)"Fri", (Object)Weekday.Friday), TuplesKt.to((Object)"Sat", (Object)Weekday.Saturday), TuplesKt.to((Object)"Sun", (Object)Weekday.Sunday)};
        Map map3 = MapsKt.plus((Map)MapsKt.plus((Map)map, (Map)destination$iv$iv), (Map)MapsKt.mapOf((Pair[])$this$associateBy$iv));
        $this$associateBy$iv = new Pair[]{TuplesKt.to((Object)"Mo", (Object)Weekday.Monday), TuplesKt.to((Object)"Di", (Object)Weekday.Tuesday), TuplesKt.to((Object)"Mi", (Object)Weekday.Wednesday), TuplesKt.to((Object)"Do", (Object)Weekday.Thursday), TuplesKt.to((Object)"Fr", (Object)Weekday.Friday), TuplesKt.to((Object)"Sa", (Object)Weekday.Saturday), TuplesKt.to((Object)"So", (Object)Weekday.Sunday)};
        Map $this$mapKeys$iv = MapsKt.plus((Map)map3, (Map)MapsKt.mapOf((Pair[])$this$associateBy$iv));
        boolean $i$f$mapKeys = false;
        Map capacity$iv32 = $this$mapKeys$iv;
        Map destination$iv$iv2 = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapKeys$iv.size()));
        boolean $i$f$mapKeysTo = false;
        Iterable $this$associateByTo$iv$iv$iv = $this$mapKeysTo$iv$iv.entrySet();
        boolean $i$f$associateByTo2 = false;
        for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
            String string;
            void it$iv$iv;
            void it3;
            Map.Entry bl3 = (Map.Entry)element$iv$iv$iv;
            map = destination$iv$iv2;
            boolean bl4 = false;
            Intrinsics.checkNotNullExpressionValue((Object)((String)it3.getKey()).toLowerCase(Locale.ROOT), (String)"toLowerCase(...)");
            Map.Entry entry = (Map.Entry)element$iv$iv$iv;
            Map map4 = map;
            boolean bl5 = false;
            Object v = it$iv$iv.getValue();
            map4.put(string, v);
        }
        lenientWeekdaysMap = destination$iv$iv2;
        Iterator iterator = ((Iterable)lenientWeekdaysMap.keySet()).iterator();
        if (!iterator.hasNext()) {
            throw new NoSuchElementException();
        }
        String it4 = (String)iterator.next();
        boolean bl6 = false;
        int n = it4.length();
        while (iterator.hasNext()) {
            String it5 = (String)iterator.next();
            boolean bl3 = false;
            int n2 = it5.length();
            if (n >= n2) continue;
            n = n2;
        }
        lenientWeekdaysMaxLength = n;
    }
}

