/*
 * Decompiled with CFR 0.152.
 */
package de.westnordost.osm_opening_hours.parser;

import de.westnordost.osm_opening_hours.model.Week;
import de.westnordost.osm_opening_hours.model.WeekRange;
import de.westnordost.osm_opening_hours.model.WeeksSelector;
import de.westnordost.osm_opening_hours.parser.ParseUtilsKt;
import de.westnordost.osm_opening_hours.parser.StringWithCursor;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u0000\u0012\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\u001a\u0014\u0010\u0000\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u0004H\u0000\u00a8\u0006\u0005"}, d2={"parseWeeksSelector", "Lde/westnordost/osm_opening_hours/model/WeeksSelector;", "Lde/westnordost/osm_opening_hours/parser/StringWithCursor;", "lenient", "", "osm-opening-hours"})
public final class WeeksSelectorParserKt {
    @NotNull
    public static final WeeksSelector parseWeeksSelector(@NotNull StringWithCursor $this$parseWeeksSelector, boolean lenient) {
        Intrinsics.checkNotNullParameter((Object)$this$parseWeeksSelector, (String)"<this>");
        String string = ParseUtilsKt.nextNumberAndAdvance($this$parseWeeksSelector, 2);
        if (string == null) {
            ParseUtilsKt.fail($this$parseWeeksSelector, "Expected a week number");
            throw new KotlinNothingValueException();
        }
        String start = string;
        if (!lenient && start.length() != 2) {
            ParseUtilsKt.fail($this$parseWeeksSelector, "Expected week number to consist of two digits");
            throw new KotlinNothingValueException();
        }
        if (ParseUtilsKt.nextIsRangeAndAdvance($this$parseWeeksSelector, lenient)) {
            Integer n;
            ParseUtilsKt.skipWhitespaces($this$parseWeeksSelector, lenient);
            String string2 = ParseUtilsKt.nextNumberAndAdvance($this$parseWeeksSelector, 2);
            if (string2 == null) {
                ParseUtilsKt.fail($this$parseWeeksSelector, "Expected an end week number");
                throw new KotlinNothingValueException();
            }
            String end = string2;
            if (!lenient && end.length() != 2) {
                ParseUtilsKt.fail($this$parseWeeksSelector, "Expected end week number to consist of two digits");
                throw new KotlinNothingValueException();
            }
            if (ParseUtilsKt.nextIsAndAdvance$default($this$parseWeeksSelector, '/', lenient, true, false, 8, null)) {
                ParseUtilsKt.skipWhitespaces($this$parseWeeksSelector, lenient);
                String string3 = ParseUtilsKt.nextNumberAndAdvance$default($this$parseWeeksSelector, null, 1, null);
                if (string3 == null) {
                    ParseUtilsKt.fail($this$parseWeeksSelector, "Expected a week interval");
                    throw new KotlinNothingValueException();
                }
                n = Integer.parseInt(string3);
            } else {
                n = null;
            }
            Integer step = n;
            return new WeekRange(Integer.parseInt(start), Integer.parseInt(end), step);
        }
        return Week.box-impl(Week.constructor-impl(Integer.parseInt(start)));
    }
}

