/*
 * Decompiled with CFR 0.152.
 */
package de.westnordost.osmapi.traces;

import de.westnordost.osmapi.ApiRequestWriter;
import de.westnordost.osmapi.ApiResponseReader;
import de.westnordost.osmapi.OsmConnection;
import de.westnordost.osmapi.common.FormDataWriter;
import de.westnordost.osmapi.common.Handler;
import de.westnordost.osmapi.common.IdResponseReader;
import de.westnordost.osmapi.common.SingleElementHandler;
import de.westnordost.osmapi.common.errors.OsmApiException;
import de.westnordost.osmapi.common.errors.OsmBadUserInputException;
import de.westnordost.osmapi.common.errors.OsmNotFoundException;
import de.westnordost.osmapi.common.errors.OsmQueryTooBigException;
import de.westnordost.osmapi.map.data.BoundingBox;
import de.westnordost.osmapi.traces.GpsTraceDetails;
import de.westnordost.osmapi.traces.GpsTraceWriter;
import de.westnordost.osmapi.traces.GpsTracesParser;
import de.westnordost.osmapi.traces.GpsTrackpoint;
import de.westnordost.osmapi.traces.GpxTrackParser;
import de.westnordost.osmapi.traces.GpxTrackWriter;
import java.io.IOException;
import java.util.List;
import java.util.Locale;

public class GpsTracesDao {
    private static final String GPX = "gpx";
    private final OsmConnection osm;

    public GpsTracesDao(OsmConnection osm) {
        this.osm = osm;
    }

    public long create(final String name, final GpsTraceDetails.Visibility visibility, final String description, final List<String> tags, final Iterable<GpsTrackpoint> trackpoints) {
        this.checkFieldLength("Name", name);
        this.checkFieldLength("Description", description);
        this.checkTagsLength(tags);
        FormDataWriter writer = new FormDataWriter(){

            protected void write() throws IOException {
                GpxTrackWriter trackWriter = new GpxTrackWriter(GpsTracesDao.this.osm.getUserAgent(), trackpoints);
                this.addFileField("file", name, (ApiRequestWriter)trackWriter);
                if (tags != null && !tags.isEmpty()) {
                    this.addField("tags", GpsTracesDao.toCommaList(tags));
                }
                this.addField("description", description);
                this.addField("visibility", visibility.toString().toLowerCase(Locale.UK));
            }
        };
        return (Long)this.osm.makeAuthenticatedRequest("gpx/create", "POST", (ApiRequestWriter)writer, (ApiResponseReader)new IdResponseReader());
    }

    public long create(String name, GpsTraceDetails.Visibility visibility, String description, Iterable<GpsTrackpoint> trackpoints) {
        return this.create(name, visibility, description, null, trackpoints);
    }

    private static String toCommaList(List<String> vals) {
        StringBuilder result = new StringBuilder();
        boolean first = true;
        for (String val : vals) {
            if (first) {
                first = false;
            } else {
                result.append(",");
            }
            result.append(val);
        }
        return result.toString();
    }

    private void checkTagsLength(List<String> tags) {
        if (tags == null) {
            return;
        }
        for (String tag : tags) {
            this.checkFieldLength("Tag \"" + tag + "\"", tag);
        }
    }

    private void checkFieldLength(String name, String value) {
        if (value.length() >= 256) {
            throw new IllegalArgumentException(name + " must have less than 256 characters.");
        }
    }

    public void update(long id, GpsTraceDetails.Visibility visibility, String description, List<String> tags) {
        this.checkFieldLength("Description", description);
        this.checkTagsLength(tags);
        GpsTraceWriter writer = new GpsTraceWriter(id, visibility, description, tags);
        this.osm.makeAuthenticatedRequest("gpx/" + id, "PUT", (ApiRequestWriter)writer);
    }

    public void delete(long id) {
        this.osm.makeAuthenticatedRequest("gpx/" + id, "DELETE");
    }

    public GpsTraceDetails get(long id) {
        SingleElementHandler handler = new SingleElementHandler();
        try {
            this.osm.makeAuthenticatedRequest("gpx/" + id, "GET", (ApiResponseReader)new GpsTracesParser((Handler<GpsTraceDetails>)handler));
        }
        catch (OsmNotFoundException e) {
            return null;
        }
        return (GpsTraceDetails)handler.get();
    }

    public void getData(long id, Handler<GpsTrackpoint> handler) {
        this.osm.makeAuthenticatedRequest("gpx/" + id + "/data", "GET", (ApiResponseReader)new GpxTrackParser(handler));
    }

    public void getMine(Handler<GpsTraceDetails> handler) {
        this.osm.makeAuthenticatedRequest("user/gpx_files", "GET", (ApiResponseReader)new GpsTracesParser(handler));
    }

    public void getAll(BoundingBox bounds, Handler<GpsTrackpoint> handler, int page) {
        if (page < 0) {
            throw new IllegalArgumentException("Page number must be greater than or equal to 0");
        }
        String query = "trackpoints?bbox=" + bounds.getAsLeftBottomRightTopString() + "&page=" + page;
        try {
            this.osm.makeRequest(query, (ApiResponseReader)new GpxTrackParser(handler));
        }
        catch (OsmBadUserInputException e) {
            throw new OsmQueryTooBigException((OsmApiException)e);
        }
    }
}

