/*
 * Decompiled with CFR 0.152.
 */
package de.westnordost.osmapi.traces;

import de.westnordost.osmapi.common.Iso8601CompatibleDateFormat;
import de.westnordost.osmapi.common.OsmXmlDateFormat;
import java.text.ParseException;
import java.util.Date;
import java.util.regex.Pattern;

public class GpxDateFormat
extends OsmXmlDateFormat {
    private static final Iso8601CompatibleDateFormat MILLIS = new Iso8601CompatibleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ");
    private static final Pattern MILLIS_PATTERN = Pattern.compile("\\.[0-9]{3}");

    private static boolean hasMillis(String source) {
        return MILLIS_PATTERN.matcher(source).find();
    }

    public Date parse(String source) throws ParseException {
        if (GpxDateFormat.hasMillis(source)) {
            return MILLIS.parse(source);
        }
        return super.parse(source);
    }

    public String format(Date date) {
        if (date.getTime() % 1000L > 0L) {
            return MILLIS.format(date);
        }
        return super.format(date);
    }
}

