/*
 * Decompiled with CFR 0.152.
 */
package de.westnordost.osmapi.traces;

import de.westnordost.osmapi.ApiResponseReader;
import de.westnordost.osmapi.common.Handler;
import de.westnordost.osmapi.common.XmlParser;
import de.westnordost.osmapi.map.data.LatLon;
import de.westnordost.osmapi.map.data.OsmLatLon;
import de.westnordost.osmapi.traces.GpsTrackpoint;
import de.westnordost.osmapi.traces.GpxDateFormat;
import java.io.IOException;
import java.io.InputStream;
import java.text.ParseException;

public class GpxTrackParser
extends XmlParser
implements ApiResponseReader<Void> {
    private static final String TRACKPOINT = "trkpt";
    private static final String TRACKSEGMENT = "trkseg";
    private final GpxDateFormat dateFormat = new GpxDateFormat();
    private Handler<GpsTrackpoint> handler;
    private boolean first;
    private GpsTrackpoint trackpoint;

    public GpxTrackParser(Handler<GpsTrackpoint> handler) {
        this.handler = handler;
    }

    public Void parse(InputStream in) throws IOException {
        this.doParse(in);
        return null;
    }

    protected void onStartElement() throws ParseException {
        String name = this.getName();
        if (name.equals(TRACKSEGMENT)) {
            this.first = true;
        } else if (name.equals(TRACKPOINT)) {
            this.trackpoint = new GpsTrackpoint((LatLon)OsmLatLon.parseLatLon((String)this.getAttribute("lat"), (String)this.getAttribute("lon")));
            if (this.first) {
                this.trackpoint.isFirstPointInTrackSegment = this.first;
                this.first = false;
            }
        }
    }

    protected void onEndElement() throws ParseException {
        String name = this.getName();
        if (TRACKPOINT.equals(name)) {
            this.handler.handle((Object)this.trackpoint);
            this.trackpoint = null;
        } else if (TRACKPOINT.equals(this.getParentName())) {
            if (name.equals("time")) {
                this.trackpoint.time = this.dateFormat.parse(this.getText());
            }
            if (name.equals("ele")) {
                this.trackpoint.elevation = Float.valueOf(this.getText());
            }
            if (name.equals("hdop")) {
                this.trackpoint.horizontalDilutionOfPrecision = Float.valueOf(this.getText());
            }
        }
    }
}

