/*
 * Decompiled with CFR 0.152.
 */
package de.westnordost.osmapi.traces;

import de.westnordost.osmapi.common.XmlWriter;
import de.westnordost.osmapi.traces.GpsTraceDetails;
import java.io.IOException;
import java.util.List;
import java.util.Locale;

public class GpsTraceWriter
extends XmlWriter {
    private final long id;
    private final GpsTraceDetails.Visibility visibility;
    private final String description;
    private final List<String> tags;

    public GpsTraceWriter(long id, GpsTraceDetails.Visibility visibility, String description, List<String> tags) {
        this.id = id;
        this.visibility = visibility;
        this.description = description;
        this.tags = tags;
    }

    protected void write() throws IOException {
        this.begin("osm");
        this.begin("gpx_file");
        this.writeTrace();
        this.end();
        this.end();
    }

    private void writeTrace() throws IOException {
        this.attribute("id", this.id);
        this.attribute("visibility", this.visibility.toString().toLowerCase(Locale.UK));
        this.begin("description");
        if (this.description != null) {
            this.text(this.description);
        }
        this.end();
        if (this.tags != null) {
            for (String tag : this.tags) {
                this.begin("tag");
                this.text(tag);
                this.end();
            }
        }
    }
}

