/*
 * Decompiled with CFR 0.152.
 */
package de.westnordost.osmapi.traces;

import de.westnordost.osmapi.ApiResponseReader;
import de.westnordost.osmapi.common.Handler;
import de.westnordost.osmapi.common.XmlParser;
import de.westnordost.osmapi.map.data.OsmLatLon;
import de.westnordost.osmapi.traces.GpsTraceDetails;
import java.io.IOException;
import java.io.InputStream;
import java.text.ParseException;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Locale;

public class GpsTracesParser
extends XmlParser
implements ApiResponseReader<Void> {
    private static final String GPX_FILE = "gpx_file";
    private static final String TAG = "tag";
    private static final String DESCRIPTION = "description";
    private final Handler<GpsTraceDetails> handler;
    private GpsTraceDetails trace;

    public GpsTracesParser(Handler<GpsTraceDetails> handler) {
        this.handler = handler;
    }

    public Void parse(InputStream in) throws IOException {
        this.doParse(in);
        return null;
    }

    protected void onStartElement() throws ParseException {
        if (this.getName().equals(GPX_FILE)) {
            String timestamp;
            this.trace = new GpsTraceDetails();
            this.trace.id = this.getLongAttribute("id");
            this.trace.visibility = GpsTraceDetails.Visibility.valueOf(this.getAttribute("visibility").toUpperCase(Locale.UK));
            this.trace.name = this.getAttribute("name");
            this.trace.userName = this.getAttribute("user");
            Boolean pendingAttribute = this.getBooleanAttribute("pending");
            this.trace.pending = pendingAttribute == null || pendingAttribute != false;
            String lat = this.getAttribute("lat");
            String lon = this.getAttribute("lon");
            if (lat != null && lon != null) {
                this.trace.position = OsmLatLon.parseLatLon((String)lat, (String)lon);
            }
            if ((timestamp = this.getAttribute("timestamp")) != null) {
                this.trace.createdAt = Instant.parse(timestamp);
            }
        }
    }

    protected void onEndElement() {
        String name = this.getName();
        if (name.equals(GPX_FILE)) {
            this.handler.handle((Object)this.trace);
            this.trace = null;
        } else if (name.equals(DESCRIPTION)) {
            this.trace.description = this.getText();
        } else if (name.equals(TAG)) {
            if (this.trace.tags == null) {
                this.trace.tags = new ArrayList<String>();
            }
            this.trace.tags.add(this.getText());
        }
    }
}

