/*
 * Decompiled with CFR 0.152.
 */
package de.westnordost.osmapi.traces;

import de.westnordost.osmapi.ApiResponseReader;
import de.westnordost.osmapi.common.Handler;
import de.westnordost.osmapi.common.XmlParser;
import de.westnordost.osmapi.map.data.LatLon;
import de.westnordost.osmapi.map.data.OsmLatLon;
import de.westnordost.osmapi.traces.GpsTrackpoint;
import java.io.IOException;
import java.io.InputStream;
import java.text.ParseException;
import java.time.Instant;

public class GpxTrackParser
extends XmlParser
implements ApiResponseReader<Void> {
    private static final String TRACKPOINT = "trkpt";
    private static final String TRACKSEGMENT = "trkseg";
    private final Handler<GpsTrackpoint> handler;
    private boolean isFirstPointInTrackSegment = false;
    private LatLon position;
    private Instant time;
    private Float horizontalDilutionOfPrecision;
    private Float elevation;

    public GpxTrackParser(Handler<GpsTrackpoint> handler) {
        this.handler = handler;
    }

    public Void parse(InputStream in) throws IOException {
        this.doParse(in);
        return null;
    }

    protected void onStartElement() throws ParseException {
        String name = this.getName();
        if (name.equals(TRACKSEGMENT)) {
            this.isFirstPointInTrackSegment = true;
        } else if (name.equals(TRACKPOINT)) {
            this.position = OsmLatLon.parseLatLon((String)this.getAttribute("lat"), (String)this.getAttribute("lon"));
        }
    }

    protected void onEndElement() throws ParseException {
        String name = this.getName();
        if (TRACKPOINT.equals(name)) {
            this.handler.handle((Object)new GpsTrackpoint(this.position, this.time, this.isFirstPointInTrackSegment, this.horizontalDilutionOfPrecision, this.elevation));
            this.position = null;
            this.time = null;
            this.isFirstPointInTrackSegment = false;
            this.horizontalDilutionOfPrecision = null;
            this.elevation = null;
        } else if (TRACKPOINT.equals(this.getParentName())) {
            if (name.equals("time")) {
                this.time = Instant.parse(this.getText());
            }
            if (name.equals("ele")) {
                this.elevation = Float.valueOf(this.getText());
            }
            if (name.equals("hdop")) {
                this.horizontalDilutionOfPrecision = Float.valueOf(this.getText());
            }
        }
    }
}

