/*
 * Decompiled with CFR 0.152.
 */
package de.westnordost.osmapi.traces;

import de.westnordost.osmapi.common.XmlWriter;
import de.westnordost.osmapi.traces.GpsTrackpoint;
import java.io.IOException;
import java.time.format.DateTimeFormatter;

public class GpxTrackWriter
extends XmlWriter {
    private static final DateTimeFormatter FORMATTER = DateTimeFormatter.ISO_INSTANT;
    private final String userAgent;
    private final Iterable<GpsTrackpoint> trackpoints;

    public GpxTrackWriter(String userAgent, Iterable<GpsTrackpoint> trackpoints) {
        this.userAgent = userAgent;
        this.trackpoints = trackpoints;
    }

    protected void write() throws IOException {
        this.begin("gpx");
        this.attribute("version", 1.0);
        this.attribute("creator", this.userAgent);
        this.attribute("xmlns", "http://www.topografix.com/GPX/1/0");
        this.attribute("xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance");
        this.attribute("xsi:schemaLocation", "http://www.topografix.com/GPX/1/0 http://www.topografix.com/GPX/1/0/gpx.xsd");
        this.writeTrack();
        this.end();
    }

    private void writeTrack() throws IOException {
        this.begin("trk");
        boolean isVeryFirst = true;
        int segmentCount = 0;
        for (GpsTrackpoint trackpoint : this.trackpoints) {
            if (trackpoint.isFirstPointInTrackSegment || isVeryFirst) {
                if (!isVeryFirst) {
                    this.end();
                }
                this.begin("trkseg");
                ++segmentCount;
                isVeryFirst = false;
            }
            this.writeTrackpoint(trackpoint);
        }
        if (segmentCount > 0) {
            this.end();
        }
        this.end();
    }

    private void writeTrackpoint(GpsTrackpoint trackpoint) throws IOException {
        this.begin("trkpt");
        this.attribute("lat", trackpoint.position.getLatitude());
        this.attribute("lon", trackpoint.position.getLongitude());
        this.begin("time");
        this.text(FORMATTER.format(trackpoint.time));
        this.end();
        if (trackpoint.elevation != null) {
            this.begin("ele");
            float ele1Decimal = GpxTrackWriter.roundToOneDecimal(trackpoint.elevation.floatValue());
            this.text(String.valueOf(ele1Decimal));
            this.end();
        }
        if (trackpoint.horizontalDilutionOfPrecision != null) {
            this.begin("hdop");
            float hdop1Decimal = GpxTrackWriter.roundToOneDecimal(trackpoint.horizontalDilutionOfPrecision.floatValue());
            this.text(String.valueOf(hdop1Decimal));
            this.end();
        }
        this.end();
    }

    private static float roundToOneDecimal(float x) {
        return (float)Math.round(10.0f * x) / 10.0f;
    }
}

