/*
 * Decompiled with CFR 0.152.
 */
package de.westnordost.osmapi.user;

import de.westnordost.osmapi.ApiResponseReader;
import de.westnordost.osmapi.OsmConnection;
import de.westnordost.osmapi.common.Handler;
import de.westnordost.osmapi.common.ListHandler;
import de.westnordost.osmapi.common.SingleElementHandler;
import de.westnordost.osmapi.common.errors.OsmNotFoundException;
import de.westnordost.osmapi.user.UserDetails;
import de.westnordost.osmapi.user.UserDetailsParser;
import de.westnordost.osmapi.user.UserInfo;
import de.westnordost.osmapi.user.UserInfoParser;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class UserApi {
    private final OsmConnection osm;

    public UserApi(OsmConnection osm) {
        this.osm = osm;
    }

    public UserDetails getMine() {
        SingleElementHandler handler = new SingleElementHandler();
        this.osm.makeAuthenticatedRequest("user/details", null, (ApiResponseReader)new UserDetailsParser((Handler<UserInfo>)handler));
        return (UserDetails)handler.get();
    }

    public UserInfo get(long userId) {
        try {
            SingleElementHandler handler = new SingleElementHandler();
            boolean authenticate = this.osm.getOAuth() != null;
            this.osm.makeRequest("user/" + userId, authenticate, (ApiResponseReader)new UserInfoParser((Handler<UserInfo>)handler));
            return (UserInfo)handler.get();
        }
        catch (OsmNotFoundException e) {
            return null;
        }
    }

    public List<UserInfo> getAll(Collection<Long> userIds) {
        if (userIds.isEmpty()) {
            return Collections.emptyList();
        }
        ListHandler handler = new ListHandler();
        boolean authenticate = this.osm.getOAuth() != null;
        this.osm.makeRequest("users?users=" + UserApi.toCommaList(userIds), authenticate, (ApiResponseReader)new UserInfoParser((Handler<UserInfo>)handler));
        return handler.get();
    }

    private static String toCommaList(Iterable<Long> vals) {
        StringBuilder result = new StringBuilder();
        boolean first = true;
        for (Long id : vals) {
            if (id == null) continue;
            if (first) {
                first = false;
            } else {
                result.append(",");
            }
            result.append(id);
        }
        return result.toString();
    }
}

