/*
 * Decompiled with CFR 0.152.
 */
package de.westnordost.osmapi.user;

import de.westnordost.osmapi.common.Handler;
import de.westnordost.osmapi.map.data.OsmLatLon;
import de.westnordost.osmapi.user.UserDetails;
import de.westnordost.osmapi.user.UserInfo;
import de.westnordost.osmapi.user.UserInfoParser;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.List;

public class UserDetailsParser
extends UserInfoParser {
    private static final String USER = "user";
    private static final String LANGUAGES = "languages";
    private List<String> languages;
    private UserDetails userDetails;

    public UserDetailsParser(Handler<UserInfo> handler) {
        super(handler);
    }

    @Override
    protected void createUser(long id, String name) {
        this.userDetails = new UserDetails(id, name);
        this.user = this.userDetails;
    }

    @Override
    protected void onStartElement() throws ParseException {
        super.onStartElement();
        String name = this.getName();
        String parent = this.getParentName();
        if (LANGUAGES.equals(name)) {
            this.languages = new ArrayList<String>();
        } else if (USER.equals(parent)) {
            switch (name) {
                case "contributor-terms": {
                    Boolean publicDomain = this.getBooleanAttribute("pd");
                    if (publicDomain == null) break;
                    this.userDetails.considersHisContributionsAsPublicDomain = publicDomain;
                    break;
                }
                case "home": {
                    this.userDetails.homeLocation = OsmLatLon.parseLatLon((String)this.getAttribute("lat"), (String)this.getAttribute("lon"));
                    this.userDetails.homeZoom = this.getByteAttribute("zoom");
                }
            }
        } else if ("messages".equals(parent)) {
            switch (name) {
                case "received": {
                    this.userDetails.inboxMessageCount = this.getIntAttribute("count");
                    this.userDetails.unreadMessagesCount = this.getIntAttribute("unread");
                    break;
                }
                case "sent": {
                    this.userDetails.sentMessagesCount = this.getIntAttribute("count");
                }
            }
        }
    }

    @Override
    protected void onEndElement() {
        String name = this.getName();
        String parent = this.getParentName();
        if (USER.equals(name)) {
            this.handler.handle((Object)this.userDetails);
            this.userDetails = null;
            this.user = null;
        } else if (LANGUAGES.equals(name)) {
            this.userDetails.preferredLanguages = this.languages;
            this.languages = null;
        }
        if (LANGUAGES.equals(parent) && "lang".equals(name)) {
            assert (this.languages != null);
            this.languages.add(this.getText());
        }
    }
}

