/*
 * Decompiled with CFR 0.152.
 */
package de.westnordost.osmapi.user;

import de.westnordost.osmapi.ApiResponseReader;
import de.westnordost.osmapi.common.Handler;
import de.westnordost.osmapi.common.XmlParser;
import de.westnordost.osmapi.user.UserInfo;
import java.io.IOException;
import java.io.InputStream;
import java.text.ParseException;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;

public class UserInfoParser
extends XmlParser
implements ApiResponseReader<Void> {
    private static final String USER = "user";
    private static final String ROLES = "roles";
    private static final String BLOCKS = "blocks";
    private List<String> roles;
    protected Handler<UserInfo> handler;
    protected UserInfo user;

    public UserInfoParser(Handler<UserInfo> handler) {
        this.handler = handler;
    }

    public Void parse(InputStream in) throws IOException {
        this.doParse(in);
        return null;
    }

    protected void createUser(long id, String name) {
        this.user = new UserInfo(id, name);
    }

    protected void onStartElement() throws ParseException {
        String name = this.getName();
        String parent = this.getParentName();
        if (USER.equals(name)) {
            this.createUser(this.getLongAttribute("id"), this.getAttribute("display_name"));
            this.user.createdAt = Instant.parse(this.getAttribute("account_created"));
        }
        if (USER.equals(parent)) {
            switch (name) {
                case "img": {
                    this.user.profileImageUrl = this.getAttribute("href");
                    break;
                }
                case "changesets": {
                    this.user.changesetsCount = this.getIntAttribute("count");
                    break;
                }
                case "traces": {
                    this.user.gpsTracesCount = this.getIntAttribute("count");
                    break;
                }
                case "contributor-terms": {
                    this.user.hasAgreedToContributorTerms = this.getBooleanAttribute("agreed");
                }
            }
        } else if (BLOCKS.equals(parent) && "received".equals(name)) {
            this.user.isBlocked = this.getIntAttribute("active") != 0;
        }
    }

    protected void onEndElement() {
        String name = this.getName();
        String parent = this.getParentName();
        if (USER.equals(name)) {
            this.handler.handle((Object)this.user);
            this.user = null;
        } else if (ROLES.equals(name)) {
            this.user.roles = this.roles;
            this.roles = null;
        }
        if (USER.equals(parent)) {
            if ("description".equals(name)) {
                this.user.profileDescription = this.getText();
            }
        } else if (ROLES.equals(parent) && "role".equals(name)) {
            if (this.roles == null) {
                this.roles = new ArrayList<String>(1);
            }
            this.roles.add(this.getText());
        }
    }
}

