/*
 * Decompiled with CFR 0.152.
 */
package de.westnordost.osmfeatures;

import de.westnordost.osmfeatures.BaseFeature;
import de.westnordost.osmfeatures.Feature;
import de.westnordost.osmfeatures.IDPresetsJsonParser;
import de.westnordost.osmfeatures.PerCountryFeatureCollection;
import de.westnordost.osmfeatures.ResourceAccessAdapter;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.io.Source;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0000\n\u0002\u0010\u001e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\"\u0010\u000b\u001a\u0004\u0018\u00010\t2\u0006\u0010\f\u001a\u00020\u00072\u000e\u0010\r\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u000eH\u0016J\u001e\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\t0\u00102\u000e\u0010\r\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u000eH\u0016J.\u0010\u0011\u001a\u001e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\t0\u0006j\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\t`\n2\b\u0010\u0012\u001a\u0004\u0018\u00010\u0007H\u0002J\u0012\u0010\u0013\u001a\u00020\u00072\b\u0010\u0012\u001a\u0004\u0018\u00010\u0007H\u0002J\u0018\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00150\u000e2\b\u0010\u0012\u001a\u0004\u0018\u00010\u0007H\u0002Rr\u0010\u0005\u001af\u0012\u0006\u0012\u0004\u0018\u00010\u0007\u0012&\u0012$\u0012 \u0012\u001e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\t0\u0006j\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\t`\n0\b0\u0006j2\u0012\u0006\u0012\u0004\u0018\u00010\u0007\u0012&\u0012$\u0012 \u0012\u001e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\t0\u0006j\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\t`\n0\b`\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lde/westnordost/osmfeatures/IDBrandPresetsFeatureCollection;", "Lde/westnordost/osmfeatures/PerCountryFeatureCollection;", "fileAccess", "Lde/westnordost/osmfeatures/ResourceAccessAdapter;", "(Lde/westnordost/osmfeatures/ResourceAccessAdapter;)V", "featuresByIdByCountryCode", "Ljava/util/LinkedHashMap;", "", "Lkotlin/Lazy;", "Lde/westnordost/osmfeatures/Feature;", "Lkotlin/collections/LinkedHashMap;", "get", "id", "countryCodes", "", "getAll", "", "getOrLoadPerCountryFeatures", "countryCode", "getPresetsFileName", "loadFeatures", "Lde/westnordost/osmfeatures/BaseFeature;", "osmfeatures"})
@SourceDebugExtension(value={"SMAP\nIDBrandPresetsFeatureCollection.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IDBrandPresetsFeatureCollection.kt\nde/westnordost/osmfeatures/IDBrandPresetsFeatureCollection\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,51:1\n372#2,7:52\n*S KotlinDebug\n*F\n+ 1 IDBrandPresetsFeatureCollection.kt\nde/westnordost/osmfeatures/IDBrandPresetsFeatureCollection\n*L\n36#1:52,7\n*E\n"})
public final class IDBrandPresetsFeatureCollection
implements PerCountryFeatureCollection {
    @NotNull
    private final ResourceAccessAdapter fileAccess;
    @NotNull
    private final LinkedHashMap<String, Lazy<LinkedHashMap<String, Feature>>> featuresByIdByCountryCode;

    public IDBrandPresetsFeatureCollection(@NotNull ResourceAccessAdapter fileAccess) {
        Intrinsics.checkNotNullParameter((Object)fileAccess, (String)"fileAccess");
        this.fileAccess = fileAccess;
        this.featuresByIdByCountryCode = new LinkedHashMap(320);
        this.getOrLoadPerCountryFeatures(null);
    }

    @Override
    @NotNull
    public Collection<Feature> getAll(@NotNull List<String> countryCodes) {
        Intrinsics.checkNotNullParameter(countryCodes, (String)"countryCodes");
        HashMap result = new HashMap();
        for (String cc : countryCodes) {
            result.putAll(this.getOrLoadPerCountryFeatures(cc));
        }
        Collection<Feature> collection = result.values();
        Intrinsics.checkNotNullExpressionValue(collection, (String)"<get-values>(...)");
        return collection;
    }

    @Override
    @Nullable
    public Feature get(@NotNull String id, @NotNull List<String> countryCodes) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter(countryCodes, (String)"countryCodes");
        for (String countryCode : countryCodes) {
            Feature result = this.getOrLoadPerCountryFeatures(countryCode).get(id);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    private final LinkedHashMap<String, Feature> getOrLoadPerCountryFeatures(String countryCode) {
        Object object;
        Map $this$getOrPut$iv = this.featuresByIdByCountryCode;
        boolean $i$f$getOrPut = false;
        Object value$iv = $this$getOrPut$iv.get(countryCode);
        if (value$iv == null) {
            boolean bl = false;
            Lazy answer$iv = LazyKt.lazy((Function0)((Function0)new Function0<LinkedHashMap<String, Feature>>(this, countryCode){
                final /* synthetic */ IDBrandPresetsFeatureCollection this$0;
                final /* synthetic */ String $countryCode;
                {
                    this.this$0 = $receiver;
                    this.$countryCode = $countryCode;
                    super(0);
                }

                /*
                 * WARNING - void declaration
                 */
                @NotNull
                public final LinkedHashMap<String, Feature> invoke() {
                    void var2_2;
                    void $this$associateByTo$iv;
                    Iterable iterable = IDBrandPresetsFeatureCollection.access$loadFeatures(this.this$0, this.$countryCode);
                    Map destination$iv = new LinkedHashMap<K, V>();
                    boolean $i$f$associateByTo = false;
                    for (T element$iv : $this$associateByTo$iv) {
                        void it;
                        BaseFeature baseFeature = (BaseFeature)element$iv;
                        Map map = destination$iv;
                        boolean bl = false;
                        map.put(it.getId(), element$iv);
                    }
                    return (LinkedHashMap)var2_2;
                }
            }));
            $this$getOrPut$iv.put(countryCode, answer$iv);
            object = answer$iv;
        } else {
            object = value$iv;
        }
        return (LinkedHashMap)((Lazy)object).getValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final List<BaseFeature> loadFeatures(String countryCode) {
        List<BaseFeature> list;
        String filename = this.getPresetsFileName(countryCode);
        if (!this.fileAccess.exists(filename)) {
            return CollectionsKt.emptyList();
        }
        AutoCloseable autoCloseable = (AutoCloseable)this.fileAccess.open(filename);
        Throwable throwable = null;
        try {
            Source source = (Source)autoCloseable;
            boolean bl = false;
            list = new IDPresetsJsonParser(true).parse(source);
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
        return list;
    }

    private final String getPresetsFileName(String countryCode) {
        String string = countryCode;
        return string == null ? "presets.json" : "presets-" + string + ".json";
    }

    public static final /* synthetic */ List access$loadFeatures(IDBrandPresetsFeatureCollection $this, String countryCode) {
        return $this.loadFeatures(countryCode);
    }
}

