/*
 * Decompiled with CFR 0.152.
 */
package de.westnordost.osmfeatures;

import de.westnordost.osmfeatures.BaseFeature;
import de.westnordost.osmfeatures.Feature;
import de.westnordost.osmfeatures.IDLocalizedFeatureCollectionKt;
import de.westnordost.osmfeatures.IDPresetsJsonParser;
import de.westnordost.osmfeatures.IDPresetsTranslationJsonParser;
import de.westnordost.osmfeatures.LocalizedFeature;
import de.westnordost.osmfeatures.LocalizedFeatureCollection;
import de.westnordost.osmfeatures.ResourceAccessAdapter;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.io.Source;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u001e\n\u0002\b\b\b\u0000\u0018\u0000 \u001d2\u00020\u0001:\u0001\u001dB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\"\u0010\u0012\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u0013\u001a\u00020\u00072\u000e\u0010\u0014\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00070\fH\u0016J\u001e\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u000e0\u00162\u000e\u0010\u0014\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00070\fH\u0016J4\u0010\u0017\u001a\u001e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u000e0\u0006j\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u000e`\t2\u000e\u0010\u0014\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00070\fH\u0002J\u0016\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00110\f2\u0006\u0010\u0019\u001a\u00020\u0007H\u0002J\u000e\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\b0\fH\u0002J4\u0010\u001b\u001a\u001e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u000e0\u0006j\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u000e`\t2\u000e\u0010\u0014\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00070\fH\u0002J\u0018\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00110\f2\b\u0010\u0019\u001a\u0004\u0018\u00010\u0007H\u0002R*\u0010\u0005\u001a\u001e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006j\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b`\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R~\u0010\n\u001ar\u0012\f\u0012\n\u0012\u0006\u0012\u0004\u0018\u00010\u00070\f\u0012&\u0012$\u0012 \u0012\u001e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u000e0\u0006j\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u000e`\t0\r0\u000bj8\u0012\f\u0012\n\u0012\u0006\u0012\u0004\u0018\u00010\u00070\f\u0012&\u0012$\u0012 \u0012\u001e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u000e0\u0006j\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u000e`\t0\r`\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000RF\u0010\u0010\u001a:\u0012\u0006\u0012\u0004\u0018\u00010\u0007\u0012\u0010\u0012\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00110\f0\r0\u000bj\u001c\u0012\u0006\u0012\u0004\u0018\u00010\u0007\u0012\u0010\u0012\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00110\f0\r`\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lde/westnordost/osmfeatures/IDLocalizedFeatureCollection;", "Lde/westnordost/osmfeatures/LocalizedFeatureCollection;", "fileAccess", "Lde/westnordost/osmfeatures/ResourceAccessAdapter;", "(Lde/westnordost/osmfeatures/ResourceAccessAdapter;)V", "featuresById", "Ljava/util/LinkedHashMap;", "", "Lde/westnordost/osmfeatures/BaseFeature;", "Lkotlin/collections/LinkedHashMap;", "localizedFeatures", "Ljava/util/HashMap;", "", "Lkotlin/Lazy;", "Lde/westnordost/osmfeatures/Feature;", "Lkotlin/collections/HashMap;", "localizedFeaturesList", "Lde/westnordost/osmfeatures/LocalizedFeature;", "get", "id", "languages", "getAll", "", "getOrLoadLocalizedFeatures", "getOrLoadLocalizedFeaturesList", "language", "loadFeatures", "loadLocalizedFeatures", "loadLocalizedFeaturesList", "Companion", "osmfeatures"})
@SourceDebugExtension(value={"SMAP\nIDLocalizedFeatureCollection.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IDLocalizedFeatureCollection.kt\nde/westnordost/osmfeatures/IDLocalizedFeatureCollection\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,86:1\n1222#2,4:87\n1#3:91\n372#4,7:92\n372#4,7:99\n*S KotlinDebug\n*F\n+ 1 IDLocalizedFeatureCollection.kt\nde/westnordost/osmfeatures/IDLocalizedFeatureCollection\n*L\n21#1:87,4\n37#1:92,7\n57#1:99,7\n*E\n"})
public final class IDLocalizedFeatureCollection
implements LocalizedFeatureCollection {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ResourceAccessAdapter fileAccess;
    @NotNull
    private final LinkedHashMap<String, BaseFeature> featuresById;
    @NotNull
    private final HashMap<String, Lazy<List<LocalizedFeature>>> localizedFeaturesList;
    @NotNull
    private final HashMap<List<String>, Lazy<LinkedHashMap<String, Feature>>> localizedFeatures;
    @NotNull
    private static final String FEATURES_FILE = "presets.json";

    /*
     * WARNING - void declaration
     */
    public IDLocalizedFeatureCollection(@NotNull ResourceAccessAdapter fileAccess) {
        void $this$associateByTo$iv;
        Intrinsics.checkNotNullParameter((Object)fileAccess, (String)"fileAccess");
        this.fileAccess = fileAccess;
        this.localizedFeaturesList = new HashMap();
        this.localizedFeatures = new HashMap();
        Iterable iterable = this.loadFeatures();
        Map map = new LinkedHashMap();
        IDLocalizedFeatureCollection iDLocalizedFeatureCollection = this;
        boolean $i$f$associateByTo = false;
        for (Object element$iv : $this$associateByTo$iv) {
            void it;
            void destination$iv;
            BaseFeature baseFeature = (BaseFeature)element$iv;
            void var10_10 = destination$iv;
            boolean bl = false;
            var10_10.put(it.getId(), element$iv);
        }
        iDLocalizedFeatureCollection.featuresById = (LinkedHashMap)map;
    }

    @Override
    @NotNull
    public Collection<Feature> getAll(@NotNull List<String> languages) {
        Intrinsics.checkNotNullParameter(languages, (String)"languages");
        Collection<Feature> collection = this.getOrLoadLocalizedFeatures(languages).values();
        Intrinsics.checkNotNullExpressionValue(collection, (String)"<get-values>(...)");
        return collection;
    }

    @Override
    @Nullable
    public Feature get(@NotNull String id, @NotNull List<String> languages) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter(languages, (String)"languages");
        return this.getOrLoadLocalizedFeatures(languages).get(id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final List<BaseFeature> loadFeatures() {
        List<BaseFeature> list;
        AutoCloseable autoCloseable = (AutoCloseable)this.fileAccess.open(FEATURES_FILE);
        Throwable throwable = null;
        try {
            Source it = (Source)autoCloseable;
            boolean bl = false;
            list = new IDPresetsJsonParser(false, 1, null).parse(it);
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
        return list;
    }

    private final LinkedHashMap<String, Feature> getOrLoadLocalizedFeatures(List<String> languages) {
        Object object;
        Map $this$getOrPut$iv = this.localizedFeatures;
        boolean $i$f$getOrPut = false;
        Object value$iv = $this$getOrPut$iv.get(languages);
        if (value$iv == null) {
            boolean bl = false;
            Lazy answer$iv = LazyKt.lazy((Function0)((Function0)new Function0<LinkedHashMap<String, Feature>>(this, languages){
                final /* synthetic */ IDLocalizedFeatureCollection this$0;
                final /* synthetic */ List<String> $languages;
                {
                    this.this$0 = $receiver;
                    this.$languages = $languages;
                    super(0);
                }

                @NotNull
                public final LinkedHashMap<String, Feature> invoke() {
                    return IDLocalizedFeatureCollection.access$loadLocalizedFeatures(this.this$0, this.$languages);
                }
            }));
            $this$getOrPut$iv.put(languages, answer$iv);
            object = answer$iv;
        } else {
            object = value$iv;
        }
        return (LinkedHashMap)((Lazy)object).getValue();
    }

    private final LinkedHashMap<String, Feature> loadLocalizedFeatures(List<String> languages) {
        LinkedHashMap<String, Feature> result = new LinkedHashMap<String, Feature>(this.featuresById.size());
        for (String language : CollectionsKt.asReversed(languages)) {
            if (language != null) {
                for (String languageComponent : IDLocalizedFeatureCollectionKt.access$getLanguageComponents(language)) {
                    List<LocalizedFeature> features = this.getOrLoadLocalizedFeaturesList(languageComponent);
                    for (LocalizedFeature feature : features) {
                        ((Map)result).put(feature.getId(), feature);
                    }
                }
                continue;
            }
            result.putAll((Map<String, Feature>)this.featuresById);
        }
        return result;
    }

    private final List<LocalizedFeature> getOrLoadLocalizedFeaturesList(String language) {
        Object object;
        Map $this$getOrPut$iv = this.localizedFeaturesList;
        boolean $i$f$getOrPut = false;
        Object value$iv = $this$getOrPut$iv.get(language);
        if (value$iv == null) {
            boolean bl = false;
            Lazy answer$iv = LazyKt.lazy((Function0)((Function0)new Function0<List<? extends LocalizedFeature>>(this, language){
                final /* synthetic */ IDLocalizedFeatureCollection this$0;
                final /* synthetic */ String $language;
                {
                    this.this$0 = $receiver;
                    this.$language = $language;
                    super(0);
                }

                @NotNull
                public final List<LocalizedFeature> invoke() {
                    return IDLocalizedFeatureCollection.access$loadLocalizedFeaturesList(this.this$0, this.$language);
                }
            }));
            $this$getOrPut$iv.put(language, answer$iv);
            object = answer$iv;
        } else {
            object = value$iv;
        }
        return (List)((Lazy)object).getValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final List<LocalizedFeature> loadLocalizedFeaturesList(String language) {
        List<LocalizedFeature> list;
        String filename;
        String string = language;
        String string2 = filename = string != null ? IDLocalizedFeatureCollection.Companion.getLocalizationFilename(string) : "en.json";
        if (!this.fileAccess.exists(filename)) {
            return CollectionsKt.emptyList();
        }
        AutoCloseable autoCloseable = (AutoCloseable)this.fileAccess.open(filename);
        Throwable throwable = null;
        try {
            Source source = (Source)autoCloseable;
            boolean bl = false;
            list = new IDPresetsTranslationJsonParser().parse(source, language, (Map<String, BaseFeature>)this.featuresById);
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
        return list;
    }

    public static final /* synthetic */ LinkedHashMap access$loadLocalizedFeatures(IDLocalizedFeatureCollection $this, List languages) {
        return $this.loadLocalizedFeatures(languages);
    }

    public static final /* synthetic */ List access$loadLocalizedFeaturesList(IDLocalizedFeatureCollection $this, String language) {
        return $this.loadLocalizedFeaturesList(language);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0004H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lde/westnordost/osmfeatures/IDLocalizedFeatureCollection$Companion;", "", "()V", "FEATURES_FILE", "", "getLocalizationFilename", "language", "osmfeatures"})
    public static final class Companion {
        private Companion() {
        }

        private final String getLocalizationFilename(String language) {
            return language + ".json";
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

